/*
 * Decompiled with CFR 0.152.
 */
package net.kosmo.music.toast;

import java.util.Objects;
import net.kosmo.music.ClientMusic;
import net.kosmo.music.utils.resource.AlbumCover;
import net.kosmo.music.utils.resource.MusicManager;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_368;
import net.minecraft.class_374;
import net.minecraft.class_4587;
import org.joml.Quaternionf;

public class MusicToast
implements class_368 {
    private static final class_2960 TEXTURE = new class_2960("musicnotification", "toast/background");
    private static final class_2960 TEXTURE_EXTENDED = new class_2960("musicnotification", "toast/background_extended");
    private final Type type = Type.DEFAULT;
    private boolean justUpdated;
    private long startTime;
    private int rotation;
    private class_2561 title;
    private class_2561 author;
    private class_2561 albumName;
    private AlbumCover albumCover;

    public MusicToast(MusicManager.Music music) {
        this.title = class_2561.method_43470((String)music.getTitle());
        this.author = class_2561.method_43470((String)music.getAuthor());
        this.albumName = class_2561.method_43470((String)music.getAlbumName());
        this.albumCover = music.albumCover;
        this.justUpdated = true;
    }

    public static void show(class_374 manager, MusicManager.Music music) {
        if (!ClientMusic.isVolumeZero()) {
            return;
        }
        MusicToast musicToast = (MusicToast)manager.method_1997(MusicToast.class, (Object)Type.DEFAULT);
        if (musicToast == null) {
            ClientMusic.LOGGER.debug("Showing toast for {}", (Object)music.identifier);
            manager.method_1999((class_368)new MusicToast(music));
        } else {
            ClientMusic.LOGGER.debug("Setting toast content: {} {}", (Object)music.identifier, (Object)musicToast);
            musicToast.setContent(music);
        }
        ClientMusic.musicHistory.addMusic(music);
    }

    public void setContent(MusicManager.Music music) {
        this.title = class_2561.method_43470((String)music.getTitle());
        this.author = class_2561.method_43470((String)music.getAuthor());
        this.albumName = class_2561.method_43470((String)music.getAlbumName());
        this.albumCover = music.albumCover;
        this.justUpdated = true;
    }

    public class_368.class_369 method_1986(class_332 context, class_374 manager, long startTime) {
        if (this.rotation >= 360) {
            this.rotation = 0;
        }
        ++this.rotation;
        if (this.justUpdated) {
            this.startTime = startTime;
            this.justUpdated = false;
        }
        if (ClientMusic.config.TOAST_CONFIG.SHOW_ALBUM_NAME) {
            context.method_52706(TEXTURE_EXTENDED, 0, 0, this.method_29049(), this.method_29050());
        } else {
            context.method_52706(TEXTURE, 0, 0, this.method_29049(), this.method_29050());
        }
        context.method_51448().method_22903();
        if (ClientMusic.config.TOAST_CONFIG.ROTATE_ALBUM_COVER) {
            class_4587 matrices = context.method_51448();
            matrices.method_46416(0.0f, 0.0f, 0.0f);
            matrices.method_46416(16.0f, 16.0f, 0.0f);
            matrices.method_22907(new Quaternionf().rotateLocalZ((float)Math.toRadians(this.rotation)));
            matrices.method_46416(-16.0f, -16.0f, 0.0f);
            matrices.method_46416(0.0f, 0.0f, 0.0f);
        }
        this.albumCover.drawAlbumCover(context, 6, 6);
        context.method_51448().method_22909();
        context.method_51439(manager.method_1995().field_1772, this.title, 30, 7, -11534256, false);
        if (ClientMusic.config.TOAST_CONFIG.SHOW_AUTHOR) {
            context.method_51439(manager.method_1995().field_1772, this.author, 30, 18, -16777216, false);
        }
        if (ClientMusic.config.TOAST_CONFIG.SHOW_ALBUM_NAME) {
            class_327 class_3272 = manager.method_1995().field_1772;
            int n = this.method_29049() - 4;
            Objects.requireNonNull(manager.method_1995().field_1772);
            ClientMusic.drawScrollableText(context, class_3272, this.albumName, 30, 30, 29, n, 29 + 9, -16777216, false, context.method_51421() - 160 + 30, 0, context.method_51421() - 4, 44);
        }
        return (double)(startTime - this.startTime) >= 5000.0 * manager.method_48221() ? class_368.class_369.field_2209 : class_368.class_369.field_2210;
    }

    public int method_29050() {
        if (ClientMusic.config.TOAST_CONFIG.SHOW_ALBUM_NAME) {
            return 44;
        }
        return 32;
    }

    public Type getType() {
        return this.type;
    }

    public static enum Type {
        DEFAULT;

    }
}

