/*
 * Decompiled with CFR 0.152.
 */
package net.jsa2025.calcmod.commands.subcommands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.jsa2025.calcmod.commands.CalcCommand;
import net.jsa2025.calcmod.commands.subcommands.Help;
import net.jsa2025.calcmod.utils.CalcMessageBuilder;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;

public class Rates {
    static DecimalFormat df = new DecimalFormat("#.##");
    static NumberFormat nf = NumberFormat.getInstance(new Locale("en", "US"));
    public static String helpMessage = "\u00a7b\u00a7LRates:\u00a7r\u00a7f\n    Given a number of items and afk time in seconds \u00a77\u00a7o(can be in expression form)\u00a7r\u00a7f, returns the number of items per hour.\n    \u00a7eUsage: /calc rates <numberofitems> <time>\u00a7f\n";

    public static LiteralArgumentBuilder<FabricClientCommandSource> register(LiteralArgumentBuilder<FabricClientCommandSource> command) {
        command.then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"rates").then(ClientCommandManager.argument((String)"numberofitems", (ArgumentType)StringArgumentType.string()).then(ClientCommandManager.argument((String)"time", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            CalcMessageBuilder message = Rates.execute(((FabricClientCommandSource)ctx.getSource()).getEntity(), StringArgumentType.getString((CommandContext)ctx, (String)"numberofitems"), StringArgumentType.getString((CommandContext)ctx, (String)"time"));
            CalcCommand.sendMessage((FabricClientCommandSource)ctx.getSource(), message);
            return 1;
        })))).then(ClientCommandManager.literal((String)"help").executes(ctx -> {
            CalcMessageBuilder message = Help.execute("rates");
            CalcCommand.sendMessage((FabricClientCommandSource)ctx.getSource(), message);
            return 1;
        })));
        return command;
    }

    public static LiteralArgumentBuilder<class_2168> registerServer(LiteralArgumentBuilder<class_2168> command) {
        command.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"rates").then(class_2170.method_9244((String)"numberofitems", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"time", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            CalcMessageBuilder message = Rates.execute(((class_2168)ctx.getSource()).method_9228(), StringArgumentType.getString((CommandContext)ctx, (String)"numberofitems"), StringArgumentType.getString((CommandContext)ctx, (String)"time"));
            CalcCommand.sendMessageServer((class_2168)ctx.getSource(), message);
            return 1;
        })))).then(class_2170.method_9247((String)"help").executes(ctx -> {
            CalcMessageBuilder message = Help.execute("rates");
            CalcCommand.sendMessageServer((class_2168)ctx.getSource(), message);
            return 1;
        })));
        return command;
    }

    public static CalcMessageBuilder execute(class_1297 player, String numberofitems, String time) {
        double items = CalcCommand.getParsedExpression(player, numberofitems, new Integer[0]);
        double timeDouble = CalcCommand.getParsedExpression(player, time, new Integer[0]);
        double itemspersecond = items / timeDouble;
        double rates = itemspersecond * 3600.0;
        CalcMessageBuilder message = new CalcMessageBuilder().addFromArray(new String[]{"input", " Items in ", "input", " Seconds = ", "result", "/hr"}, new String[]{numberofitems, time}, new String[]{nf.format(rates)});
        return message;
    }
}

