/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.adaptivetooltips.helpers;

import dev.isxander.adaptivetooltips.config.AdaptiveTooltipConfig;
import dev.isxander.adaptivetooltips.mixins.ClientTextTooltipAccessor;
import dev.isxander.adaptivetooltips.utils.TextUtil;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5683;
import net.minecraft.class_5684;
import net.minecraft.class_8000;
import net.minecraft.class_8001;

public class TooltipWrapper {
    public static List<class_5481> wrapTooltipLines(int screenWidth, int screenHeight, class_327 textRenderer, List<? extends class_2561> lines, int x, class_8000 tooltipPositioner) {
        if (lines.stream().allMatch(text -> text.getString().isBlank())) {
            return List.of();
        }
        int maxWidth = TooltipWrapper.getMaxWidth(textRenderer, lines);
        int allowedMaxWidth = 0;
        switch (((AdaptiveTooltipConfig)AdaptiveTooltipConfig.HANDLER.instance()).wrapText) {
            case OFF: {
                allowedMaxWidth = Integer.MAX_VALUE;
                break;
            }
            case SCREEN_WIDTH: {
                allowedMaxWidth = screenWidth - 15;
                break;
            }
            case REMAINING_WIDTH: {
                if (tooltipPositioner instanceof class_8001) {
                    allowedMaxWidth = screenWidth - x - 15;
                    if (x + 12 + maxWidth <= screenWidth) break;
                    allowedMaxWidth = Math.max(allowedMaxWidth, x - 20);
                    break;
                }
                allowedMaxWidth = Integer.MAX_VALUE;
                break;
            }
            case HALF_SCREEN_WIDTH: {
                allowedMaxWidth = screenWidth / 2;
                break;
            }
            case SMART: {
                if (lines.size() <= 1) {
                    allowedMaxWidth = screenWidth / 4 * 3;
                    break;
                }
                AtomicInteger idx = new AtomicInteger(0);
                Map<Integer, Integer> widths = lines.stream().map(arg_0 -> ((class_327)textRenderer).method_27525(arg_0)).map(width -> new AbstractMap.SimpleEntry<Integer, Integer>(idx.getAndIncrement(), (Integer)width)).filter(entry -> (Integer)entry.getValue() > 0).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
                ArrayList<AbstractMap.SimpleEntry<Integer, Integer>> arrayList = new ArrayList<AbstractMap.SimpleEntry<Integer, Integer>>();
                Iterator<Map.Entry<Integer, Integer>> iterator = widths.entrySet().iterator();
                int width2 = iterator.next().getValue();
                while (iterator.hasNext()) {
                    Map.Entry<Integer, Integer> entry2 = iterator.next();
                    int diff = entry2.getValue() - width2;
                    width2 = entry2.getValue();
                    arrayList.add(new AbstractMap.SimpleEntry<Integer, Integer>(entry2.getKey(), diff));
                }
                Optional<Integer> index = arrayList.stream().filter(entry -> (Integer)entry.getValue() <= 100).sorted(Comparator.comparingInt(entry -> -((Integer)entry.getValue()).intValue())).map(Map.Entry::getKey).findFirst();
                allowedMaxWidth = index.map(integer -> Math.min(textRenderer.method_27525((class_5348)lines.get((int)integer)), screenWidth / 4 * 3)).orElse(screenWidth / 4 * 3);
            }
        }
        if (maxWidth <= allowedMaxWidth) {
            return lines.stream().map(class_2561::method_30937).collect(Collectors.toList());
        }
        ArrayList<class_5481> wrapped = new ArrayList<class_5481>();
        for (class_2561 class_25612 : lines) {
            wrapped.addAll(textRenderer.method_1728((class_5348)class_25612, allowedMaxWidth));
        }
        return wrapped;
    }

    public static List<class_5684> wrapComponents(List<class_5684> components, class_327 font, int screenWidth, int screenHeight, int x, class_8000 tooltipPositioner) {
        ArrayList<class_5684> wrapped = new ArrayList<class_5684>();
        ArrayList<class_2561> groupedText = new ArrayList<class_2561>();
        for (class_5684 component : components) {
            if (component instanceof class_5683) {
                class_5683 textTooltip = (class_5683)component;
                class_5481 charSequence = ((ClientTextTooltipAccessor)textTooltip).getText();
                class_5250 text = TextUtil.toText(charSequence);
                groupedText.add((class_2561)text);
                continue;
            }
            if (!groupedText.isEmpty()) {
                wrapped.addAll(TooltipWrapper.convertComponentToTooltip(groupedText, font, screenWidth, screenHeight, x, tooltipPositioner));
                groupedText.clear();
            }
            wrapped.add(component);
        }
        if (!groupedText.isEmpty()) {
            wrapped.addAll(TooltipWrapper.convertComponentToTooltip(groupedText, font, screenWidth, screenHeight, x, tooltipPositioner));
            groupedText.clear();
        }
        return wrapped;
    }

    private static List<class_5683> convertComponentToTooltip(List<class_2561> lines, class_327 font, int screenWidth, int screenHeight, int x, class_8000 tooltipPositioner) {
        return TooltipWrapper.wrapTooltipLines(screenWidth, screenHeight, font, lines, x, tooltipPositioner).stream().map(class_5683::new).toList();
    }

    private static int getMaxWidth(class_327 textRenderer, List<? extends class_2561> lines) {
        int maxWidth = 0;
        for (class_2561 class_25612 : lines) {
            int width = textRenderer.method_27525((class_5348)class_25612);
            if (width <= maxWidth) continue;
            maxWidth = width;
        }
        return maxWidth;
    }
}

