/*
 * Decompiled with CFR 0.152.
 */
package io.github.moremcmeta.moremcmeta.api.client.texture;

import java.util.Objects;
import net.minecraft.class_2960;

public final class SpriteName {
    private static final String TEX_PATH_PREFIX = "textures/";
    private static final int TEX_PATH_PREFIX_LENGTH = "textures/".length();
    private static final String TEX_PATH_SUFFIX = ".png";
    private static final int TEX_PATH_SUFFIX_LENGTH = ".png".length();
    private static final int EMPTY_PATH_LENGTH = TEX_PATH_PREFIX_LENGTH + TEX_PATH_SUFFIX_LENGTH;

    public static class_2960 fromTexturePath(class_2960 texturePath) {
        Objects.requireNonNull(texturePath, "Texture path cannot be null");
        String path = texturePath.method_12832();
        if (path.startsWith(TEX_PATH_PREFIX) && path.endsWith(TEX_PATH_SUFFIX) && path.length() > EMPTY_PATH_LENGTH) {
            path = path.substring(TEX_PATH_PREFIX_LENGTH, path.length() - TEX_PATH_SUFFIX_LENGTH);
        }
        return new class_2960(texturePath.method_12836(), path);
    }

    public static class_2960 toTexturePath(class_2960 spriteName) {
        Objects.requireNonNull(spriteName, "Sprite name cannot be null");
        String path = spriteName.method_12832();
        if (!SpriteName.isSpriteName(spriteName)) {
            return spriteName;
        }
        return new class_2960(spriteName.method_12836(), String.format("%s%s%s", TEX_PATH_PREFIX, path, TEX_PATH_SUFFIX));
    }

    public static boolean isSpriteName(class_2960 location) {
        Objects.requireNonNull(location, "Location cannot be null");
        String path = location.method_12832();
        return !path.startsWith(TEX_PATH_PREFIX) && !path.endsWith(TEX_PATH_SUFFIX) && path.length() > 0;
    }

    private SpriteName() {
    }
}

