/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.dynamiccrosshair.handler;

import mod.crend.dynamiccrosshair.api.CrosshairContext;
import mod.crend.dynamiccrosshair.api.DynamicCrosshairApi;
import mod.crend.dynamiccrosshair.api.ItemCategory;
import mod.crend.dynamiccrosshair.component.Crosshair;
import mod.crend.dynamiccrosshair.handler.VanillaBlockHandler;
import mod.crend.dynamiccrosshair.handler.VanillaEntityHandler;
import mod.crend.dynamiccrosshair.handler.VanillaItemHandler;
import mod.crend.dynamiccrosshair.handler.VanillaUsableItemHandler;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1787;
import net.minecraft.class_1799;
import net.minecraft.class_2680;
import net.minecraft.class_7714;

public class VanillaApiImpl
implements DynamicCrosshairApi {
    private boolean fishHookStatus;

    @Override
    public String getNamespace() {
        return "minecraft";
    }

    @Override
    public boolean forceCheck() {
        return true;
    }

    @Override
    public boolean forceInvalidate(CrosshairContext context) {
        if (context.isWithEntity() && context.getEntity().method_5864() == class_1299.field_6131) {
            return true;
        }
        if (context.isWithBlock() && context.getBlock() instanceof class_7714) {
            return true;
        }
        if (context.getItem() instanceof class_1787) {
            boolean newFishHookStatus;
            boolean bl = newFishHookStatus = context.player.field_7513 != null;
            if (newFishHookStatus != this.fishHookStatus) {
                this.fishHookStatus = newFishHookStatus;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isAlwaysUsableItem(class_1799 itemStack) {
        return VanillaUsableItemHandler.isAlwaysUsableItem(itemStack);
    }

    @Override
    public boolean isUsableItem(class_1799 itemStack) {
        return VanillaUsableItemHandler.isUsableItem(itemStack);
    }

    @Override
    public ItemCategory getItemCategory(class_1799 itemStack) {
        if (VanillaUsableItemHandler.isAlwaysUsableItem(itemStack) || VanillaUsableItemHandler.isUsableItem(itemStack)) {
            return ItemCategory.USABLE;
        }
        if (VanillaItemHandler.isMeleeWeapon(itemStack)) {
            return ItemCategory.MELEE_WEAPON;
        }
        if (VanillaItemHandler.isTool(itemStack)) {
            return ItemCategory.TOOL;
        }
        if (VanillaItemHandler.isRangedWeapon(itemStack)) {
            return ItemCategory.RANGED_WEAPON;
        }
        if (VanillaItemHandler.isThrowable(itemStack)) {
            return ItemCategory.THROWABLE;
        }
        if (VanillaItemHandler.isShield(itemStack)) {
            return ItemCategory.SHIELD;
        }
        if (VanillaItemHandler.isBlockItem(itemStack)) {
            return ItemCategory.BLOCK;
        }
        return ItemCategory.NONE;
    }

    @Override
    public boolean isInteractableEntity(class_1297 entity) {
        return VanillaEntityHandler.isEntityInteractable(entity);
    }

    @Override
    public boolean isAlwaysInteractableBlock(class_2680 blockState) {
        return VanillaBlockHandler.isAlwaysInteractableBlock(blockState);
    }

    @Override
    public boolean isInteractableBlock(class_2680 blockState) {
        return VanillaBlockHandler.isInteractableBlock(blockState);
    }

    @Override
    public Crosshair computeFromEntity(CrosshairContext context) {
        return VanillaEntityHandler.checkEntity(context);
    }

    @Override
    public Crosshair computeFromBlock(CrosshairContext context) {
        return VanillaBlockHandler.checkBlockInteractable(context);
    }

    @Override
    public Crosshair computeFromItem(CrosshairContext context) {
        Crosshair toolCrosshair;
        Crosshair crosshair = null;
        if (context.includeUsableItem()) {
            crosshair = VanillaUsableItemHandler.checkUsableItem(context);
        }
        if (context.includeRangedWeapon() && crosshair == null && (crosshair = VanillaItemHandler.checkRangedWeapon(context)) != null) {
            return crosshair;
        }
        if (context.includeMeleeWeapon() && crosshair == null && (crosshair = VanillaItemHandler.checkMeleeWeapon(context)) != null) {
            return crosshair;
        }
        if (context.includeTool() && (toolCrosshair = VanillaItemHandler.checkTool(context)) != null) {
            if (context.isWithBlock()) {
                toolCrosshair = Crosshair.combine(toolCrosshair, VanillaBlockHandler.checkToolWithBlock(context));
            }
            crosshair = Crosshair.combine(crosshair, toolCrosshair);
        }
        if (crosshair != null) {
            return crosshair;
        }
        if (context.includeThrowable() && (crosshair = VanillaItemHandler.checkThrowable(context)) != null) {
            return crosshair;
        }
        if (context.includeShield() && (crosshair = VanillaItemHandler.checkShield(context)) != null) {
            return crosshair;
        }
        if (context.includeHoldingBlock()) {
            crosshair = VanillaItemHandler.checkBlockItem(context);
        }
        return crosshair;
    }
}

