/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds;

import com.qendolin.betterclouds.Config;
import com.qendolin.betterclouds.Main;
import com.qendolin.betterclouds.gui.ConfigScreen;
import com.qendolin.betterclouds.gui.CustomButtonOption;
import com.qendolin.betterclouds.gui.CustomIntegerFieldController;
import com.qendolin.betterclouds.gui.SelectController;
import dev.isxander.yacl3.api.ButtonOption;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.Controller;
import dev.isxander.yacl3.api.LabelOption;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.gui.controllers.BooleanController;
import dev.isxander.yacl3.gui.controllers.ColorController;
import dev.isxander.yacl3.gui.controllers.TickBoxController;
import dev.isxander.yacl3.gui.controllers.slider.FloatSliderController;
import dev.isxander.yacl3.gui.controllers.slider.IntegerSliderController;
import dev.isxander.yacl3.gui.controllers.string.StringController;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_437;
import net.minecraft.class_5250;

public class ConfigGUI {
    protected final Config config;
    protected final Config defaults;
    public final Option<Integer> chunkSize;
    public final Option<Float> distance;
    public final Option<Float> fuzziness;
    public final Option<Float> spacing;
    public final Option<Float> sparsity;
    public final Option<Boolean> shuffle;
    public final Option<Float> saturation;
    public final Option<Color> tint;
    public final Option<Float> gamma;
    public final Option<Float> dayBrightness;
    public final Option<Float> nightBrightness;
    public final Option<Integer> sunriseStartTime;
    public final Option<Integer> sunriseEndTime;
    public final Option<Integer> sunsetStartTime;
    public final Option<Integer> sunsetEndTime;
    public final Option<Float> randomPlacement;
    public final Option<Float> yRange;
    public final Option<Float> yOffset;
    public final Option<Float> samplingScale;
    public final Option<Float> sizeXZ;
    public final Option<Float> sizeY;
    public final Option<Float> scaleFalloffMin;
    public final Option<Float> travelSpeed;
    public final Option<Float> windEffectFactor;
    public final Option<Float> windSpeedFactor;
    public final Option<Float> colorVariationFactor;
    public final Option<Boolean> celestialBodyHalo;
    public final Option<Boolean> enabled;
    public final Option<Float> opacity;
    public final Option<Float> opacityFactor;
    public final Option<Float> opacityExponent;
    public final Option<Float> fadeEdge;
    public final LabelOption irisDisclaimer;
    public final Option<Boolean> irisSupport;
    public final Option<Boolean> cloudOverride;
    public final Option<Float> sunPathAngle;
    public final Option<Boolean> useIrisFBO;
    public final Option<Float> upscaleResolutionFactor;
    public final Option<Boolean> usePersistentBuffers;
    public final Option<Boolean> useFrustumCulling;
    public final Option<Integer> selectedPreset;
    public final Option<String> presetTitle;
    public final List<Integer> worldCurvatureValues = List.of(0, -256, -512, -1024, -2048, -4096, -8192, -16384, 16384, 8192, 4096, 2048, 1024, 512, 256, 128, 64, 32, 16);
    public final Option<Integer> worldCurvatureSize;
    public final ButtonOption copyPresetButton;
    public final ButtonOption removePresetButton;
    protected final List<class_3545<ConfigCategory.Builder, List<class_3545<OptionGroup.Builder, List<Option<?>>>>>> categories = new ArrayList();
    protected final List<class_3545<OptionGroup.Builder, List<Option<?>>>> commonCategory = new ArrayList();
    protected final List<class_3545<OptionGroup.Builder, List<Option<?>>>> generationCategory = new ArrayList();
    protected final List<class_3545<OptionGroup.Builder, List<Option<?>>>> appearanceCategory = new ArrayList();
    protected final List<class_3545<OptionGroup.Builder, List<Option<?>>>> performanceCategory = new ArrayList();
    protected final List<class_3545<OptionGroup.Builder, List<Option<?>>>> shadersCategory = new ArrayList();
    protected final List<Option<?>> commonPresetsGroup = new ArrayList();
    protected final List<Option<?>> commonGenerationGroup = new ArrayList();
    protected final List<Option<?>> commonAppearanceGroup = new ArrayList();
    protected final List<Option<?>> commonShadersGroup = new ArrayList();
    protected final List<Option<?>> generationVisualGroup = new ArrayList();
    protected final List<Option<?>> generationPerformanceGroup = new ArrayList();
    protected final List<Option<?>> appearanceGeometryGroup = new ArrayList();
    protected final List<Option<?>> appearanceVisibilityGroup = new ArrayList();
    protected final List<Option<?>> appearanceColorGroup = new ArrayList();
    protected final List<Option<?>> appearanceSkyGroup = new ArrayList();
    protected final List<Option<?>> performanceGenerationGroup = new ArrayList();
    protected final List<Option<?>> performanceTechnicalGroup = new ArrayList();
    protected final List<Option<?>> shadersGeneralGroup = new ArrayList();
    protected final List<Option<?>> shadersPresetGroup = new ArrayList();
    protected final List<Option<?>> shadersColorGroup = new ArrayList();
    protected final List<Option<?>> shadersMiscGroup = new ArrayList();
    protected final List<Option<?>> shadersTechnicalGroup = new ArrayList();
    protected final List<Option<?>> shaderConfigPresetOptions = new ArrayList();
    protected final List<Config.ShaderConfigPreset> presetsToBeDeleted = new ArrayList<Config.ShaderConfigPreset>();
    public static final String LANG_KEY_PREFIX = "betterclouds.config";

    public ConfigGUI(Config defaults, Config config) {
        this.defaults = defaults;
        this.config = config;
        config.addFirstPreset();
        config.sortPresets();
        this.chunkSize = ConfigGUI.createOption(Integer.TYPE, "chunkSize").binding((Object)defaults.chunkSize, () -> config.chunkSize, val -> {
            config.chunkSize = val;
        }).customController(opt -> new IntegerSliderController(opt, 16, 128, 8)).build();
        this.distance = ConfigGUI.createOption(Float.TYPE, "distance").binding((Object)Float.valueOf(defaults.distance), () -> Float.valueOf(config.distance), val -> {
            config.distance = val.floatValue();
        }).customController(opt -> new FloatSliderController(opt, 1.0f, 4.0f, 0.05f, ConfigGUI::formatAsTimes)).build();
        this.fuzziness = ConfigGUI.createOption(Float.TYPE, "fuzziness").binding((Object)Float.valueOf(defaults.fuzziness), () -> Float.valueOf(config.fuzziness), val -> {
            config.fuzziness = val.floatValue();
        }).customController(opt -> new FloatSliderController(opt, 0.0f, 1.0f, 0.01f, ConfigGUI::formatAsPercent)).build();
        this.spacing = ConfigGUI.createOption(Float.TYPE, "spacing").binding((Object)Float.valueOf(defaults.spacing), () -> Float.valueOf(config.spacing), val -> {
            config.spacing = val.floatValue();
        }).customController(opt -> new FloatSliderController(opt, 2.0f, 64.0f, 0.25f)).build();
        this.sparsity = ConfigGUI.createOption(Float.TYPE, "sparsity").binding((Object)Float.valueOf(defaults.sparsity), () -> Float.valueOf(config.sparsity), val -> {
            config.sparsity = val.floatValue();
        }).customController(opt -> new FloatSliderController(opt, 0.0f, 1.0f, 0.01f, ConfigGUI::formatAsPercent)).build();
        this.shuffle = ConfigGUI.createOption(Boolean.TYPE, "shuffle").binding((Object)defaults.shuffle, () -> config.shuffle, val -> {
            config.shuffle = val;
        }).customController(TickBoxController::new).build();
        this.randomPlacement = ConfigGUI.createOption(Float.TYPE, "randomPlacement").binding((Object)Float.valueOf(defaults.randomPlacement), () -> Float.valueOf(config.randomPlacement), val -> {
            config.randomPlacement = val.floatValue();
        }).customController(opt -> new FloatSliderController(opt, 0.0f, 1.0f, 0.01f, ConfigGUI::formatAsPercent)).build();
        this.yRange = ConfigGUI.createOption(Float.TYPE, "yRange").binding((Object)Float.valueOf(defaults.yRange), () -> Float.valueOf(config.yRange), val -> {
            config.yRange = val.floatValue();
        }).customController(opt -> new FloatSliderController(opt, 0.0f, 128.0f, 0.5f)).build();
        this.yOffset = ConfigGUI.createOption(Float.TYPE, "yOffset").binding((Object)Float.valueOf(defaults.yOffset), () -> Float.valueOf(config.yOffset), val -> {
            config.yOffset = val.floatValue();
        }).customController(opt -> new FloatSliderController(opt, -64.0f, 256.0f, 8.0f)).build();
        this.samplingScale = ConfigGUI.createOption(Float.TYPE, "samplingScale").binding((Object)Float.valueOf(defaults.samplingScale), () -> Float.valueOf(config.samplingScale), val -> {
            config.samplingScale = val.floatValue();
        }).customController(opt -> new FloatSliderController(opt, 0.25f, 4.0f, 0.01f, ConfigGUI::formatAsTimes)).build();
        this.sizeXZ = ConfigGUI.createOption(Float.TYPE, "sizeXZ").binding((Object)Float.valueOf(defaults.sizeXZ), () -> Float.valueOf(config.sizeXZ), val -> {
            config.sizeXZ = val.floatValue();
        }).customController(opt -> new FloatSliderController(opt, 2.0f, 64.0f, 1.0f)).build();
        this.sizeY = ConfigGUI.createOption(Float.TYPE, "sizeY").binding((Object)Float.valueOf(defaults.sizeY), () -> Float.valueOf(config.sizeY), val -> {
            config.sizeY = val.floatValue();
        }).customController(opt -> new FloatSliderController(opt, 1.0f, 32.0f, 1.0f)).build();
        this.scaleFalloffMin = ConfigGUI.createOption(Float.TYPE, "scaleFalloffMin").binding((Object)Float.valueOf(defaults.scaleFalloffMin), () -> Float.valueOf(config.scaleFalloffMin), val -> {
            config.scaleFalloffMin = val.floatValue();
        }).customController(opt -> new FloatSliderController(opt, 0.0f, 1.0f, 0.05f, ConfigGUI::formatAsPercent)).build();
        this.travelSpeed = ConfigGUI.createOption(Float.TYPE, "travelSpeed").binding((Object)Float.valueOf(defaults.travelSpeed), () -> Float.valueOf(config.travelSpeed), val -> {
            config.travelSpeed = val.floatValue();
        }).customController(opt -> new FloatSliderController(opt, 0.0f, 0.1f, 0.005f, ConfigGUI::formatAsBlocksPerSecond)).build();
        this.windEffectFactor = ConfigGUI.createOption(Float.TYPE, "windEffectFactor").binding((Object)Float.valueOf(defaults.windEffectFactor), () -> Float.valueOf(config.windEffectFactor), val -> {
            config.windEffectFactor = val.floatValue();
        }).customController(opt -> new FloatSliderController(opt, 0.0f, 1.0f, 0.05f, ConfigGUI::formatAsPercent)).build();
        this.windSpeedFactor = ConfigGUI.createOption(Float.TYPE, "windSpeedFactor").binding((Object)Float.valueOf(defaults.windSpeedFactor), () -> Float.valueOf(config.windSpeedFactor), val -> {
            config.windSpeedFactor = val.floatValue();
        }).customController(opt -> new FloatSliderController(opt, 0.0f, 1.0f, 0.05f, ConfigGUI::formatAsPercent)).build();
        this.colorVariationFactor = ConfigGUI.createOption(Float.TYPE, "colorVariationFactor").binding((Object)Float.valueOf(defaults.colorVariationFactor), () -> Float.valueOf(config.colorVariationFactor), val -> {
            config.colorVariationFactor = val.floatValue();
        }).customController(opt -> new FloatSliderController(opt, 0.0f, 1.0f, 0.05f, ConfigGUI::formatAsPercent)).build();
        this.celestialBodyHalo = ConfigGUI.createOption(Boolean.TYPE, "celestialBodyHalo").binding((Object)defaults.celestialBodyHalo, () -> config.celestialBodyHalo, val -> {
            config.celestialBodyHalo = val;
        }).customController(TickBoxController::new).build();
        this.enabled = ConfigGUI.createOption(Boolean.TYPE, "enabled").binding((Object)defaults.enabled, () -> config.enabled, val -> {
            config.enabled = val;
        }).customController(opt -> new BooleanController(opt, val -> class_2561.method_43471((String)("betterclouds.config.entry.enabled." + val)), false)).build();
        this.fadeEdge = ConfigGUI.createOption(Float.TYPE, "fadeEdge").binding((Object)Float.valueOf(defaults.fadeEdge), () -> Float.valueOf(config.fadeEdge), val -> {
            config.fadeEdge = val.floatValue();
        }).customController(opt -> new FloatSliderController(opt, 0.1f, 0.5f, 0.01f, ConfigGUI::formatAsPercent)).build();
        this.irisDisclaimer = LabelOption.create((class_2561)class_2561.method_43471((String)"betterclouds.config.text.shaders"));
        this.irisSupport = ConfigGUI.createOption(Boolean.TYPE, "irisSupport").binding((Object)defaults.irisSupport, () -> config.irisSupport, val -> {
            config.irisSupport = val;
        }).customController(TickBoxController::new).build();
        this.cloudOverride = ConfigGUI.createOption(Boolean.TYPE, "cloudOverride").binding((Object)defaults.cloudOverride, () -> config.cloudOverride, val -> {
            config.cloudOverride = val;
        }).customController(TickBoxController::new).build();
        this.useIrisFBO = ConfigGUI.createOption(Boolean.TYPE, "useIrisFBO").binding((Object)defaults.useIrisFBO, () -> config.useIrisFBO, val -> {
            config.useIrisFBO = val;
        }).customController(TickBoxController::new).build();
        this.usePersistentBuffers = ConfigGUI.createOption(Boolean.TYPE, "usePersistentBuffers").binding((Object)defaults.usePersistentBuffers, () -> config.usePersistentBuffers, val -> {
            config.usePersistentBuffers = val;
        }).customController(TickBoxController::new).build();
        this.useFrustumCulling = ConfigGUI.createOption(Boolean.TYPE, "useFrustumCulling").binding((Object)defaults.useFrustumCulling, () -> config.useFrustumCulling, val -> {
            config.useFrustumCulling = val;
        }).customController(TickBoxController::new).build();
        this.selectedPreset = ConfigGUI.createOption(Integer.TYPE, "shaderPreset").binding((Object)defaults.selectedPreset, () -> config.selectedPreset, val -> {
            config.selectedPreset = val;
        }).customController(opt -> new SelectController<Config.ShaderConfigPreset>((Option<Integer>)opt, config.presets, (i, preset) -> {
            if (preset.title.isBlank()) {
                return class_2561.method_43471((String)"betterclouds.config.entry.shaderPreset.untitled").method_27694(style -> style.method_10977(class_124.field_1080).method_10978(Boolean.valueOf(true)));
            }
            if (!preset.editable) {
                return class_2561.method_43470((String)preset.title).method_27694(style -> style.method_10978(Boolean.valueOf(true)));
            }
            if (this.presetsToBeDeleted.contains(preset)) {
                return class_2561.method_43470((String)preset.title).method_27694(style -> style.method_36140(Boolean.valueOf(true)));
            }
            return class_2561.method_43470((String)preset.title);
        })).listener((opt, i) -> {
            opt.applyValue();
            Controller patt0$temp = opt.controller();
            if (patt0$temp instanceof SelectController) {
                SelectController select = (SelectController)patt0$temp;
                select.updateValues();
            }
            for (Option<?> option : this.shaderConfigPresetOptions) {
                option.forgetPendingValue();
                option.setAvailable(config.preset().editable);
            }
            this.updateRemovePresetButton();
        }).build();
        this.presetTitle = ConfigGUI.createOption(String.class, "presetTitle", false).binding((Object)"", () -> config.preset().title, val -> {
            config.preset().title = val;
        }).customController(StringController::new).build();
        this.saturation = ConfigGUI.createOption(Float.TYPE, "saturation").binding((Object)Float.valueOf(defaults.preset().saturation), () -> Float.valueOf(config.preset().saturation), val -> {
            config.preset().saturation = val.floatValue();
        }).customController(opt -> new FloatSliderController(opt, 0.0f, 2.0f, 0.05f, ConfigGUI::formatAsPercent)).build();
        this.tint = ConfigGUI.createOption(Color.class, "tint").binding((Object)new Color(defaults.preset().tintRed, defaults.preset().tintGreen, defaults.preset().tintBlue), () -> new Color(config.preset().tintRed, config.preset().tintGreen, config.preset().tintBlue), val -> {
            config.preset().tintRed = (float)val.getRed() / 255.0f;
            config.preset().tintGreen = (float)val.getGreen() / 255.0f;
            config.preset().tintBlue = (float)val.getBlue() / 255.0f;
        }).customController(ColorController::new).build();
        this.gamma = ConfigGUI.createOption(Float.TYPE, "gamma").binding((Object)Float.valueOf(defaults.preset().gamma), () -> Float.valueOf(config.preset().gamma), val -> {
            config.preset().gamma = val.floatValue();
        }).customController(opt -> new FloatSliderController(opt, -5.0f, 5.0f, 0.01f, ConfigGUI::formatAsTwoDecimals)).build();
        this.dayBrightness = ConfigGUI.createOption(Float.TYPE, "dayBrightness").binding((Object)Float.valueOf(defaults.preset().dayBrightness), () -> Float.valueOf(config.preset().dayBrightness), val -> {
            config.preset().dayBrightness = val.floatValue();
        }).customController(opt -> new FloatSliderController(opt, 0.1f, 4.0f, 0.01f, ConfigGUI::formatAsPercent)).build();
        this.nightBrightness = ConfigGUI.createOption(Float.TYPE, "nightBrightness").binding((Object)Float.valueOf(defaults.preset().nightBrightness), () -> Float.valueOf(config.preset().nightBrightness), val -> {
            config.preset().nightBrightness = val.floatValue();
        }).customController(opt -> new FloatSliderController(opt, 0.1f, 4.0f, 0.01f, ConfigGUI::formatAsPercent)).build();
        this.sunriseStartTime = ConfigGUI.createOption(Integer.TYPE, "sunriseStartTime").binding((Object)defaults.preset().sunriseStartTime, () -> config.preset().sunriseStartTime, val -> {
            config.preset().sunriseStartTime = val;
        }).customController(opt -> new CustomIntegerFieldController((Option<Integer>)opt, -6000, 6000)).build();
        this.sunriseEndTime = ConfigGUI.createOption(Integer.TYPE, "sunriseEndTime").binding((Object)defaults.preset().sunriseEndTime, () -> config.preset().sunriseEndTime, val -> {
            config.preset().sunriseEndTime = val;
        }).customController(opt -> new CustomIntegerFieldController((Option<Integer>)opt, -6000, 6000)).build();
        this.sunsetStartTime = ConfigGUI.createOption(Integer.TYPE, "sunsetStartTime").binding((Object)defaults.preset().sunsetStartTime, () -> config.preset().sunsetStartTime, val -> {
            config.preset().sunsetStartTime = val;
        }).customController(opt -> new CustomIntegerFieldController((Option<Integer>)opt, 6000, 18000)).build();
        this.sunsetEndTime = ConfigGUI.createOption(Integer.TYPE, "sunsetEndTime").binding((Object)defaults.preset().sunsetEndTime, () -> config.preset().sunsetEndTime, val -> {
            config.preset().sunsetEndTime = val;
        }).customController(opt -> new CustomIntegerFieldController((Option<Integer>)opt, 6000, 18000)).build();
        this.upscaleResolutionFactor = ConfigGUI.createOption(Float.TYPE, "upscaleResolutionFactor").binding((Object)Float.valueOf(defaults.preset().upscaleResolutionFactor), () -> Float.valueOf(config.preset().upscaleResolutionFactor), val -> {
            config.preset().upscaleResolutionFactor = val.floatValue();
        }).customController(opt -> new FloatSliderController(opt, 0.25f, 1.0f, 0.01f, ConfigGUI::formatAsPercent)).build();
        this.sunPathAngle = ConfigGUI.createOption(Float.TYPE, "sunPathAngle").binding((Object)Float.valueOf(defaults.preset().sunPathAngle), () -> Float.valueOf(config.preset().sunPathAngle), val -> {
            config.preset().sunPathAngle = val.floatValue();
        }).customController(opt -> new FloatSliderController(opt, -60.0f, 60.0f, 1.0f, ConfigGUI::formatAsDegrees)).build();
        this.opacityFactor = ConfigGUI.createOption(Float.TYPE, "opacityFactor").binding((Object)Float.valueOf(defaults.preset().opacityFactor), () -> Float.valueOf(config.preset().opacityFactor), val -> {
            config.preset().opacityFactor = val.floatValue();
        }).customController(opt -> new FloatSliderController(opt, 0.0f, 1.0f, 0.01f, ConfigGUI::formatAsPercent)).build();
        this.opacityExponent = ConfigGUI.createOption(Float.TYPE, "opacityExponent").binding((Object)Float.valueOf(defaults.preset().opacityExponent), () -> Float.valueOf(config.preset().opacityExponent), val -> {
            config.preset().opacityExponent = val.floatValue();
        }).customController(opt -> new FloatSliderController(opt, 0.25f, 4.0f, 0.01f, ConfigGUI::formatAsTwoDecimals)).build();
        this.opacity = ConfigGUI.createOption(Float.TYPE, "opacity").binding((Object)Float.valueOf(defaults.preset().opacity), () -> Float.valueOf(config.preset().opacity), val -> {
            config.preset().opacity = val.floatValue();
        }).customController(opt -> new FloatSliderController(opt, 0.0f, 1.0f, 0.01f, ConfigGUI::formatAsPercent)).build();
        this.worldCurvatureSize = ConfigGUI.createOption(Integer.TYPE, "worldCurvatureSize").binding((Object)Math.max(this.worldCurvatureValues.indexOf(defaults.preset().worldCurvatureSize), 0), () -> Math.max(this.worldCurvatureValues.indexOf(config.preset().worldCurvatureSize), 0), val -> {
            config.preset().worldCurvatureSize = this.worldCurvatureValues.get((int)val);
        }).customController(opt -> new IntegerSliderController(opt, 0, this.worldCurvatureValues.size() - 1, 1, i -> i == 0 ? class_2561.method_43471((String)"options.off") : class_2561.method_43470((String)this.worldCurvatureValues.get((int)i).toString()))).build();
        this.shaderConfigPresetOptions.addAll(List.of(this.presetTitle, this.saturation, this.tint, this.gamma, this.dayBrightness, this.nightBrightness, this.sunriseStartTime, this.sunriseEndTime, this.sunsetStartTime, this.sunsetEndTime, this.upscaleResolutionFactor, this.sunPathAngle, this.opacityFactor, this.opacityExponent, this.opacity, this.worldCurvatureSize));
        this.shaderConfigPresetOptions.forEach(opt -> opt.setAvailable(config.preset().editable));
        class_5250 removeButtonRemoveText = class_2561.method_43471((String)"betterclouds.config.entry.shaderPreset.remove");
        class_5250 removeButtonRestoreText = class_2561.method_43471((String)"betterclouds.config.entry.shaderPreset.restore");
        this.removePresetButton = CustomButtonOption.createBuilder().name(() -> this.lambda$new$125(config, (class_2561)removeButtonRestoreText, (class_2561)removeButtonRemoveText)).available(config.presets.size() > 1).action((screen, option) -> {
            if (config.presets.size() <= 1 || !config.preset().editable) {
                option.setAvailable(false);
                return;
            }
            if (this.presetsToBeDeleted.contains(config.preset())) {
                this.presetsToBeDeleted.remove(config.preset());
            } else {
                this.presetsToBeDeleted.add(config.preset());
            }
        }).build();
        this.updateRemovePresetButton();
        this.copyPresetButton = CustomButtonOption.createBuilder().name(() -> class_2561.method_43471((String)"betterclouds.config.entry.shaderPreset.copy")).action((screen, buttonOption) -> {
            Config.ShaderConfigPreset preset = new Config.ShaderConfigPreset(config.preset());
            preset.title = class_2561.method_43469((String)"betterclouds.config.entry.shaderPreset.copyOf", (Object[])new Object[]{config.preset().title}).getString();
            preset.markAsCopy();
            config.presets.add(0, preset);
            this.selectedPreset.requestSet((Object)0);
            Controller patt0$temp = this.selectedPreset.controller();
            if (patt0$temp instanceof SelectController) {
                SelectController select = (SelectController)patt0$temp;
                select.updateValues();
            }
            this.updateRemovePresetButton();
        }).build();
        this.categories.add(new class_3545((Object)ConfigCategory.createBuilder().name(ConfigGUI.categoryLabel("common")), this.commonCategory));
        this.commonCategory.add(new class_3545((Object)OptionGroup.createBuilder().name(ConfigGUI.groupLabel("common.presets")), this.commonPresetsGroup));
        this.commonPresetsGroup.addAll(List.of(this.selectedPreset, this.presetTitle, this.copyPresetButton, this.removePresetButton));
        this.commonCategory.add(new class_3545((Object)OptionGroup.createBuilder().name(ConfigGUI.groupLabel("common.generation")), this.commonGenerationGroup));
        this.commonGenerationGroup.addAll(List.of(this.sizeXZ, this.sizeY, this.spacing, this.samplingScale, this.distance));
        this.commonCategory.add(new class_3545((Object)OptionGroup.createBuilder().name(ConfigGUI.groupLabel("common.appearance")), this.commonAppearanceGroup));
        this.commonAppearanceGroup.addAll(List.of(this.enabled, this.opacity, this.opacityFactor));
        this.commonCategory.add(new class_3545((Object)OptionGroup.createBuilder().name(ConfigGUI.groupLabel("common.shaders")), this.commonShadersGroup));
        this.commonShadersGroup.addAll(List.of(this.irisDisclaimer, this.irisSupport, this.gamma, this.dayBrightness, this.nightBrightness, this.sunPathAngle));
        this.categories.add(new class_3545((Object)ConfigCategory.createBuilder().name(ConfigGUI.categoryLabel("generation")), this.generationCategory));
        this.generationCategory.add(new class_3545((Object)OptionGroup.createBuilder().name(ConfigGUI.groupLabel("generation.visual")), this.generationVisualGroup));
        this.generationVisualGroup.addAll(List.of(this.randomPlacement, this.fuzziness, this.sparsity, this.yRange, this.yOffset, this.spacing, this.samplingScale, this.shuffle));
        this.generationCategory.add(new class_3545((Object)OptionGroup.createBuilder().name(ConfigGUI.groupLabel("generation.performance")), this.generationPerformanceGroup));
        this.generationPerformanceGroup.addAll(List.of(this.distance, this.chunkSize));
        this.categories.add(new class_3545((Object)ConfigCategory.createBuilder().name(ConfigGUI.categoryLabel("appearance")), this.appearanceCategory));
        this.appearanceCategory.add(new class_3545((Object)OptionGroup.createBuilder().name(ConfigGUI.groupLabel("appearance.geometry")), this.appearanceGeometryGroup));
        this.appearanceGeometryGroup.addAll(List.of(this.sizeXZ, this.sizeY, this.scaleFalloffMin, this.travelSpeed, this.windEffectFactor, this.windSpeedFactor));
        this.appearanceCategory.add(new class_3545((Object)OptionGroup.createBuilder().name(ConfigGUI.groupLabel("appearance.visibility")), this.appearanceVisibilityGroup));
        this.appearanceVisibilityGroup.addAll(List.of(this.enabled, this.opacity, this.opacityFactor, this.opacityExponent, this.fadeEdge));
        this.appearanceCategory.add(new class_3545((Object)OptionGroup.createBuilder().name(ConfigGUI.groupLabel("appearance.color")), this.appearanceColorGroup));
        this.appearanceColorGroup.addAll(List.of(this.colorVariationFactor, this.gamma, this.dayBrightness, this.nightBrightness, this.saturation, this.tint));
        this.appearanceCategory.add(new class_3545((Object)OptionGroup.createBuilder().name(ConfigGUI.groupLabel("appearance.sky")), this.appearanceSkyGroup));
        this.appearanceSkyGroup.add(this.celestialBodyHalo);
        this.categories.add(new class_3545((Object)ConfigCategory.createBuilder().name(ConfigGUI.categoryLabel("performance")), this.performanceCategory));
        this.performanceCategory.add(new class_3545((Object)OptionGroup.createBuilder().name(ConfigGUI.groupLabel("performance.generation")), this.performanceGenerationGroup));
        this.performanceGenerationGroup.addAll(List.of(this.spacing, this.chunkSize, this.distance, this.sparsity, this.fuzziness, this.shuffle));
        this.performanceCategory.add(new class_3545((Object)OptionGroup.createBuilder().name(ConfigGUI.groupLabel("performance.technical")), this.performanceTechnicalGroup));
        this.performanceTechnicalGroup.addAll(List.of(this.usePersistentBuffers, this.useFrustumCulling));
        this.categories.add(new class_3545((Object)ConfigCategory.createBuilder().name(ConfigGUI.categoryLabel("shaders")), this.shadersCategory));
        this.shadersCategory.add(new class_3545((Object)OptionGroup.createBuilder().name(ConfigGUI.groupLabel("shaders.general")), this.shadersGeneralGroup));
        this.shadersGeneralGroup.addAll(List.of(this.irisDisclaimer, this.irisSupport, this.cloudOverride));
        this.shadersCategory.add(new class_3545((Object)OptionGroup.createBuilder().name(ConfigGUI.groupLabel("shaders.presets")), this.shadersPresetGroup));
        this.shadersPresetGroup.addAll(List.of(this.selectedPreset, this.presetTitle, this.copyPresetButton, this.removePresetButton));
        this.shadersCategory.add(new class_3545((Object)OptionGroup.createBuilder().name(ConfigGUI.groupLabel("shaders.color")), this.shadersColorGroup));
        this.shadersColorGroup.addAll(List.of(this.gamma, this.dayBrightness, this.nightBrightness, this.saturation, this.tint));
        this.shadersCategory.add(new class_3545((Object)OptionGroup.createBuilder().name(ConfigGUI.groupLabel("shaders.misc")), this.shadersMiscGroup));
        this.shadersMiscGroup.add(this.worldCurvatureSize);
        this.shadersCategory.add(new class_3545((Object)OptionGroup.createBuilder().name(ConfigGUI.groupLabel("shaders.technical")), this.shadersTechnicalGroup));
        this.shadersTechnicalGroup.addAll(List.of(this.sunPathAngle, this.sunriseStartTime, this.sunriseEndTime, this.sunsetStartTime, this.sunsetEndTime, this.upscaleResolutionFactor, this.useIrisFBO));
    }

    private void updateRemovePresetButton() {
        if (this.removePresetButton == null) {
            return;
        }
        this.removePresetButton.setAvailable(this.config.preset().editable && this.config.presets.size() > 1);
    }

    public static ConfigScreen create(class_437 parent) {
        YetAnotherConfigLib yacl = YetAnotherConfigLib.create(Main.getConfigHandler(), (defaults, config, builder) -> new ConfigGUI((Config)defaults, (Config)config).assemble(builder));
        return new ConfigScreen(yacl, parent);
    }

    public YetAnotherConfigLib.Builder assemble(YetAnotherConfigLib.Builder builder) {
        builder = builder.save(() -> {
            for (Config.ShaderConfigPreset preset : this.presetsToBeDeleted) {
                this.config.presets.remove(preset);
            }
            this.config.selectedPreset = class_3532.method_15340((int)this.config.selectedPreset, (int)0, (int)this.config.presets.size());
            this.config.sortPresets();
            Main.getConfigHandler().save();
        }).title((class_2561)class_2561.method_43471((String)"betterclouds.config.title"));
        for (class_3545<ConfigCategory.Builder, List<class_3545<OptionGroup.Builder, List<Option<?>>>>> categoryPair : this.categories) {
            ConfigCategory.Builder categoryBuilder = (ConfigCategory.Builder)categoryPair.method_15442();
            for (class_3545 groupPair : (List)categoryPair.method_15441()) {
                if (((List)groupPair.method_15441()).isEmpty()) continue;
                OptionGroup.Builder groupBuilder = (OptionGroup.Builder)groupPair.method_15442();
                groupBuilder.options((Collection)groupPair.method_15441());
                categoryBuilder.group(groupBuilder.build());
            }
            builder.category(categoryBuilder.build());
        }
        return builder;
    }

    private static <T> Option.Builder<T> createOption(Class<T> typeClass, String key) {
        return ConfigGUI.createOption(typeClass, key, true);
    }

    private static <T> Option.Builder<T> createOption(Class<T> typeClass, String key, boolean hasDescription) {
        Option.Builder builder = Option.createBuilder().name(ConfigGUI.optionLabel(key)).instant(true);
        if (hasDescription) {
            builder.description(OptionDescription.of((class_2561[])new class_2561[]{ConfigGUI.optionDescription(key)}));
        }
        return builder;
    }

    private static class_2561 formatAsBlocksPerSecond(Float value) {
        return class_2561.method_43469((String)"betterclouds.config.unit.blocks_per_second", (Object[])new Object[]{String.format("%.1f", Float.valueOf(value.floatValue() * 20.0f))});
    }

    private static class_2561 formatAsPercent(float value) {
        return class_2561.method_43469((String)"betterclouds.config.unit.percent", (Object[])new Object[]{(int)(value * 100.0f)});
    }

    private static class_2561 formatAsTimes(float value) {
        return class_2561.method_43469((String)"betterclouds.config.unit.times", (Object[])new Object[]{String.format("%.2f", Float.valueOf(value))});
    }

    private static class_2561 formatAsDegrees(Float value) {
        return class_2561.method_43469((String)"betterclouds.config.unit.degrees", (Object[])new Object[]{String.format("%.0f", value)});
    }

    private static class_2561 categoryLabel(String key) {
        return class_2561.method_43471((String)("betterclouds.config.category." + key));
    }

    private static class_2561 groupLabel(String key) {
        return class_2561.method_43471((String)("betterclouds.config.group." + key));
    }

    private static class_2561 optionLabel(String key) {
        return class_2561.method_43471((String)("betterclouds.config.entry." + key));
    }

    private static class_2561 optionDescription(String key) {
        return class_2561.method_43471((String)("betterclouds.config.entry." + key + ".description"));
    }

    private static class_2561 formatAsTwoDecimals(Float value) {
        return class_2561.method_43470((String)String.format("%,.2f", value).replaceAll("[\u00a0\u202f]", " "));
    }

    private /* synthetic */ class_2561 lambda$new$125(Config config, class_2561 removeButtonRestoreText, class_2561 removeButtonRemoveText) {
        return this.presetsToBeDeleted.contains(config.preset()) ? removeButtonRestoreText : removeButtonRemoveText;
    }
}

