/*
 * Decompiled with CFR 0.152.
 */
package com.HiWord9.RPRenames.util.config.generation;

import com.HiWord9.RPRenames.RPRenames;
import com.HiWord9.RPRenames.util.config.ConfigManager;
import com.HiWord9.RPRenames.util.config.Rename;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;

public class CITConfig {
    private static final List<String> ROOTS = List.of("mcpatcher", "optifine", "citresewn");

    public static void parseCITs(class_3300 resourceManager, class_3695 profiler) {
        profiler.method_15396("rprenames:collecting_cit_renames");
        for (String root : ROOTS) {
            for (Map.Entry entry : resourceManager.method_14488(root + "/cit", s -> s.method_12832().endsWith(".properties")).entrySet()) {
                try {
                    String packName = ConfigManager.validatePackName(((class_3298)entry.getValue()).method_14480());
                    CITConfig.propertiesToRename(ConfigManager.getPropFromResource((class_3298)entry.getValue()), packName, ConfigManager.getFullPathFromIdentifier(packName, (class_2960)entry.getKey()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        profiler.method_15407();
    }

    private static void propertiesToRename(Properties p, String packName, String path) {
        String enchantLvlProp;
        String firstEnchantLvl;
        String enchantIdProp;
        String firstDamage;
        int i;
        String matchItems = p.getProperty("matchItems");
        if (matchItems == null) {
            matchItems = p.getProperty("items");
        }
        if (matchItems == null) {
            return;
        }
        while (matchItems.endsWith(" ") || matchItems.endsWith("\t")) {
            matchItems = matchItems.substring(0, matchItems.length() - 1);
        }
        ArrayList<String> items = CITConfig.splitMatchItems(matchItems);
        String nbtNamePattern = p.getProperty("nbt.display.Name");
        String stackSizeProp = p.getProperty("stackSize");
        String firstStackSize = Rename.getFirstValue(stackSizeProp == null ? "" : stackSizeProp);
        Integer stackSize = null;
        if (!firstStackSize.isEmpty() && (i = Integer.parseInt(firstStackSize)) <= 64 && i > 0) {
            stackSize = i;
        }
        String damageProp = p.getProperty("damage");
        Rename.Damage damage = null;
        if (damageProp != null && !(firstDamage = Rename.getFirstValue(damageProp)).isEmpty()) {
            try {
                int d = Integer.parseInt(firstDamage.replace("%", ""));
                damage = new Rename.Damage(d, firstDamage.contains("%"));
            }
            catch (NumberFormatException ignored) {
                RPRenames.LOGGER.warn("Could not get valid damage value " + firstDamage + " for " + path);
            }
        }
        String firstEnchantId = enchantIdProp = p.getProperty("enchantmentIDs");
        if (enchantIdProp != null) {
            firstEnchantId = Rename.getFirstValue(enchantIdProp);
        }
        Integer enchantLvl = (firstEnchantLvl = Rename.getFirstValue((enchantLvlProp = p.getProperty("enchantmentLevels")) == null ? "" : enchantLvlProp)).isEmpty() ? null : (Integer.parseInt(firstEnchantLvl) <= 0 ? null : Integer.valueOf(Integer.parseInt(firstEnchantLvl)));
        String description = p.getProperty("%rprenames.description");
        if (description == null) {
            description = p.getProperty("%rpr.description");
        }
        if (description == null) {
            description = p.getProperty("%description");
        }
        if (nbtNamePattern != null) {
            Rename rename = new Rename(ConfigManager.getFirstName(nbtNamePattern, items), items, packName, path, stackSize, damage, firstEnchantId, enchantLvl, p, description, null);
            for (String item : items) {
                ConfigManager.addRename(item, rename);
            }
        }
    }

    private static ArrayList<String> splitMatchItems(String matchItems) {
        ArrayList<String> items = new ArrayList<String>();
        int start = 0;
        while (start <= matchItems.length()) {
            String item = Rename.getFirstValue(matchItems.substring(start));
            start += item.length() + 1;
            if (item.startsWith("minecraft:")) {
                item = item.substring(10);
            }
            if (item.equals("air")) continue;
            items.add(item);
        }
        return items;
    }
}

