/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import fi.dy.masa.malilib.config.IConfigBoolean;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.mixin.IMixinBeaconBlockEntity;
import fi.dy.masa.minihud.renderer.BaseBlockRangeOverlay;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2580;
import net.minecraft.class_2591;
import net.minecraft.class_287;

public class OverlayRendererBeaconRange
extends BaseBlockRangeOverlay<class_2580> {
    public static final OverlayRendererBeaconRange INSTANCE = new OverlayRendererBeaconRange();

    public OverlayRendererBeaconRange() {
        super((IConfigBoolean)RendererToggle.OVERLAY_BEACON_RANGE, class_2591.field_11890, class_2580.class);
    }

    @Override
    protected void renderBlockRange(class_1937 world, class_2338 pos, class_2580 be, class_243 cameraPos) {
        int level = ((IMixinBeaconBlockEntity)be).minihud_getLevel();
        if (level >= 1 && level <= 4) {
            this.renderBeaconBox(world, pos, level, cameraPos, OverlayRendererBeaconRange.getColorForLevel(level));
        }
    }

    protected void renderBeaconBox(class_1937 world, class_2338 pos, int level, class_243 cameraPos, Color4f color) {
        double x = (double)pos.method_10263() - cameraPos.field_1352;
        double y = (double)pos.method_10264() - cameraPos.field_1351;
        double z = (double)pos.method_10260() - cameraPos.field_1350;
        int range = level * 10 + 10;
        double minX = x - (double)range;
        double minY = y - (double)range;
        double minZ = z - (double)range;
        double maxX = x + (double)range + 1.0;
        double maxY = this.getTopYOverTerrain(world, pos, range);
        double maxZ = z + (double)range + 1.0;
        RenderUtils.drawBoxAllSidesBatchedQuads((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ, (Color4f)color, (class_287)BUFFER_1);
        RenderUtils.drawBoxAllEdgesBatchedLines((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ, (Color4f)Color4f.fromColor((Color4f)color, (float)1.0f), (class_287)BUFFER_2);
    }

    public static Color4f getColorForLevel(int level) {
        switch (level) {
            case 1: {
                return Configs.Colors.BEACON_RANGE_LVL1_OVERLAY_COLOR.getColor();
            }
            case 2: {
                return Configs.Colors.BEACON_RANGE_LVL2_OVERLAY_COLOR.getColor();
            }
            case 3: {
                return Configs.Colors.BEACON_RANGE_LVL3_OVERLAY_COLOR.getColor();
            }
        }
        return Configs.Colors.BEACON_RANGE_LVL4_OVERLAY_COLOR.getColor();
    }
}

