/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer.shapes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fi.dy.masa.malilib.util.BlockSnap;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.PositionUtils;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.renderer.RenderObjectBase;
import fi.dy.masa.minihud.renderer.RenderUtils;
import fi.dy.masa.minihud.renderer.shapes.ShapeBlocky;
import fi.dy.masa.minihud.renderer.shapes.ShapeType;
import fi.dy.masa.minihud.renderer.shapes.SideQuad;
import fi.dy.masa.minihud.util.RayTracer;
import fi.dy.masa.minihud.util.shape.SphereUtils;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.Collection;
import java.util.List;
import java.util.function.LongConsumer;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_290;
import net.minecraft.class_310;

public class ShapeLineBlock
extends ShapeBlocky {
    protected class_243 startPos = class_243.field_1353;
    protected class_243 endPos = class_243.field_1353;
    protected class_243 effectiveStartPos = class_243.field_1353;
    protected class_243 effectiveEndPos = class_243.field_1353;

    public ShapeLineBlock() {
        super(ShapeType.BLOCK_LINE, Configs.Colors.SHAPE_LINE_BLOCKY.getColor());
        this.setBlockSnap(BlockSnap.CENTER);
    }

    public class_243 getStartPos() {
        return this.effectiveStartPos;
    }

    public class_243 getEndPos() {
        return this.effectiveEndPos;
    }

    public void setStartPos(class_243 startPos) {
        this.startPos = startPos;
        this.updateEffectivePositions();
    }

    public void setEndPos(class_243 endPos) {
        this.endPos = endPos;
        this.updateEffectivePositions();
    }

    @Override
    public void moveToPosition(class_243 pos) {
        class_243 diff = this.endPos.method_1020(this.startPos);
        this.startPos = pos;
        this.endPos = pos.method_1019(diff);
        this.updateEffectivePositions();
        InfoUtils.printActionbarMessage((String)String.format("Moved shape to %.1f %.1f %.1f", pos.method_10216(), pos.method_10214(), pos.method_10215()), (Object[])new Object[0]);
    }

    @Override
    public void setBlockSnap(BlockSnap snap) {
        super.setBlockSnap(snap);
        this.updateEffectivePositions();
    }

    @Override
    public void update(class_243 cameraPos, class_1297 entity, class_310 mc) {
        this.renderLineShape(cameraPos);
        this.needsUpdate = false;
    }

    @Override
    public List<String> getWidgetHoverLines() {
        List<String> lines = super.getWidgetHoverLines();
        class_243 s = this.startPos;
        class_243 e = this.endPos;
        lines.add(StringUtils.translate((String)"minihud.gui.label.shape.line.start", (Object[])new Object[]{ShapeLineBlock.d2(s.field_1352), ShapeLineBlock.d2(s.field_1351), ShapeLineBlock.d2(s.field_1350)}));
        lines.add(StringUtils.translate((String)"minihud.gui.label.shape.line.end", (Object[])new Object[]{ShapeLineBlock.d2(e.field_1352), ShapeLineBlock.d2(e.field_1351), ShapeLineBlock.d2(e.field_1350)}));
        return lines;
    }

    @Override
    public JsonObject toJson() {
        JsonObject obj = super.toJson();
        obj.add("start", (JsonElement)JsonUtils.vec3dToJson((class_243)this.startPos));
        obj.add("end", (JsonElement)JsonUtils.vec3dToJson((class_243)this.endPos));
        return obj;
    }

    @Override
    public void fromJson(JsonObject obj) {
        super.fromJson(obj);
        class_243 startPos = JsonUtils.vec3dFromJson((JsonObject)obj, (String)"start");
        class_243 endPos = JsonUtils.vec3dFromJson((JsonObject)obj, (String)"end");
        if (startPos != null) {
            this.startPos = startPos;
        }
        if (endPos != null) {
            this.endPos = endPos;
        }
        this.updateEffectivePositions();
    }

    protected void updateRenderPerimeter() {
        double range = 512.0;
        double minX = Math.min(this.effectiveStartPos.method_10216(), this.effectiveEndPos.method_10216()) - range;
        double minY = Math.min(this.effectiveStartPos.method_10214(), this.effectiveEndPos.method_10214()) - range;
        double minZ = Math.min(this.effectiveStartPos.method_10215(), this.effectiveEndPos.method_10215()) - range;
        double maxX = Math.max(this.effectiveStartPos.method_10216(), this.effectiveEndPos.method_10216()) + range;
        double maxY = Math.max(this.effectiveStartPos.method_10214(), this.effectiveEndPos.method_10214()) + range;
        double maxZ = Math.max(this.effectiveStartPos.method_10215(), this.effectiveEndPos.method_10215()) + range;
        this.renderPerimeter = new class_238(minX, minY, minZ, maxX, maxY, maxZ);
    }

    protected void updateEffectivePositions() {
        this.effectiveStartPos = this.getBlockSnappedPosition(this.startPos);
        this.effectiveEndPos = this.getBlockSnappedPosition(this.endPos);
        this.updateRenderPerimeter();
        this.setNeedsUpdate();
    }

    protected void renderLineShape(class_243 cameraPos) {
        double maxDist = 30000.0;
        if (this.effectiveEndPos.method_1022(this.effectiveStartPos) > 30000.0) {
            return;
        }
        LongOpenHashSet positions = new LongOpenHashSet();
        RayTracer tracer = new RayTracer(this.effectiveStartPos, this.effectiveEndPos);
        double expand = 0.0;
        tracer.iterateAllPositions(this.getLinePositionCollector(positions));
        RenderObjectBase renderQuads = (RenderObjectBase)this.renderObjects.get(0);
        BUFFER_1.method_1328(renderQuads.getGlMode(), class_290.field_1576);
        if (this.getCombineQuads()) {
            Long2ObjectOpenHashMap<SideQuad> strips = this.buildPositionsToStrips(positions, this.layerRange);
            RenderUtils.renderQuads((Collection<SideQuad>)strips.values(), this.color, expand, cameraPos, BUFFER_1);
        } else {
            RenderUtils.renderBlockPositions(positions, this.layerRange, this.color, expand, cameraPos, BUFFER_1);
        }
        renderQuads.uploadData(BUFFER_1);
    }

    protected LongConsumer getLinePositionCollector(LongOpenHashSet positionsOut) {
        IntBoundingBox box = this.layerRange.getExpandedBox((class_1937)this.mc.field_1687, 0);
        LongConsumer positionCollector = pos -> {
            if (box.containsPos(pos)) {
                positionsOut.add(pos);
            }
        };
        return positionCollector;
    }

    public Long2ObjectOpenHashMap<SideQuad> buildPositionsToStrips(LongOpenHashSet positions, LayerRange layerRange) {
        Long2ObjectOpenHashMap strips = new Long2ObjectOpenHashMap();
        Long2ByteOpenHashMap handledPositions = new Long2ByteOpenHashMap();
        class_2350[] sides = PositionUtils.ALL_DIRECTIONS;
        double lengthX = Math.abs(this.effectiveEndPos.method_10216() - this.effectiveStartPos.method_10216());
        double lengthY = Math.abs(this.effectiveEndPos.method_10214() - this.effectiveStartPos.method_10214());
        double lengthZ = Math.abs(this.effectiveEndPos.method_10215() - this.effectiveStartPos.method_10215());
        class_2350 mainAxisHor = lengthX >= lengthZ ? class_2350.field_11039 : class_2350.field_11043;
        class_2350 mainAxisAll = lengthY >= lengthX && lengthY >= lengthZ ? class_2350.field_11033 : mainAxisHor;
        LongIterator longIterator = positions.iterator();
        while (longIterator.hasNext()) {
            long pos = (Long)longIterator.next();
            if (!layerRange.isPositionWithinRange(pos)) continue;
            for (class_2350 side : sides) {
                if (SphereUtils.isHandledAndMarkHandled(pos, side, handledPositions) || positions.contains(class_2338.method_10060((long)pos, (class_2350)side))) continue;
                class_2350 minDir = side.method_10166().method_10178() ? mainAxisHor : mainAxisAll;
                class_2350 maxDir = minDir.method_10153();
                int lengthMin = ShapeLineBlock.getStripLengthOnSide(pos, side, minDir, positions, handledPositions);
                int lengthMax = ShapeLineBlock.getStripLengthOnSide(pos, side, maxDir, positions, handledPositions);
                long startPosLong = SphereUtils.offsetPos(pos, minDir, lengthMin);
                long index = SphereUtils.getCompressedPosSide(startPosLong, side);
                int width = lengthMin + lengthMax + 1;
                int height = 1;
                if (side.method_10166().method_10178() && mainAxisHor.method_10166() == class_2350.class_2351.field_11051 || side.method_10166().method_10179() && mainAxisAll.method_10166().method_10178()) {
                    height = width;
                    width = 1;
                }
                strips.put(index, (Object)new SideQuad(startPosLong, width, height, side));
            }
        }
        return strips;
    }

    protected static int getStripLengthOnSide(long pos, class_2350 side, class_2350 moveDirection, LongOpenHashSet positions, Long2ByteOpenHashMap handledPositions) {
        int length = 0;
        long adjPos = class_2338.method_10060((long)pos, (class_2350)moveDirection);
        while (positions.contains(adjPos) && !positions.contains(class_2338.method_10060((long)adjPos, (class_2350)side)) && !SphereUtils.isHandledAndMarkHandled(adjPos, side, handledPositions)) {
            ++length;
            adjPos = class_2338.method_10060((long)adjPos, (class_2350)moveDirection);
        }
        return length;
    }
}

