/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.resources;

import com.google.common.base.Joiner;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.platform.ModernFixPlatformHooks;
import org.embeddedt.modernfix.resources.CachedResourcePath;
import org.embeddedt.modernfix.resources.ICachingResourcePack;
import org.embeddedt.modernfix.util.PackTypeHelper;

public class PackResourcesCacheEngine {
    private static final Joiner SLASH_JOINER = Joiner.on((char)'/');
    private final Map<class_3264, Set<String>> namespacesByType;
    private final Set<CachedResourcePath> containedPaths;
    private final EnumMap<class_3264, Map<String, List<CachedResourcePath>>> resourceListings;
    private volatile boolean cacheGenerationFlag = false;
    private List<Runnable> cacheGenerationTasks = new ArrayList<Runnable>();
    private Path debugPath;
    private static final WeakHashMap<ICachingResourcePack, Boolean> cachingPacks = new WeakHashMap();

    public PackResourcesCacheEngine(Function<class_3264, Set<String>> namespacesRetriever, BiFunction<class_3264, String, Path> basePathRetriever) {
        this.namespacesByType = new EnumMap<class_3264, Set<String>>(class_3264.class);
        for (class_3264 type : class_3264.values()) {
            if (!PackTypeHelper.isVanillaPackType(type)) continue;
            this.namespacesByType.put(type, namespacesRetriever.apply(type));
        }
        this.containedPaths = new ObjectOpenHashSet();
        this.resourceListings = new EnumMap(class_3264.class);
        this.debugPath = basePathRetriever.apply(class_3264.field_14188, "minecraft").toAbsolutePath();
        for (class_3264 type : class_3264.values()) {
            Collection namespaces = PackTypeHelper.isVanillaPackType(type) ? (Collection)this.namespacesByType.get(type) : (Collection)namespacesRetriever.apply(type);
            Collection namespacedRoots = namespaces.stream().map(s -> Pair.of((Object)s, (Object)((Path)basePathRetriever.apply(type, (String)s)).toAbsolutePath())).collect(Collectors.toList());
            this.cacheGenerationTasks.add(() -> {
                ImmutableMap.Builder packTypedMap = ImmutableMap.builder();
                for (Pair pair : namespacedRoots) {
                    try {
                        ImmutableList.Builder namespacedList = ImmutableList.builder();
                        String namespace = (String)pair.getFirst();
                        Path root = (Path)pair.getSecond();
                        String[] prefix = new String[]{type.method_14413(), namespace};
                        try (Stream<Path> stream = Files.find(root, Integer.MAX_VALUE, (p, a) -> a.isRegularFile(), new FileVisitOption[0]);){
                            stream.map(path -> root.relativize(path.toAbsolutePath())).filter(PackResourcesCacheEngine::isValidCachedResourcePath).forEach(path -> {
                                CachedResourcePath cachedPath = new CachedResourcePath(prefix, (Path)path);
                                Set<CachedResourcePath> set = this.containedPaths;
                                synchronized (set) {
                                    this.containedPaths.add(cachedPath);
                                }
                                namespacedList.add((Object)cachedPath);
                            });
                        }
                        packTypedMap.put((Object)namespace, (Object)namespacedList.build());
                    }
                    catch (IOException iOException) {}
                }
                EnumMap<class_3264, Map<String, List<CachedResourcePath>>> enumMap = this.resourceListings;
                synchronized (enumMap) {
                    this.resourceListings.put(type, (Map<String, List<CachedResourcePath>>)packTypedMap.build());
                }
            });
        }
        this.cacheGenerationTasks.add(() -> ((ObjectOpenHashSet)this.containedPaths).trim());
    }

    private static boolean isValidCachedResourcePath(Path path) {
        if (path.getFileName() == null || path.getNameCount() == 0) {
            return false;
        }
        String str = SLASH_JOINER.join((Iterable)path);
        if (str.length() == 0) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (class_2960.method_29184((char)str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public Set<String> getNamespaces(class_3264 type) {
        if (PackTypeHelper.isVanillaPackType(type)) {
            return this.namespacesByType.get(type);
        }
        return null;
    }

    private void doGenerateCache() {
        Stopwatch watch = Stopwatch.createStarted();
        for (Runnable r : this.cacheGenerationTasks) {
            r.run();
        }
        watch.stop();
        ModernFix.LOGGER.debug("Generated cache for {} in {}", (Object)this.debugPath, (Object)watch);
        this.debugPath = null;
        this.cacheGenerationTasks = ImmutableList.of();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void awaitLoad() {
        if (!this.cacheGenerationFlag) {
            PackResourcesCacheEngine packResourcesCacheEngine = this;
            synchronized (packResourcesCacheEngine) {
                if (!this.cacheGenerationFlag) {
                    this.doGenerateCache();
                    this.cacheGenerationFlag = true;
                }
            }
        }
    }

    public boolean hasResource(String path) {
        this.awaitLoad();
        return this.containedPaths.contains(new CachedResourcePath(path));
    }

    public boolean hasResource(String[] paths) {
        this.awaitLoad();
        return this.containedPaths.contains(new CachedResourcePath(paths));
    }

    public Collection<class_2960> getResources(class_3264 type, String resourceNamespace, String pathIn, int maxDepth, Predicate<class_2960> filter) {
        if (!PackTypeHelper.isVanillaPackType(type)) {
            throw new IllegalArgumentException("Only vanilla PackTypes are supported");
        }
        this.awaitLoad();
        List paths = this.resourceListings.get(type).getOrDefault(resourceNamespace, Collections.emptyList());
        if (paths.isEmpty()) {
            return Collections.emptyList();
        }
        Object testPath = pathIn.endsWith("/") ? pathIn : pathIn + "/";
        ArrayList<class_2960> resources = new ArrayList<class_2960>();
        for (CachedResourcePath cachePath : paths) {
            class_2960 foundResource;
            String fullPath;
            Object fullTestPath;
            if (cachePath.getNameCount() - 2 > maxDepth || !((String)(fullTestPath = (fullPath = cachePath.getFullPath(2)).endsWith("/") ? fullPath : fullPath + "/")).startsWith((String)testPath) || !filter.test(foundResource = new class_2960(resourceNamespace, fullPath))) continue;
            resources.add(foundResource);
        }
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void track(ICachingResourcePack pack) {
        WeakHashMap<ICachingResourcePack, Boolean> weakHashMap = cachingPacks;
        synchronized (weakHashMap) {
            cachingPacks.put(pack, Boolean.TRUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invalidate() {
        if (!ModernFixPlatformHooks.INSTANCE.isDevEnv()) {
            return;
        }
        WeakHashMap<ICachingResourcePack, Boolean> weakHashMap = cachingPacks;
        synchronized (weakHashMap) {
            cachingPacks.keySet().forEach(pack -> {
                if (pack != null) {
                    pack.invalidateCache();
                }
            });
        }
    }
}

