/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.biome;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Map;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.biome.BiomeIdMapper;
import net.mehvahdjukaar.polytone.utils.JsonPartialReloader;
import net.mehvahdjukaar.polytone.utils.ReferenceOrDirectCodec;
import net.minecraft.class_2960;
import net.minecraft.class_5699;

public class BiomeIdMapperManager
extends JsonPartialReloader {
    private static final BiMap<String, BiomeIdMapper> ID_MAPPERS = HashBiMap.create();
    public static final Codec<BiomeIdMapper> REFERENCE_CODEC = class_5699.method_39508(a -> (String)ID_MAPPERS.inverse().get(a), arg_0 -> ID_MAPPERS.get(arg_0));
    public static final Codec<BiomeIdMapper> CODEC = new ReferenceOrDirectCodec<BiomeIdMapper.Custom>(REFERENCE_CODEC, BiomeIdMapper.Custom.CODEC, false);

    public BiomeIdMapperManager() {
        super("biome_id_mappers");
    }

    @Override
    protected void reset() {
        ID_MAPPERS.clear();
    }

    @Override
    protected void process(Map<class_2960, JsonElement> obj) {
        for (Map.Entry<class_2960, JsonElement> j : obj.entrySet()) {
            JsonElement json = j.getValue();
            class_2960 id = j.getKey();
            BiomeIdMapper mapper = (BiomeIdMapper)((Pair)CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(false, errorMsg -> Polytone.LOGGER.warn("Could not decode Biome ID mapper with json id {} - error: {}", (Object)id, errorMsg))).getFirst();
            ID_MAPPERS.put((Object)id.method_12832(), (Object)mapper);
        }
    }
}

