/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.color;

import com.google.common.collect.Lists;
import com.google.gson.JsonParseException;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.color.MapColorHelper;
import net.mehvahdjukaar.polytone.mixins.accessor.SheepAccessor;
import net.mehvahdjukaar.polytone.particle.BlockParticleExpression;
import net.mehvahdjukaar.polytone.utils.ColorUtils;
import net.mehvahdjukaar.polytone.utils.SingleJsonOrPropertiesReloadListener;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1472;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1826;
import net.minecraft.class_243;
import net.minecraft.class_2457;
import net.minecraft.class_2960;
import net.minecraft.class_3620;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class ColorManager
extends SingleJsonOrPropertiesReloadListener {
    private final Object2IntMap<class_3620> vanillaMapColors = new Object2IntOpenHashMap();
    private final Map<class_1767, Integer> vanillaFireworkColors = new EnumMap<class_1767, Integer>(class_1767.class);
    private final Map<class_1767, Integer> vanillaDiffuseColors = new EnumMap<class_1767, Integer>(class_1767.class);
    private final Map<class_1767, Integer> vanillaTextColors = new EnumMap<class_1767, Integer>(class_1767.class);
    private final Map<class_124, Integer> vanillaChatFormatting = new EnumMap<class_124, Integer>(class_124.class);
    private final Object2IntMap<class_1826> vanillaEggsBackgrounds = new Object2IntOpenHashMap();
    private final Object2IntMap<class_1826> vanillaEggsHighlight = new Object2IntOpenHashMap();
    private final Object2IntMap<class_1291> vanillaEffectColors = new Object2IntOpenHashMap();
    private final Map<class_1767, Integer> customSheepColors = new EnumMap<class_1767, Integer>(class_1767.class);
    protected final List<class_243> originalRedstoneWireColors = Arrays.stream(class_2457.field_24466).toList();
    @Nullable
    private BlockParticleExpression xpOrbColor;
    @Nullable
    private BlockParticleExpression xpOrbColorR;
    @Nullable
    private BlockParticleExpression xpOrbColorG;
    @Nullable
    private BlockParticleExpression xpOrbColorB;
    private int emptyPotion = 0xF800F8;
    private int waterBottle = 3694022;
    private int xpBar = 8453920;

    public ColorManager() {
        super("color.properties", "colors.json", "polytone", "colormatic", "vanadium", "optifine");
    }

    public int getEmptyPot() {
        return this.emptyPotion;
    }

    public int getWaterBottle() {
        return this.waterBottle;
    }

    public int getXpBar() {
        return this.xpBar;
    }

    @Override
    protected void process(Map<class_2960, Properties> map) {
        ArrayList<class_2960> keySet = new ArrayList<class_2960>(map.keySet());
        Lists.reverse(keySet);
        for (class_2960 k : keySet) {
            Properties p = map.get(k);
            for (Map.Entry<Object, Object> e : p.entrySet()) {
                Object object = e.getKey();
                if (!(object instanceof String)) continue;
                String key = (String)object;
                String[] split = key.split("\\.");
                this.parseColor(split, e.getValue(), k);
            }
        }
        this.regenSheepColors();
    }

    private void parseColor(String[] prop, Object obj, class_2960 colorPropFileId) {
        if (!(obj instanceof String)) {
            return;
        }
        String str = (String)obj;
        if (this.is(prop, 0, "map")) {
            String name = this.get(prop, 1);
            class_3620 color = MapColorHelper.byName(name);
            if (color != null) {
                int col = ColorManager.parseHex(obj);
                if (!this.vanillaMapColors.containsKey((Object)color)) {
                    this.vanillaMapColors.put((Object)color, color.field_16011);
                }
                color.field_16011 = col;
            } else {
                Polytone.LOGGER.warn("Unknown MapColor with name {}", (Object)name);
            }
        } else if (this.is(prop, 0, "dye")) {
            String name = this.get(prop, 1);
            class_1767 color = class_1767.method_7793((String)name, null);
            if (color != null) {
                String param = this.get(prop, 2);
                int col = ColorManager.parseHex(obj);
                if (param == null || param.equals("diffuse")) {
                    if (!this.vanillaDiffuseColors.containsKey(color)) {
                        this.vanillaDiffuseColors.put(color, ColorUtils.pack(color.field_7943));
                    }
                    color.field_7943 = ColorUtils.unpack(col);
                } else if (param.equals("firework")) {
                    if (!this.vanillaFireworkColors.containsKey(color)) {
                        this.vanillaFireworkColors.put(color, color.field_7960);
                    }
                    color.field_7960 = col;
                } else if (param.equals("text")) {
                    if (!this.vanillaTextColors.containsKey(color)) {
                        this.vanillaTextColors.put(color, color.field_16537);
                    }
                    color.field_16537 = col;
                }
            } else {
                Polytone.LOGGER.warn("Unknown DyeColor with name {}", (Object)name);
            }
        } else if (this.is(prop, 0, "particle")) {
            if (prop.length > 1) {
                String s = prop[1];
                class_2960 id = new class_2960(s.replace("\\", ""));
                try {
                    int hex = ColorManager.parseHex(str);
                    Polytone.PARTICLE_MODIFIERS.addCustomParticleColor(id, String.valueOf(hex));
                }
                catch (Exception e) {
                    Polytone.PARTICLE_MODIFIERS.addCustomParticleColor(id, str);
                }
            }
        } else if (this.is(prop, 0, "egg")) {
            if (prop.length > 2) {
                class_1299 entity;
                class_2960 id = new class_2960(prop[2].replace("\\", ""));
                class_1792 item = class_7923.field_41178.method_17966(id).orElse(null);
                if (item == null) {
                    item = class_7923.field_41178.method_17966(id.method_48331("_spawn_egg")).orElse(null);
                }
                if (item == null && (entity = (class_1299)class_7923.field_41177.method_17966(id).orElse(null)) != null) {
                    item = class_1826.method_8019((class_1299)entity);
                }
                if (item instanceof class_1826) {
                    class_1826 spawnEggItem = (class_1826)item;
                    int col = ColorManager.parseHex(obj);
                    if (this.is(prop, 1, "shell")) {
                        if (!this.vanillaEggsBackgrounds.containsKey((Object)spawnEggItem)) {
                            this.vanillaEggsBackgrounds.put((Object)spawnEggItem, spawnEggItem.field_8916);
                        }
                        spawnEggItem.field_8916 = col;
                    } else if (this.is(prop, 1, "spots")) {
                        if (!this.vanillaEggsHighlight.containsKey((Object)spawnEggItem)) {
                            this.vanillaEggsHighlight.put((Object)spawnEggItem, spawnEggItem.field_8915);
                        }
                        spawnEggItem.field_8915 = col;
                    }
                } else {
                    Polytone.LOGGER.warn("Unknown or invalid Spawn Egg Item with name {}", (Object)id);
                }
            }
        } else if (this.is(prop, 0, "potion") || this.is(prop, 0, "effect")) {
            class_2960 id = new class_2960(prop[1].replace("\\", ""));
            int col = ColorManager.parseHex(obj);
            if (id.method_12832().equals("empty")) {
                this.emptyPotion = col;
            } else if (id.method_12832().equals("water")) {
                this.waterBottle = col;
            } else {
                class_1291 effect = class_7923.field_41174.method_17966(id).orElse(null);
                if (effect != null) {
                    if (!this.vanillaEffectColors.containsKey((Object)effect)) {
                        this.vanillaEffectColors.put((Object)effect, effect.method_5556());
                    }
                    effect.field_5886 = col;
                } else {
                    Polytone.LOGGER.warn("Unknown Mob Effect with name {}", (Object)id);
                }
            }
        } else if (this.is(prop, 0, "sheep")) {
            String name = this.get(prop, 1);
            class_1767 color = class_1767.method_7793((String)name, null);
            if (color != null) {
                int col = ColorManager.parseHex(obj);
                this.customSheepColors.put(color, col);
            } else {
                Polytone.LOGGER.warn("Unknown Dye Color with name {}", (Object)name);
            }
        } else if (this.is(prop, 0, "xporb")) {
            if (this.is(prop, 1, "color")) {
                this.xpOrbColor = new BlockParticleExpression(str);
            } else if (this.is(prop, 1, "red")) {
                this.xpOrbColorR = new BlockParticleExpression(str);
            } else if (this.is(prop, 1, "green")) {
                this.xpOrbColorG = new BlockParticleExpression(str);
            } else if (this.is(prop, 1, "blue")) {
                this.xpOrbColorB = new BlockParticleExpression(str);
            }
        } else if (this.is(prop, 0, "redstone")) {
            String ind = this.get(prop, 1);
            if (ind != null) {
                int code = Integer.parseInt(ind);
                if (code < class_2457.field_24466.length) {
                    int col = ColorManager.parseHex(obj);
                    float[] rgb = ColorUtils.unpack(col);
                    class_2457.field_24466[code] = new class_243((double)rgb[0], (double)rgb[1], (double)rgb[2]);
                } else {
                    Polytone.LOGGER.warn("Redstone color index must be between 0 and 15");
                }
            }
        } else if (this.is(prop, 0, "text")) {
            int col = ColorManager.parseHex(obj);
            class_124 text = null;
            if (this.is(prop, 1, "xpbar")) {
                this.xpBar = col;
            } else if (this.is(prop, 1, "code")) {
                String s = this.get(prop, 2);
                if (s != null) {
                    int code = Integer.parseInt(s);
                    text = class_124.method_534((int)code);
                }
            } else {
                String s = this.get(prop, 1);
                text = class_124.method_533((String)s);
            }
            if (text != null) {
                if (!this.vanillaChatFormatting.containsKey(text)) {
                    this.vanillaChatFormatting.put(text, text.method_532());
                }
                text.field_1053 = col;
            }
        } else if (this.is(prop, 0, "palette") && this.is(prop, 1, "block") && prop.length > 2 && obj instanceof String) {
            String path = prop[2].replace("~/colormap/", colorPropFileId.method_12836() + ":");
            Polytone.BLOCK_PROPERTIES.addSimpleColormap(new class_2960(path), str);
        }
    }

    private boolean is(String[] array, int index, String value) {
        if (array.length <= index) {
            return false;
        }
        return array[index].equals(value);
    }

    @Nullable
    private String get(String[] array, int index) {
        if (array.length <= index) {
            return null;
        }
        return array[index];
    }

    @Nullable
    private <T> T get(String[] array, int index, Function<String, T> fun) {
        if (array.length <= index) {
            return null;
        }
        return fun.apply(array[index]);
    }

    private static int parseHex(Object obj) {
        if (obj instanceof String) {
            String value = (String)obj;
            value = value.replace("#", "").replace("0x", "");
            return Integer.parseInt(value, 16);
        }
        throw new JsonParseException("Failed to parse object " + obj + ". Expected a String");
    }

    @Override
    public void reset() {
        class_1826 item;
        class_3620 color;
        this.emptyPotion = 0xF800F8;
        this.waterBottle = 3694022;
        this.xpBar = 8453920;
        this.xpOrbColor = null;
        this.xpOrbColorR = null;
        this.xpOrbColorG = null;
        this.xpOrbColorB = null;
        for (Map.Entry entry : this.vanillaMapColors.entrySet()) {
            color = (class_3620)entry.getKey();
            color.field_16011 = (Integer)entry.getValue();
        }
        this.vanillaMapColors.clear();
        for (Map.Entry entry : this.vanillaDiffuseColors.entrySet()) {
            color = (class_1767)entry.getKey();
            color.field_7943 = ColorUtils.unpack((Integer)entry.getValue());
        }
        this.vanillaDiffuseColors.clear();
        for (Map.Entry entry : this.vanillaFireworkColors.entrySet()) {
            color = (class_1767)entry.getKey();
            color.field_7960 = (Integer)entry.getValue();
        }
        this.vanillaFireworkColors.clear();
        for (Map.Entry entry : this.vanillaTextColors.entrySet()) {
            color = (class_1767)entry.getKey();
            color.field_16537 = (Integer)entry.getValue();
        }
        this.vanillaTextColors.clear();
        for (Map.Entry entry : this.vanillaEggsBackgrounds.entrySet()) {
            item = (class_1826)entry.getKey();
            item.field_8916 = (Integer)entry.getValue();
        }
        this.vanillaEggsBackgrounds.clear();
        for (Map.Entry entry : this.vanillaEggsHighlight.entrySet()) {
            item = (class_1826)entry.getKey();
            item.field_8915 = (Integer)entry.getValue();
        }
        this.vanillaEggsHighlight.clear();
        class_2457.field_24466 = this.originalRedstoneWireColors.toArray(new class_243[0]);
    }

    public void regenSheepColors() {
        class_1472.field_6867 = new EnumMap(class_1767.class);
        for (class_1767 d : class_1767.values()) {
            class_1472.field_6867.put(d, SheepAccessor.invokeCreateSheepColor(d));
        }
        for (Map.Entry entry : this.customSheepColors.entrySet()) {
            class_1472.field_6867.put((class_1767)entry.getKey(), ColorUtils.unpack((Integer)entry.getValue()));
        }
        this.customSheepColors.clear();
    }

    @Nullable
    public float[] getXpOrbColor(class_1303 orb, float partialTicks) {
        if (this.xpOrbColor != null) {
            int color = (int)this.xpOrbColor.getValue(orb.method_19538(), (float)orb.field_6012 + partialTicks);
            return ColorUtils.unpack(color);
        }
        if (this.xpOrbColorR == null && this.xpOrbColorG == null && this.xpOrbColorB == null) {
            return null;
        }
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        if (this.xpOrbColorR != null) {
            r = (float)this.xpOrbColorR.getValue(orb.method_19538(), (float)orb.field_6012 + partialTicks);
        }
        if (this.xpOrbColorG != null) {
            g = (float)this.xpOrbColorG.getValue(orb.method_19538(), (float)orb.field_6012 + partialTicks);
        }
        if (this.xpOrbColorB != null) {
            b = (float)this.xpOrbColorB.getValue(orb.method_19538(), (float)orb.field_6012 + partialTicks);
        }
        return new float[]{r, g, b};
    }
}

