/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.colormap;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.colormap.Colormap;
import net.mehvahdjukaar.polytone.colormap.CompoundBlockColors;
import net.mehvahdjukaar.polytone.utils.ArrayImage;
import net.mehvahdjukaar.polytone.utils.JsonImgPartialReloader;
import net.minecraft.class_1163;
import net.minecraft.class_1920;
import net.minecraft.class_1926;
import net.minecraft.class_1933;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_322;
import org.jetbrains.annotations.Nullable;

public class ColormapsManager
extends JsonImgPartialReloader {
    public static final class_322 GRASS_COLOR = (s, l, p, i) -> l != null && p != null ? class_1163.method_4962((class_1920)l, (class_2338)p) : class_1933.method_49724();
    public static final class_322 FOLIAGE_COLOR = (s, l, p, i) -> l != null && p != null ? class_1163.method_4966((class_1920)l, (class_2338)p) : class_1926.method_8341();
    public static final class_322 WATER_COLOR = (s, l, p, i) -> l != null && p != null ? class_1163.method_4961((class_1920)l, (class_2338)p) : -16777216;
    private final BiMap<class_2960, class_322> colormapsIds = HashBiMap.create();

    public ColormapsManager() {
        super("colormaps");
    }

    @Override
    public void process(JsonImgPartialReloader.Resources resources) {
        Map<class_2960, JsonElement> jsons = resources.jsons();
        Map<class_2960, ArrayImage> textures = resources.textures();
        HashSet<class_2960> usedTextures = new HashSet<class_2960>();
        for (Map.Entry<class_2960, JsonElement> entry : jsons.entrySet()) {
            JsonElement json = entry.getValue();
            class_2960 id = entry.getKey();
            Colormap colormap = (Colormap)((Pair)Colormap.DIRECT_CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(false, errorMsg -> Polytone.LOGGER.warn("Could not decode Colormap with json id {} - error: {}", (Object)id, errorMsg))).getFirst();
            ColormapsManager.tryAcceptingTexture(textures.get(id), id, colormap, usedTextures);
            this.add(id, colormap);
        }
        textures.keySet().removeAll(usedTextures);
        for (Map.Entry<class_2960, Object> entry : textures.entrySet()) {
            class_2960 id = entry.getKey();
            Colormap defaultColormap = Colormap.defTriangle();
            ColormapsManager.tryAcceptingTexture(textures.get(id), id, defaultColormap, usedTextures);
            this.add(id, defaultColormap);
        }
    }

    @Override
    public void reset() {
        this.colormapsIds.clear();
        this.colormapsIds.put((Object)new class_2960("grass_color"), (Object)GRASS_COLOR);
        this.colormapsIds.put((Object)new class_2960("foliage_color"), (Object)FOLIAGE_COLOR);
        this.colormapsIds.put((Object)new class_2960("water_color"), (Object)WATER_COLOR);
    }

    @Nullable
    public class_322 get(class_2960 id) {
        if (id.equals((Object)new class_2960("biome_sample"))) {
            return Colormap.defSquare();
        }
        if (id.equals((Object)new class_2960("triangular_biome_sample"))) {
            return Colormap.defTriangle();
        }
        if (id.equals((Object)new class_2960("fixed"))) {
            return Colormap.fixed();
        }
        if (id.equals((Object)new class_2960("grid"))) {
            return Colormap.biomeId();
        }
        return (class_322)this.colormapsIds.get((Object)id);
    }

    @Nullable
    public class_2960 getKey(class_322 object) {
        return (class_2960)this.colormapsIds.inverse().get((Object)object);
    }

    public void add(class_2960 id, Colormap colormap) {
        this.colormapsIds.put((Object)id, (Object)colormap);
        if (!colormap.hasTexture()) {
            throw new IllegalStateException("Did not find any texture png for colormap " + id);
        }
    }

    public static void fillCompoundColormapPalette(Map<class_2960, ArrayImage.Group> textures, class_2960 id, CompoundBlockColors colormap, Set<class_2960> usedTextures) {
        Int2ObjectMap<class_322> getters = colormap.getGetters();
        for (Int2ObjectMap.Entry g : getters.int2ObjectEntrySet()) {
            ArrayImage.Group textureMap;
            Colormap c;
            int index = g.getIntKey();
            class_322 inner = (class_322)g.getValue();
            if (!(inner instanceof Colormap) || (c = (Colormap)inner).hasTexture() || (textureMap = textures.get(c.getTargetTexture() == null ? id : c.getTargetTexture())) == null || getters.size() != 1 && index != 0) continue;
            try {
                ColormapsManager.tryAcceptingTexture(textureMap.getDefault(), id, c, usedTextures);
            }
            catch (Exception exception) {
                try {
                    ColormapsManager.tryAcceptingTexture((ArrayImage)textureMap.get(index), id, c, usedTextures);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed applying a texture for tint index " + index + ": ", e);
                }
            }
        }
    }

    public static void tryAcceptingTexture(@Nullable ArrayImage texture, class_2960 textureLocation, Colormap colormap, Set<class_2960> usedTexture) {
        if (colormap.hasTexture()) {
            return;
        }
        if (texture != null) {
            usedTexture.add(textureLocation);
            colormap.acceptTexture(texture);
            if (texture.pixels().length == 0) {
                throw new IllegalStateException("Colormap texture at location " + textureLocation + " had invalid 0 dimension");
            }
        } else {
            throw new IllegalStateException("Could not find any colormap texture .png associated with path " + textureLocation);
        }
    }
}

