/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.lightmap;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.serialization.Codec;
import net.mehvahdjukaar.polytone.lightmap.LightmapExpressionProvider;
import net.mehvahdjukaar.polytone.utils.ReferenceOrDirectCodec;
import net.minecraft.class_3532;
import net.minecraft.class_5699;
import net.minecraft.class_5819;

public interface ILightmapNumberProvider {
    public static final BiMap<String, ILightmapNumberProvider> CUSTOM_PROVIDERS = HashBiMap.create();
    public static final Codec<ILightmapNumberProvider> REFERENCE_CODEC = class_5699.method_39508(a -> (String)CUSTOM_PROVIDERS.inverse().get(a), arg_0 -> CUSTOM_PROVIDERS.get(arg_0));
    public static final Codec<ILightmapNumberProvider> CODEC = new ReferenceOrDirectCodec<LightmapExpressionProvider>(REFERENCE_CODEC, LightmapExpressionProvider.CODEC, true);
    public static final class_5819 RAND = class_5819.method_43047();
    public static final ILightmapNumberProvider RANDOM = ILightmapNumberProvider.register("random", (time, rain, thunder) -> {
        RAND.method_43052((long)Float.floatToIntBits(time));
        return RAND.method_43057();
    });
    public static final ILightmapNumberProvider DEFAULT = ILightmapNumberProvider.register("default", (time, rain, thunder) -> {
        float g = 1.0f - (class_3532.method_15362((float)(time * ((float)Math.PI * 2))) * 2.0f + 0.2f);
        g = class_3532.method_15363((float)g, (float)0.0f, (float)1.0f);
        g = 1.0f - g;
        return g;
    });
    public static final ILightmapNumberProvider SMOOTH = ILightmapNumberProvider.register("smooth", (time, rain, thunder) -> 0.5f + class_3532.method_15362((float)(time * ((float)Math.PI * 2))) * 0.5f);
    public static final ILightmapNumberProvider LINEAR = ILightmapNumberProvider.register("linear", (time, rain, thunder) -> class_3532.method_15379((float)(1.0f - 2.0f * time)));
    public static final ILightmapNumberProvider DEFAULT_2 = ILightmapNumberProvider.register("default", (time, rain, thunder) -> {
        float g = 1.0f - (class_3532.method_15362((float)(time * ((float)Math.PI * 2))) * 2.0f + 0.2f);
        g = class_3532.method_15363((float)g, (float)0.0f, (float)1.0f);
        g = 1.0f - g;
        g = (float)((double)g * 0.5);
        if ((double)time > 0.5) {
            return g;
        }
        return 1.0f - g;
    });
    public static final ILightmapNumberProvider SMOOTH_2 = ILightmapNumberProvider.register("smooth_2", (time, rain, thunder) -> {
        if ((double)time > 0.5) {
            return 0.25f - class_3532.method_15362((float)(time * ((float)Math.PI * 2))) * 0.25f;
        }
        return 0.75f + class_3532.method_15362((float)(time * ((float)Math.PI * 2))) * 0.25f;
    });
    public static final ILightmapNumberProvider LINEAR_2 = ILightmapNumberProvider.register("linear_2", (time, rain, thunder) -> {
        float linear = class_3532.method_15379((float)(1.0f - 2.0f * time));
        if ((double)time > 0.5) {
            return linear * 0.5f;
        }
        return 1.0f - linear * 0.5f;
    });

    public static <T extends ILightmapNumberProvider> T register(String name, T provider) {
        CUSTOM_PROVIDERS.put((Object)name, provider);
        return provider;
    }

    public float getValue(float var1, float var2, float var3);
}

