/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.particle;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.particle.ParticleModifier;
import net.mehvahdjukaar.polytone.utils.JsonPartialReloader;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2960;
import net.minecraft.class_703;
import net.minecraft.class_7923;

public class ParticleModifiersManager
extends JsonPartialReloader {
    private final Multimap<class_2396<?>, ParticleModifier> particleModifiers = HashMultimap.create();

    public ParticleModifiersManager() {
        super("particle_modifiers");
    }

    public void maybeModify(class_2394 options, class_1937 level, class_703 particle) {
        Collection mod = this.particleModifiers.get((Object)options.method_10295());
        for (ParticleModifier modifier : mod) {
            modifier.modify(particle, level, options);
        }
    }

    @Override
    public void process(Map<class_2960, JsonElement> jsons) {
        for (Map.Entry<class_2960, JsonElement> j : jsons.entrySet()) {
            JsonElement json = j.getValue();
            class_2960 id = j.getKey();
            ParticleModifier modifier = (ParticleModifier)((Pair)ParticleModifier.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(false, errorMsg -> Polytone.LOGGER.warn("Could not decode Particle Modifier with json id {} - error: {}", (Object)id, errorMsg))).getFirst();
            this.addModifier(id, modifier);
        }
    }

    private void addModifier(class_2960 pathId, ParticleModifier mod) {
        Optional<Set<class_2960>> explTargets = mod.explicitTargets;
        Optional pathTarget = class_7923.field_41180.method_17966(pathId);
        if (explTargets.isPresent()) {
            if (pathTarget.isPresent()) {
                Polytone.LOGGER.error("Found Particle Modifier with Explicit Targets ({}) also having a valid IMPLICIT Path Target ({}).Consider moving it under your OWN namespace to avoid overriding other packs modifiers with the same path", explTargets.get(), (Object)pathId);
            }
            for (class_2960 explicitId : explTargets.get()) {
                Optional target = class_7923.field_41180.method_17966(explicitId);
                target.ifPresent(type -> this.particleModifiers.put(type, (Object)mod));
            }
        } else {
            pathTarget.ifPresent(type -> this.particleModifiers.put(type, (Object)mod));
        }
    }

    @Override
    protected void reset() {
        this.particleModifiers.clear();
    }

    public void addCustomParticleColor(class_2960 id, String color) {
        Optional opt = class_7923.field_41180.method_17966(id);
        opt.ifPresent(t -> this.particleModifiers.put(t, (Object)ParticleModifier.ofColor(color)));
    }
}

