/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.sound;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.utils.PartialReloader;
import net.mehvahdjukaar.polytone.utils.ReferenceOrDirectCodec;
import net.mehvahdjukaar.polytone.utils.StrOpt;
import net.minecraft.class_156;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2498;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3414;
import net.minecraft.class_4309;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class SoundTypesManager
extends PartialReloader<Resources> {
    private final Map<class_2960, class_3414> customSoundEvents = new HashMap<class_2960, class_3414>();
    private final BiMap<class_2960, class_2498> soundTypesIds = HashBiMap.create();
    private static final Map<String, class_2498> SOUND_NAMES = (Map)class_156.method_656(() -> {
        HashMap<String, class_2498> map = new HashMap<String, class_2498>();
        map.put("empty", class_2498.field_44608);
        map.put("wood", class_2498.field_11547);
        map.put("gravel", class_2498.field_11529);
        map.put("grass", class_2498.field_11535);
        map.put("lily_pad", class_2498.field_25183);
        map.put("stone", class_2498.field_11544);
        map.put("metal", class_2498.field_11533);
        map.put("glass", class_2498.field_11537);
        map.put("wool", class_2498.field_11543);
        map.put("sand", class_2498.field_11526);
        map.put("snow", class_2498.field_11548);
        map.put("powder_snow", class_2498.field_27884);
        map.put("ladder", class_2498.field_11532);
        map.put("anvil", class_2498.field_11531);
        map.put("slime_block", class_2498.field_11545);
        map.put("honey_block", class_2498.field_21214);
        map.put("wet_grass", class_2498.field_11534);
        map.put("coral_block", class_2498.field_11528);
        map.put("bamboo", class_2498.field_11542);
        map.put("bamboo_sapling", class_2498.field_11538);
        map.put("scaffolding", class_2498.field_16498);
        map.put("sweet_berry_bush", class_2498.field_17579);
        map.put("crop", class_2498.field_17580);
        map.put("hard_crop", class_2498.field_18852);
        map.put("vine", class_2498.field_23083);
        map.put("nether_wart", class_2498.field_17581);
        map.put("lantern", class_2498.field_17734);
        map.put("stem", class_2498.field_22152);
        map.put("nylium", class_2498.field_22153);
        map.put("fungus", class_2498.field_22154);
        map.put("roots", class_2498.field_22138);
        map.put("shroomlight", class_2498.field_22139);
        map.put("weeping_vines", class_2498.field_22140);
        map.put("twisting_vines", class_2498.field_23082);
        map.put("soul_sand", class_2498.field_22141);
        map.put("soul_soil", class_2498.field_22142);
        map.put("basalt", class_2498.field_22143);
        map.put("wart_block", class_2498.field_22144);
        map.put("netherrack", class_2498.field_22145);
        map.put("nether_bricks", class_2498.field_22146);
        map.put("nether_sprouts", class_2498.field_22147);
        map.put("nether_ore", class_2498.field_22148);
        map.put("bone_block", class_2498.field_22149);
        map.put("netherite_block", class_2498.field_22150);
        map.put("ancient_debris", class_2498.field_22151);
        map.put("lodestone", class_2498.field_23265);
        map.put("chain", class_2498.field_24119);
        map.put("nether_gold_ore", class_2498.field_24120);
        map.put("gilded_blackstone", class_2498.field_24121);
        map.put("candle", class_2498.field_27196);
        map.put("amethyst", class_2498.field_27197);
        map.put("amethyst_cluster", class_2498.field_27198);
        map.put("small_amethyst_bud", class_2498.field_27199);
        map.put("medium_amethyst_bud", class_2498.field_27200);
        map.put("large_amethyst_bud", class_2498.field_27201);
        map.put("tuff", class_2498.field_27202);
        map.put("calcite", class_2498.field_27203);
        map.put("dripstone_block", class_2498.field_28060);
        map.put("pointed_dripstone", class_2498.field_28061);
        map.put("copper", class_2498.field_27204);
        map.put("cave_vines", class_2498.field_28692);
        map.put("spore_blossom", class_2498.field_28693);
        map.put("azalea", class_2498.field_28694);
        map.put("flowering_azalea", class_2498.field_28695);
        map.put("moss_carpet", class_2498.field_28696);
        map.put("pink_petals", class_2498.field_42772);
        map.put("moss", class_2498.field_28697);
        map.put("big_dripleaf", class_2498.field_28698);
        map.put("small_dripleaf", class_2498.field_28699);
        map.put("rooted_dirt", class_2498.field_28700);
        map.put("hanging_roots", class_2498.field_28701);
        map.put("azalea_leaves", class_2498.field_28702);
        map.put("sculk_sensor", class_2498.field_28116);
        map.put("sculk_catalyst", class_2498.field_37643);
        map.put("sculk", class_2498.field_37644);
        map.put("sculk_vein", class_2498.field_37645);
        map.put("sculk_shrieker", class_2498.field_37646);
        map.put("glow_lichen", class_2498.field_28427);
        map.put("deepslate", class_2498.field_29033);
        map.put("deepslate_bricks", class_2498.field_29034);
        map.put("deepslate_tiles", class_2498.field_29035);
        map.put("polished_deepslate", class_2498.field_29036);
        map.put("froglight", class_2498.field_37636);
        map.put("frogspawn", class_2498.field_37637);
        map.put("muddy_mangrove_roots", class_2498.field_37639);
        map.put("mud", class_2498.field_37640);
        map.put("mud_bricks", class_2498.field_37641);
        map.put("packed_mud", class_2498.field_37642);
        map.put("hanging_sign", class_2498.field_40313);
        map.put("nether_wood_hanging_sign", class_2498.field_41083);
        map.put("bamboo_wood_hanging_sign", class_2498.field_41084);
        map.put("bamboo_wood", class_2498.field_40314);
        map.put("nether_wood", class_2498.field_40315);
        map.put("cherry_wood", class_2498.field_42766);
        map.put("cherry_sapling", class_2498.field_42767);
        map.put("cherry_leaves", class_2498.field_42768);
        map.put("cherry_wood_hanging_sign", class_2498.field_42769);
        map.put("chiseled_bookshelf", class_2498.field_41085);
        map.put("suspicious_sand", class_2498.field_42770);
        map.put("suspicious_gravel", class_2498.field_43255);
        map.put("decorated_pot", class_2498.field_42771);
        map.put("decorated_pot_cracked", class_2498.field_43256);
        return map;
    });
    private static final Codec<class_2498> SOUND_TYPE_BLOCK_COPY = class_7923.field_41175.method_39673().xmap(block -> block.method_9573(block.method_9564()), soundType1 -> class_2246.field_10124);
    public static final Codec<class_2498> REFERENCE_OR_COPY_CODEC = Codec.STRING.flatXmap(s -> {
        class_2498 custom;
        if (s.startsWith("copy(")) {
            String target = s.replace("copy(", "").replace(")", "");
            class_2960 r = class_2960.method_12829((String)target);
            if (r == null) {
                return DataResult.error(() -> "Invalid string for Sound Type Copy function: " + s + ". Expected 'copy([some_mod]:[some_block])'");
            }
            Optional block = class_7923.field_41175.method_17966(r);
            if (block.isEmpty()) {
                return DataResult.error(() -> "No block with id '" + r + "' found", (Object)class_2498.field_44608);
            }
            class_2248 b = (class_2248)block.get();
            return DataResult.success((Object)b.method_9573(b.method_9564()));
        }
        class_2498 vanilla = SOUND_NAMES.get(s);
        if (vanilla != null) {
            return DataResult.success((Object)vanilla);
        }
        class_2960 r = class_2960.method_12829((String)s);
        if (r != null && (custom = Polytone.SOUND_TYPES.getCustom(new class_2960(s))) != null) {
            return DataResult.success((Object)custom);
        }
        return DataResult.error(() -> "Could not find any custom Sound Type with id " + r + " Did you place it in 'assets/[your pack]/polytone/sound_types/' ?");
    }, t -> DataResult.error(() -> "Encoding SoundTypes not supported"));
    public static final Codec<class_2498> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)StrOpt.of(Codec.FLOAT, "volume", Float.valueOf(1.0f)).forGetter(class_2498::method_10597), (App)StrOpt.of(Codec.FLOAT, "pitch", Float.valueOf(1.0f)).forGetter(class_2498::method_10599), (App)class_7923.field_41172.method_39673().fieldOf("break_sound").forGetter(class_2498::method_10595), (App)class_7923.field_41172.method_39673().fieldOf("step_sound").forGetter(class_2498::method_10594), (App)class_7923.field_41172.method_39673().fieldOf("place_sound").forGetter(class_2498::method_10598), (App)class_7923.field_41172.method_39673().fieldOf("hit_sound").forGetter(class_2498::method_10596), (App)class_7923.field_41172.method_39673().fieldOf("fall_sound").forGetter(class_2498::method_10593)).apply((Applicative)instance, class_2498::new));
    public static final Codec<class_2498> CODEC = new ReferenceOrDirectCodec<class_2498>(REFERENCE_OR_COPY_CODEC, DIRECT_CODEC);

    public SoundTypesManager() {
        super("sound_types");
    }

    @Nullable
    public class_2498 getCustom(class_2960 id) {
        return (class_2498)this.soundTypesIds.get((Object)id);
    }

    @Nullable
    public class_2960 getCustomKey(class_2498 object) {
        return (class_2960)this.soundTypesIds.inverse().get((Object)object);
    }

    @Override
    protected Resources prepare(class_3300 resourceManager) {
        HashMap<class_2960, JsonElement> jsons = new HashMap<class_2960, JsonElement>();
        class_4309.method_51148((class_3300)resourceManager, (String)this.path(), (Gson)GSON, jsons);
        SoundTypesManager.checkConditions(jsons);
        Map<class_2960, List<String>> types = SoundTypesManager.gatherSoundEvents(resourceManager, "polytone");
        return new Resources(jsons, types);
    }

    @Override
    public void process(Resources resources) {
        Map<class_2960, JsonElement> soundJsons = resources.soundTypes;
        Map<class_2960, List<String>> soundEvents = resources.soundEvents;
        ArrayList<class_2960> ids = new ArrayList<class_2960>();
        for (Map.Entry<class_2960, List<String>> entry : soundEvents.entrySet()) {
            for (String s : entry.getValue()) {
                class_2960 id = entry.getKey().method_45136(s);
                if (this.customSoundEvents.containsKey(id) || class_7923.field_41172.method_10250(id)) continue;
                class_3414 event = SoundTypesManager.registerSoundEvent(id);
                ids.add(id);
                this.customSoundEvents.put(id, event);
            }
        }
        if (!ids.isEmpty()) {
            Polytone.LOGGER.info("Registered {} custom Sound Events from Resource Packs: {}", (Object)ids.size(), (Object)(ids + ". Remember to add them to sounds.json!"));
            class_310.method_1551().method_1483().method_38566();
        }
        for (Map.Entry<class_2960, List<String>> entry : soundJsons.entrySet()) {
            JsonElement json = (JsonElement)entry.getValue();
            class_2960 id = entry.getKey();
            class_2498 soundType = (class_2498)((Pair)DIRECT_CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(false, errorMsg -> Polytone.LOGGER.warn("Could not decode Sound Type with json id {} - error: {}", (Object)id, errorMsg))).getFirst();
            this.soundTypesIds.put((Object)id, (Object)soundType);
        }
    }

    public static class_3414 registerSoundEvent(class_2960 id) {
        class_3414 event = class_3414.method_47908((class_2960)id);
        ((class_2370)class_7923.field_41172).field_36463 = false;
        class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)id, (Object)event);
        class_7923.field_41172.method_40276();
        return event;
    }

    @Override
    protected void reset() {
        this.soundTypesIds.clear();
        this.customSoundEvents.clear();
    }

    public static Map<class_2960, List<String>> gatherSoundEvents(class_3300 resourceManager, String path) {
        HashMap<class_2960, List<String>> idList = new HashMap<class_2960, List<String>>();
        Map res = resourceManager.method_41265(path, resourceLocation -> resourceLocation.method_12832().endsWith("sound_events.csv"));
        for (Map.Entry e : res.entrySet()) {
            for (class_3298 r : (List)e.getValue()) {
                try {
                    BufferedReader reader = r.method_43039();
                    try {
                        BufferedReader bufferedReader = new BufferedReader(reader);
                        List<String> lines = bufferedReader.lines().map(line -> line.split(",")).flatMap(Arrays::stream).map(String::trim).filter(v -> class_2960.method_12829((String)v) != null && !v.isEmpty()).toList();
                        if (lines.isEmpty()) continue;
                        idList.put((class_2960)e.getKey(), lines);
                    }
                    finally {
                        if (reader == null) continue;
                        ((Reader)reader).close();
                    }
                }
                catch (JsonParseException | IOException | IllegalArgumentException ex) {
                    Polytone.LOGGER.error("Couldn't parse Custom Sound Events file {}:", e.getKey(), (Object)ex);
                }
            }
        }
        return idList;
    }

    public record Resources(Map<class_2960, JsonElement> soundTypes, Map<class_2960, List<String>> soundEvents) {
    }
}

