/*
 * Decompiled with CFR 0.152.
 */
package dynamic_fps.impl.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Version
implements Comparable<Version> {
    private final int[] components;
    @Nullable
    private final String preRelease;
    @Nullable
    private final String buildMetadata;
    private static final Pattern VERSION_PATTERN = Pattern.compile("^(?<major>\\d+)\\.(?<minor>\\d+)(?:\\.(?<patch>\\d+))?(?:-(?<prerelease>[\\da-zA-Z\\-\\.]{2,}))?(?:\\+(?<metadata>[\\da-zA-Z\\-\\.]+))?$");

    private Version(int major, int minor, int patch, @Nullable String preRelease, @Nullable String buildMetadata) {
        this.components = new int[]{major, minor, patch};
        this.preRelease = preRelease;
        this.buildMetadata = buildMetadata;
    }

    public static Version of(String raw) throws VersionParseException {
        Matcher matcher = VERSION_PATTERN.matcher(raw);
        if (!matcher.matches()) {
            throw new VersionParseException(raw);
        }
        int major = Integer.parseInt(matcher.group("major"));
        int minor = Integer.parseInt(matcher.group("minor"));
        int patch = 0;
        if (matcher.group("patch") != null) {
            patch = Integer.parseInt(matcher.group("patch"));
        }
        String preRelease = matcher.group("prerelease");
        String buildMetadata = matcher.group("metadata");
        return new Version(major, minor, patch, preRelease, buildMetadata);
    }

    public int major() {
        return this.components[0];
    }

    public int minor() {
        return this.components[1];
    }

    public int patch() {
        return this.components[2];
    }

    public boolean isPreRelease() {
        return this.preRelease() != null;
    }

    @Nullable
    public String preRelease() {
        return this.preRelease;
    }

    public boolean hasBuildMetadata() {
        return this.buildMetadata() != null;
    }

    @Nullable
    public String buildMetadata() {
        return this.buildMetadata;
    }

    public String toString() {
        Object result = String.format("%s.%s.%s", this.major(), this.minor(), this.patch());
        if (this.isPreRelease()) {
            result = (String)result + "-" + this.preRelease();
        }
        if (this.hasBuildMetadata()) {
            result = (String)result + "+" + this.buildMetadata();
        }
        return result;
    }

    @Override
    public int compareTo(@NotNull Version other) {
        for (int index = 0; index < 3; ++index) {
            int result = Integer.compare(this.components[index], other.components[index]);
            if (result == 0) continue;
            return result;
        }
        if (this.isPreRelease() && other.isPreRelease()) {
            return this.preRelease().compareTo(other.preRelease());
        }
        if (this.isPreRelease()) {
            return -1;
        }
        if (other.isPreRelease()) {
            return 1;
        }
        return 0;
    }

    public static class VersionParseException
    extends Exception {
        private VersionParseException(String version) {
            super(version + " is not a semantic version!");
        }
    }
}

