/*
 * Decompiled with CFR 0.152.
 */
package me.bymartrixx.vtd.gui;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import me.bymartrixx.vtd.VTDMod;
import me.bymartrixx.vtd.access.AbstractPackAccess;
import me.bymartrixx.vtd.data.Category;
import me.bymartrixx.vtd.data.DownloadPackRequestData;
import me.bymartrixx.vtd.data.Pack;
import me.bymartrixx.vtd.data.RpCategories;
import me.bymartrixx.vtd.data.SharePackRequestData;
import me.bymartrixx.vtd.gui.UnsavedPackWarningScreen;
import me.bymartrixx.vtd.gui.popup.MessageScreenPopup;
import me.bymartrixx.vtd.gui.popup.ProgressBarScreenPopup;
import me.bymartrixx.vtd.gui.widget.CategorySelectionWidget;
import me.bymartrixx.vtd.gui.widget.ExpandDrawerButtonWidget;
import me.bymartrixx.vtd.gui.widget.MutableMessageButtonWidget;
import me.bymartrixx.vtd.gui.widget.PackNameTextFieldWidget;
import me.bymartrixx.vtd.gui.widget.PackSelectionHelper;
import me.bymartrixx.vtd.gui.widget.PackSelectionListWidget;
import me.bymartrixx.vtd.gui.widget.ReloadButtonWidget;
import me.bymartrixx.vtd.gui.widget.SelectedPacksListWidget;
import me.bymartrixx.vtd.util.Constants;
import me.bymartrixx.vtd.util.Util;
import net.minecraft.class_2561;
import net.minecraft.class_3288;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5369;
import org.jetbrains.annotations.Nullable;

public class VTDownloadScreen
extends class_437 {
    private static final boolean DOWNLOAD_DISABLED = false;
    private static final boolean DEBUG_BUTTON = false;
    private static final class_2561 TITLE = class_2561.method_43470((String)"VTDownloader");
    private static final class_2561 DOWNLOAD_TEXT = class_2561.method_43471((String)"vtd.download");
    private static final class_2561 DOWNLOAD_FAILED_TEXT = class_2561.method_43471((String)"vtd.download.failed");
    private static final class_2561 DOWNLOAD_SUCCESS_TEXT = class_2561.method_43471((String)"vtd.download.success");
    private static final class_2561 SHARE_TEXT = class_2561.method_43471((String)"vtd.share");
    private static final class_2561 SHARE_FAILED_TEXT = class_2561.method_43471((String)"vtd.share.failed");
    private static final Function<class_2561, class_2561> SHARE_CODE_TEXT = code -> class_2561.method_43469((String)"vtd.share.code", (Object[])new Object[]{code});
    private static final class_2561 READ_PACK_DATA_FAILED_TEXT = class_2561.method_43471((String)"vtd.readPackDataFailed");
    private static final class_2561 PACK_NAME_FIELD_TEXT = class_2561.method_43471((String)"vtd.resourcePack.nameField");
    private static final class_2561 PLACEHOLDER_TEXT = class_2561.method_43470((String)"Lorem ipsum dolor sit amet");
    private static final int WIDGET_HEIGHT = 20;
    private static final int WIDGET_MARGIN = 10;
    private static final int TITLE_Y = 8;
    private static final int SUBTITLE_Y = 20;
    private static final int CATEGORY_SELECTOR_Y = 32;
    private static final int PACK_SELECTOR_TOP_HEIGHT = 66;
    private static final int PACK_SELECTOR_BOTTOM_HEIGHT = 36;
    private static final int SELECTED_PACKS_WIDTH = 160;
    private static final int SELECTED_PACKS_CENTER_X = 80;
    private static final int SELECTED_PACKS_TOP_HEIGHT = 72;
    private static final int SELECTED_PACKS_BOTTOM_HEIGHT = 72;
    private static final int SELECTED_PACKS_BUTTON_Y = 40;
    private static final int SHARE_BUTTON_WIDTH = 120;
    private static final int SHARE_BUTTON_CENTER_X = 60;
    private static final int DONE_BUTTON_WIDTH = 80;
    private static final int DOWNLOAD_BUTTON_WIDTH = 100;
    private static final int PROGRESS_BAR_HEIGHT = 40;
    private static final int PROGRESS_BAR_WIDTH = 200;
    private static final int PROGRESS_BAR_COLOR = 0xFFFFFF;
    private static final int PACK_NAME_FIELD_WIDTH = 160;
    private static final float PROGRESS_BAR_MAX_TIME = 20.0f;
    private static final float DOWNLOAD_MESSAGE_MAX_TIME = 120.0f;
    private static final float SHARE_MESSAGE_TIME = 200.0f;
    private static final float ERROR_MESSAGE_TIME = 160.0f;
    private static final float DEBUG_MESSAGE_TIME = 200.0f;
    private final class_437 parent;
    private final class_2561 subtitle;
    private final List<Category> categories;
    private Category currentCategory;
    private ProgressBarScreenPopup progressBar;
    private MessageScreenPopup sharePopup;
    private MessageScreenPopup errorPopup;
    @Nullable
    private MessageScreenPopup debugPopup;
    private CategorySelectionWidget categorySelector;
    private PackSelectionListWidget packSelector;
    private SelectedPacksListWidget selectedPacksList;
    private PackNameTextFieldWidget packNameField;
    private class_4185 shareButton;
    private MutableMessageButtonWidget downloadButton;
    private class_4185 doneButton;
    @Nullable
    private String packName;
    @Nullable
    private class_5369.class_5371 pack;
    @Nullable
    private String defaultPackName;
    private int leftWidth;
    private boolean changed = false;
    private float downloadProgress = -1.0f;
    private float downloadMessageTime;
    @Nullable
    private SharePackRequestData lastShareData;
    @Nullable
    private String lastShareCode;
    private final PackSelectionHelper selectionHelper = new PackSelectionHelper();

    public VTDownloadScreen(class_437 parent, class_2561 subtitle) {
        super(TITLE);
        this.parent = parent;
        this.subtitle = subtitle;
        this.categories = VTDMod.rpCategories.getCategories();
        this.currentCategory = !this.categories.isEmpty() ? this.categories.get(0) : null;
        this.selectionHelper.addCallback((pack, category, selected) -> {
            this.changed = true;
            this.updateButtons();
        });
    }

    public VTDownloadScreen(class_437 parent, class_2561 subtitle, class_5369.class_5371 pack) {
        this(parent, subtitle);
        this.packName = pack.method_29650().getString().replaceAll("\\.zip$", "");
        this.pack = pack;
        this.defaultPackName = this.packName;
    }

    private void reloadCategories() {
        VTDMod.loadRpCategories();
        this.updateCategories(VTDMod.rpCategories);
    }

    private void updateCategories(RpCategories data) {
        this.categories.clear();
        this.categories.addAll(data.getCategories());
        this.packSelector.updateCategories(this.categories);
        this.categorySelector.updateCategories(this.categories);
        this.selectionHelper.cleanUpSelection();
        this.selectedPacksList.update();
        this.currentCategory = !this.categories.isEmpty() ? this.categories.get(0) : null;
        this.categorySelector.setSelectedCategory(this.currentCategory);
        this.packSelector.setCategory(this.currentCategory);
    }

    @Nullable
    private String getPackName() {
        return this.packNameField != null ? this.packNameField.method_1882() : this.packName;
    }

    private void download() {
        this.changed = false;
        this.downloadProgress = 0.0f;
        this.progressBar.show(20.0f, () -> Float.valueOf(this.downloadProgress), () -> {
            this.downloadProgress = -1.0f;
        });
        this.downloadButton.field_22763 = false;
        this.doneButton.field_22763 = false;
        this.packNameField.method_1888(false);
        this.packSelector.setEditable(false);
        DownloadPackRequestData data = DownloadPackRequestData.create(this.selectionHelper.getSelectedPacks());
        CompletableFuture<Boolean> download = VTDMod.executePackDownload(data, f -> {
            this.downloadProgress = f.floatValue();
        }, this.field_22787.method_1479(), this.packNameField.isBlank() ? null : this.packNameField.method_1882());
        ((CompletableFuture)download.whenCompleteAsync((success, throwable) -> {
            this.updateButtons();
            this.doneButton.field_22763 = true;
            this.packNameField.method_1888(true);
            this.packSelector.setEditable(true);
            if (throwable != null) {
                this.progressBar.abortWait();
                VTDMod.LOGGER.error("Pack download failed", throwable);
                this.errorPopup.show(160.0f, (class_2561)DOWNLOAD_FAILED_TEXT.method_27661().method_27693("\n").method_27693(throwable.getLocalizedMessage()));
                this.downloadButton.method_25355(DOWNLOAD_FAILED_TEXT);
                return;
            }
            if (success.booleanValue()) {
                this.downloadProgress = 1.0f;
                VTDMod.LOGGER.info("Pack downloaded successfully");
                this.downloadButton.method_25355(DOWNLOAD_SUCCESS_TEXT);
            } else {
                this.progressBar.abortWait();
                VTDMod.LOGGER.error("Pack download failed");
                this.downloadButton.method_25355(DOWNLOAD_FAILED_TEXT);
            }
        })).completeOnTimeout(false, 60L, TimeUnit.SECONDS);
    }

    private void share() {
        SharePackRequestData data = new SharePackRequestData("resourcepacks", VTDMod.VT_VERSION, this.selectionHelper.getSelectedPacksPrimitive());
        if (data.equals(this.lastShareData)) {
            this.showSharePopup(this.lastShareCode);
            return;
        }
        VTDMod.executeShare(data).whenCompleteAsync((code, throwable) -> {
            if (throwable != null) {
                VTDMod.LOGGER.error("Failed to get resource pack share code", throwable);
                this.errorPopup.show(160.0f, (class_2561)SHARE_FAILED_TEXT.method_27661().method_27693("\n").method_27693(throwable.getLocalizedMessage()));
                return;
            }
            this.lastShareData = data;
            this.lastShareCode = code;
            this.showSharePopup((String)code);
        });
    }

    private void showSharePopup(String code) {
        if (code != null && this.sharePopup != null) {
            String url = "https://vanillatweaks.net/share#" + code;
            this.sharePopup.show(200.0f, SHARE_CODE_TEXT.apply(Util.urlText(url)));
        }
    }

    private void readResourcePack() {
        if (this.pack != null && this.pack.getClass().isNestmateOf(class_5369.class_5371.class)) {
            class_3288 profile = ((AbstractPackAccess)this.pack).vtdownloader$getProfile();
            VTDMod.readResourcePackData(profile).whenCompleteAsync((selection, throwable) -> {
                if (throwable != null) {
                    if (this.errorPopup != null) {
                        this.errorPopup.show(160.0f, (class_2561)READ_PACK_DATA_FAILED_TEXT.method_27661().method_27693("\n").method_27693(throwable.getLocalizedMessage()));
                    }
                    VTDMod.LOGGER.error("Failed to read VanillaTweaks pack data", throwable);
                } else {
                    this.selectionHelper.setSelection((List<String>)selection);
                    this.selectedPacksList.update();
                    this.packSelector.updateSelection();
                    this.updateButtons();
                }
            });
        }
        this.pack = null;
    }

    public boolean selectCategory(Category category) {
        Category selectorCategory = category;
        if (category instanceof Category.SubCategory) {
            Category.SubCategory subCategory = (Category.SubCategory)category;
            selectorCategory = subCategory.getParent();
        }
        if (this.currentCategory != category) {
            this.currentCategory = category;
            this.categorySelector.setSelectedCategory(selectorCategory);
            this.packSelector.setCategory(category);
            return true;
        }
        return false;
    }

    public void goToPack(Pack pack, Category category) {
        this.selectCategory(category);
        this.packSelector.focusPack(pack);
    }

    public void method_25419() {
        if (this.changed && this.selectionHelper.hasSelection()) {
            this.field_22787.method_1507((class_437)new UnsavedPackWarningScreen(this, this.parent));
        } else {
            this.field_22787.method_1507(this.parent);
        }
    }

    protected void method_25426() {
        this.leftWidth = this.field_22789;
        this.packSelector = (PackSelectionListWidget)this.method_37060((class_4068)new PackSelectionListWidget(this.field_22787, this, this.field_22789, this.field_22790 - 66 - 36, 66, this.currentCategory, this.selectionHelper));
        this.packSelector.updateCategories(this.categories);
        this.selectedPacksList = (SelectedPacksListWidget)this.method_37060((class_4068)new SelectedPacksListWidget(this, this.field_22787, 160, this.field_22790 - 72 - 72, this.field_22789 - 160, 72, this.selectionHelper));
        this.method_37063((class_364)new ReloadButtonWidget(10, 10, Constants.RESOURCE_PACK_RELOAD_TEXT, button -> this.reloadCategories()));
        this.categorySelector = (CategorySelectionWidget)this.method_37063((class_364)new CategorySelectionWidget(this, 32));
        this.categorySelector.init(this.categories, this.currentCategory);
        ExpandDrawerButtonWidget expandButton = (ExpandDrawerButtonWidget)this.method_37060(new ExpandDrawerButtonWidget(this.field_22789 - 16, 112, 160, e -> this.toggleSelectedPacksListExtended()));
        this.sharePopup = (MessageScreenPopup)this.method_25429(new MessageScreenPopup(this.field_22787, this, this.field_22789 / 2, this.field_22790 / 2, this.field_22789 / 2, (int)((double)this.field_22790 / 1.5), SHARE_TEXT));
        this.errorPopup = (MessageScreenPopup)this.method_25429(new MessageScreenPopup(this.field_22787, this, this.field_22789 / 2, this.field_22790 / 2, this.field_22789 / 2, (int)((double)this.field_22790 / 1.5), Constants.ERROR_TEXT));
        this.method_25429(expandButton);
        this.method_25429((class_364)this.packSelector);
        this.method_25429((class_364)this.selectedPacksList);
        this.shareButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)SHARE_TEXT, button -> this.share()).method_46433(this.leftWidth + 80 - 60, this.field_22790 - 72 + 10).method_46437(120, 20).method_46431());
        this.packNameField = (PackNameTextFieldWidget)this.method_37063((class_364)new PackNameTextFieldWidget(this.field_22793, this.field_22789 - 80 - 20 - 100 - 10 - 160, this.field_22790 - 20 - 10, 160, 20, this.getPackName(), PACK_NAME_FIELD_TEXT, this.field_22787.method_1479(), this.defaultPackName));
        this.packNameField.method_1863(s -> this.updateButtons());
        this.packName = null;
        this.downloadButton = (MutableMessageButtonWidget)this.method_37063((class_364)new MutableMessageButtonWidget(this.field_22789 - 80 - 20 - 100, this.field_22790 - 20 - 10, 100, 20, DOWNLOAD_TEXT, button -> this.download()));
        this.doneButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, button -> this.method_25419()).method_46433(this.field_22789 - 80 - 10, this.field_22790 - 20 - 10).method_46437(80, 20).method_46431());
        this.progressBar = (ProgressBarScreenPopup)this.method_37060(new ProgressBarScreenPopup(this.field_22787, this.field_22789 / 2, this.field_22790 / 2, 200, 40, 0xFFFFFF));
        this.method_37060(this.sharePopup);
        this.method_37060(this.errorPopup);
        if (this.debugPopup != null) {
            this.method_37060(this.debugPopup);
        }
        this.updateButtons();
        this.readResourcePack();
    }

    private void updateButtons() {
        if (this.shareButton != null) {
            this.shareButton.field_22763 = this.selectionHelper.hasSelection();
        }
        if (this.downloadButton != null) {
            this.downloadButton.field_22763 = this.selectionHelper.hasSelection() && this.packNameField.canUseName();
        }
    }

    private void toggleSelectedPacksListExtended() {
        boolean extended = this.selectedPacksList.toggleExtended();
        this.leftWidth = extended ? this.field_22789 - 160 : this.field_22789;
        this.categorySelector.updateScreenWidth();
        this.packSelector.updateScreenWidth();
        this.shareButton.field_22764 = extended;
        this.shareButton.method_46421(this.leftWidth + 80 - 60);
    }

    public boolean isCoveredByPopup(int mouseX, int mouseY) {
        return this.progressBar.isMouseOver(mouseX, mouseY) || this.sharePopup.isMouseOver(mouseX, mouseY) || this.errorPopup.isMouseOver(mouseX, mouseY) || this.debugPopup != null && this.debugPopup.isMouseOver(mouseX, mouseY);
    }

    public int getLeftWidth() {
        return this.leftWidth;
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        this.method_25434(graphics);
        super.method_25394(graphics, mouseX, mouseY, delta);
        graphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 8, 0xFFFFFF);
        graphics.method_27534(this.field_22793, this.subtitle, this.field_22789 / 2, 20, 0xFFFFFF);
        this.renderDebugInfo(graphics, mouseX, mouseY);
        this.packSelector.renderTooltips(graphics, mouseX, mouseY);
        this.renderPackNameFieldTooltip(graphics, mouseX, mouseY);
        this.updateTime(delta);
    }

    private void renderDebugInfo(class_332 graphics, int mouseX, int mouseY) {
        this.packSelector.renderDebugInfo(graphics, mouseX, mouseY);
        this.categorySelector.renderDebugInfo(graphics);
    }

    private void renderPackNameFieldTooltip(class_332 graphics, int mouseX, int mouseY) {
        class_2561 text;
        if (this.packNameField.method_25405(mouseX, mouseY) && (text = this.packNameField.getTooltipText()) != null) {
            graphics.method_51438(this.field_22793, text, mouseX, mouseY);
        }
    }

    private void updateTime(float delta) {
        if (this.downloadMessageTime >= 120.0f) {
            this.downloadMessageTime = 0.0f;
            this.downloadButton.resetMessage();
        } else {
            this.downloadMessageTime += delta;
        }
    }

    private /* synthetic */ void lambda$init$9(class_4185 button) {
        if (this.debugPopup != null) {
            this.debugPopup.show(200.0f, PLACEHOLDER_TEXT);
        }
    }
}

