/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.layout.editor;

import com.google.common.collect.Lists;
import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.customization.deep.AbstractDeepEditorElement;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.element.HideableElement;
import de.keksuccino.fancymenu.customization.element.SerializedElement;
import de.keksuccino.fancymenu.customization.element.editor.AbstractEditorElement;
import de.keksuccino.fancymenu.customization.element.elements.button.vanillawidget.VanillaWidgetEditorElement;
import de.keksuccino.fancymenu.customization.element.elements.button.vanillawidget.VanillaWidgetElementBuilder;
import de.keksuccino.fancymenu.customization.layer.ElementFactory;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayer;
import de.keksuccino.fancymenu.customization.layout.Layout;
import de.keksuccino.fancymenu.customization.layout.LayoutHandler;
import de.keksuccino.fancymenu.customization.layout.editor.AnchorPointOverlay;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorHistory;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorUI;
import de.keksuccino.fancymenu.customization.layout.editor.widget.AbstractLayoutEditorWidget;
import de.keksuccino.fancymenu.customization.layout.editor.widget.LayoutEditorWidgetRegistry;
import de.keksuccino.fancymenu.customization.screen.identifier.ScreenIdentifierHandler;
import de.keksuccino.fancymenu.customization.widget.ScreenWidgetDiscoverer;
import de.keksuccino.fancymenu.customization.widget.WidgetMeta;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinScreen;
import de.keksuccino.fancymenu.util.ListUtils;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.ObjectUtils;
import de.keksuccino.fancymenu.util.ScreenTitleUtils;
import de.keksuccino.fancymenu.util.file.FileUtils;
import de.keksuccino.fancymenu.util.file.type.FileType;
import de.keksuccino.fancymenu.util.file.type.groups.FileTypeGroup;
import de.keksuccino.fancymenu.util.file.type.types.FileTypes;
import de.keksuccino.fancymenu.util.file.type.types.TextFileType;
import de.keksuccino.fancymenu.util.input.CharacterFilter;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.contextmenu.v2.ContextMenu;
import de.keksuccino.fancymenu.util.rendering.ui.menubar.v2.MenuBar;
import de.keksuccino.fancymenu.util.rendering.ui.screen.NotificationScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.filebrowser.SaveFileScreen;
import de.keksuccino.fancymenu.util.rendering.ui.widget.CustomizableWidget;
import de.keksuccino.fancymenu.util.resource.resources.texture.ITexture;
import de.keksuccino.konkrete.gui.screens.popup.PopupHandler;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1041;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_424;
import net.minecraft.class_437;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;

public class LayoutEditorScreen
extends class_437
implements ElementFactory {
    private static final Logger LOGGER = LogManager.getLogger();
    protected static final Map<SerializedElement, ElementBuilder<?, ?>> COPIED_ELEMENTS_CLIPBOARD = new LinkedHashMap();
    public static final int ELEMENT_DRAG_CRUMPLE_ZONE = 5;
    @Nullable
    protected static LayoutEditorScreen currentInstance = null;
    @Nullable
    public class_437 layoutTargetScreen;
    @NotNull
    public Layout layout;
    public List<AbstractEditorElement> normalEditorElements = new ArrayList<AbstractEditorElement>();
    public List<VanillaWidgetEditorElement> vanillaWidgetEditorElements = new ArrayList<VanillaWidgetEditorElement>();
    public List<AbstractDeepEditorElement> deepEditorElements = new ArrayList<AbstractDeepEditorElement>();
    public LayoutEditorHistory history = new LayoutEditorHistory(this);
    public MenuBar menuBar;
    public AnchorPointOverlay anchorPointOverlay = new AnchorPointOverlay(this);
    public ContextMenu rightClickMenu;
    public ContextMenu activeElementContextMenu = null;
    public List<AbstractLayoutEditorWidget> layoutEditorWidgets = new ArrayList<AbstractLayoutEditorWidget>();
    protected boolean isMouseSelection = false;
    protected int mouseSelectionStartX = 0;
    protected int mouseSelectionStartY = 0;
    public int leftMouseDownPosX = 0;
    public int leftMouseDownPosY = 0;
    protected boolean elementMovingStarted = false;
    protected boolean elementResizingStarted = false;
    protected boolean mouseDraggingStarted = false;
    protected List<AbstractEditorElement> currentlyDraggedElements = new ArrayList<AbstractEditorElement>();
    protected int rightClickMenuOpenPosX = -1000;
    protected int rightClickMenuOpenPosY = -1000;
    protected LayoutEditorHistory.Snapshot preDragElementSnapshot;
    public final List<WidgetMeta> cachedVanillaWidgetMetas = new ArrayList<WidgetMeta>();

    public LayoutEditorScreen(@NotNull Layout layout) {
        this(null, layout);
    }

    public LayoutEditorScreen(@Nullable class_437 layoutTargetScreen, @NotNull Layout layout) {
        super((class_2561)class_2561.method_43470((String)""));
        class_2561 cachedOriTitle;
        this.layoutTargetScreen = layoutTargetScreen;
        layout.updateLastEditedTime();
        layout.saveToFileIfPossible();
        this.layout = layout.copy();
        if (this.layoutTargetScreen != null && (cachedOriTitle = ScreenCustomizationLayer.cachedOriginalMenuTitles.get(this.layoutTargetScreen.getClass())) != null) {
            ScreenTitleUtils.setScreenTitle(this.layoutTargetScreen, cachedOriTitle);
        }
        this.constructElementInstances();
    }

    protected void method_25426() {
        this.currentlyDraggedElements.clear();
        this.anchorPointOverlay.resetOverlay();
        for (WidgetMeta m : this.cachedVanillaWidgetMetas) {
            class_339 class_3392 = m.getWidget();
            if (!(class_3392 instanceof CustomizableWidget)) continue;
            CustomizableWidget w = (CustomizableWidget)class_3392;
            w.resetWidgetCustomizationsFancyMenu();
        }
        if (this.layoutEditorWidgets == null || this.layoutEditorWidgets.isEmpty()) {
            this.layoutEditorWidgets = LayoutEditorWidgetRegistry.buildWidgetInstances(this);
        }
        this.closeRightClickMenu();
        this.rightClickMenu = LayoutEditorUI.buildRightClickContextMenu(this);
        this.method_25429(this.rightClickMenu);
        if (this.menuBar != null) {
            this.menuBar.closeAllContextMenus();
        }
        this.menuBar = LayoutEditorUI.buildMenuBar(this, this.menuBar == null || this.menuBar.isExpanded());
        this.method_25429(this.menuBar);
        for (AbstractLayoutEditorWidget w : Lists.reverse(new ArrayList<AbstractLayoutEditorWidget>(this.layoutEditorWidgets))) {
            this.method_25429((class_364)w);
        }
        this.isMouseSelection = false;
        this.preDragElementSnapshot = null;
        this.closeActiveElementMenu(true);
        this.serializeElementInstancesToLayoutInstance();
        if (this.layout.forcedScale != 0.0f) {
            WidgetMeta m;
            float newscale = this.layout.forcedScale;
            if (newscale <= 0.0f) {
                newscale = 1.0f;
            }
            m = class_310.method_1551().method_22683();
            m.method_15997(newscale);
            this.field_22789 = m.method_4486();
            this.field_22790 = m.method_4502();
        }
        if (this.layout.autoScalingWidth != 0 && this.layout.autoScalingHeight != 0) {
            class_1041 m = class_310.method_1551().method_22683();
            double guiWidth = (double)this.field_22789 * m.method_4495();
            double guiHeight = (double)this.field_22790 * m.method_4495();
            double percentX = guiWidth / (double)this.layout.autoScalingWidth * 100.0;
            double percentY = guiHeight / (double)this.layout.autoScalingHeight * 100.0;
            double newScaleX = percentX / 100.0 * m.method_4495();
            double newScaleY = percentY / 100.0 * m.method_4495();
            double newScale = Math.min(newScaleX, newScaleY);
            m.method_15997(newScale);
            this.field_22789 = m.method_4486();
            this.field_22790 = m.method_4502();
        }
        this.constructElementInstances();
        for (AbstractLayoutEditorWidget w : this.layoutEditorWidgets) {
            w.refresh();
        }
    }

    public boolean method_25422() {
        return false;
    }

    public void method_25393() {
        for (AbstractLayoutEditorWidget w : this.layoutEditorWidgets) {
            w.tick();
        }
        for (AbstractEditorElement e : this.getAllElements()) {
            e.element.tick();
        }
        if (this.layout.menuBackground != null) {
            this.layout.menuBackground.tick();
        }
    }

    public void method_25432() {
        for (AbstractEditorElement e : this.getAllElements()) {
            e.element.onCloseScreen();
        }
        if (this.layout.menuBackground != null) {
            this.layout.menuBackground.onCloseScreen();
        }
    }

    public void method_49589() {
        for (AbstractEditorElement e : this.getAllElements()) {
            e.element.onOpenScreen();
        }
        if (this.layout.menuBackground != null) {
            this.layout.menuBackground.onOpenScreen();
        }
    }

    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        if (this.activeElementContextMenu != null && !this.activeElementContextMenu.isOpen()) {
            this.activeElementContextMenu = null;
        }
        this.method_25420(graphics, mouseX, mouseY, partial);
        this.renderElements(graphics, mouseX, mouseY, partial);
        this.renderMouseSelectionRectangle(graphics, mouseX, mouseY);
        this.anchorPointOverlay.method_25394(graphics, mouseX, mouseY, partial);
        this.renderLayoutEditorWidgets(graphics, mouseX, mouseY, partial);
        this.menuBar.method_25394(graphics, mouseX, mouseY, partial);
        this.rightClickMenu.method_25394(graphics, mouseX, mouseY, partial);
        if (this.activeElementContextMenu != null) {
            this.activeElementContextMenu.method_25394(graphics, mouseX, mouseY, partial);
        }
    }

    protected void renderLayoutEditorWidgets(class_332 graphics, int mouseX, int mouseY, float partial) {
        for (AbstractLayoutEditorWidget w : this.layoutEditorWidgets) {
            if (!w.isVisible()) continue;
            w.method_25394(graphics, mouseX, mouseY, partial);
        }
    }

    protected void renderMouseSelectionRectangle(class_332 graphics, int mouseX, int mouseY) {
        if (this.isMouseSelection) {
            int startX = Math.min(this.mouseSelectionStartX, mouseX);
            int startY = Math.min(this.mouseSelectionStartY, mouseY);
            int endX = Math.max(this.mouseSelectionStartX, mouseX);
            int endY = Math.max(this.mouseSelectionStartY, mouseY);
            graphics.method_25294(startX, startY, endX, endY, RenderingUtils.replaceAlphaInColor(UIBase.getUIColorTheme().layout_editor_mouse_selection_rectangle_color.getColorInt(), 70));
            UIBase.renderBorder(graphics, startX, startY, endX, endY, 1, UIBase.getUIColorTheme().layout_editor_mouse_selection_rectangle_color.getColor(), true, true, true, true);
            graphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    protected void renderElements(class_332 graphics, int mouseX, int mouseY, float partial) {
        if (this.layout.renderElementsBehindVanilla) {
            for (AbstractEditorElement abstractEditorElement : new ArrayList<AbstractEditorElement>(this.normalEditorElements)) {
                if (abstractEditorElement.isSelected()) continue;
                abstractEditorElement.method_25394(graphics, mouseX, mouseY, partial);
            }
        }
        for (VanillaWidgetEditorElement vanillaWidgetEditorElement : new ArrayList<VanillaWidgetEditorElement>(this.vanillaWidgetEditorElements)) {
            if (vanillaWidgetEditorElement.isSelected() || vanillaWidgetEditorElement.isHidden()) continue;
            vanillaWidgetEditorElement.method_25394(graphics, mouseX, mouseY, partial);
        }
        for (AbstractDeepEditorElement abstractDeepEditorElement : new ArrayList<AbstractDeepEditorElement>(this.deepEditorElements)) {
            if (abstractDeepEditorElement.isSelected() || abstractDeepEditorElement.isHidden()) continue;
            abstractDeepEditorElement.method_25394(graphics, mouseX, mouseY, partial);
        }
        if (!this.layout.renderElementsBehindVanilla) {
            for (AbstractEditorElement abstractEditorElement : new ArrayList<AbstractEditorElement>(this.normalEditorElements)) {
                if (abstractEditorElement.isSelected()) continue;
                abstractEditorElement.method_25394(graphics, mouseX, mouseY, partial);
            }
        }
        List<AbstractEditorElement> selected = this.getSelectedElements();
        for (AbstractEditorElement e : selected) {
            e.method_25394(graphics, mouseX, mouseY, partial);
        }
    }

    public void method_25420(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        if (this.layout.menuBackground != null) {
            this.layout.menuBackground.keepBackgroundAspectRatio = this.layout.preserveBackgroundAspectRatio;
            this.layout.menuBackground.opacity = 1.0f;
            this.layout.menuBackground.method_25394(graphics, mouseX, mouseY, partial);
        } else {
            graphics.method_25294(0, 0, this.field_22789, this.field_22790, UIBase.getUIColorTheme().screen_background_color_darker.getColorInt());
        }
        RenderingUtils.resetShaderColor(graphics);
        this.renderScrollListHeaderFooterPreview(graphics, mouseX, mouseY, partial);
        this.renderGrid(graphics);
    }

    protected void renderScrollListHeaderFooterPreview(class_332 graphics, int mouseX, int mouseY, float partial) {
        if (this.layout.showScrollListHeaderFooterPreviewInEditor) {
            class_2960 loc;
            ITexture footerTexture;
            int x0 = 0;
            int x1 = this.field_22789;
            int y0 = 48;
            int y1 = this.field_22790 - 64;
            ITexture headerTexture = this.layout.scrollListHeaderTexture != null ? (ITexture)this.layout.scrollListHeaderTexture.get() : null;
            ITexture iTexture = footerTexture = this.layout.scrollListFooterTexture != null ? (ITexture)this.layout.scrollListFooterTexture.get() : null;
            if (headerTexture != null) {
                loc = headerTexture.getResourceLocation();
                if (loc != null) {
                    RenderingUtils.resetShaderColor(graphics);
                    if (this.layout.preserveScrollListHeaderFooterAspectRatio) {
                        int[] headerSize = headerTexture.getAspectRatio().getAspectRatioSizeByMinimumSize(this.field_22789, y0);
                        int headerWidth = headerSize[0];
                        int headerHeight = headerSize[1];
                        int headerX = x0 + this.field_22789 / 2 - headerWidth / 2;
                        int headerY = y0 / 2 - headerHeight / 2;
                        graphics.method_44379(x0, 0, x0 + this.field_22789, y0);
                        graphics.method_25290(loc, headerX, headerY, 0.0f, 0.0f, headerWidth, headerHeight, headerWidth, headerHeight);
                        graphics.method_44380();
                    } else if (this.layout.repeatScrollListHeaderTexture) {
                        RenderingUtils.blitRepeat(graphics, loc, x0, 0, this.field_22789, y0, headerTexture.getWidth(), headerTexture.getHeight());
                    } else {
                        graphics.method_25290(loc, x0, 0, 0.0f, 0.0f, this.field_22789, y0, this.field_22789, y0);
                    }
                }
            } else {
                graphics.method_51422(0.25f, 0.25f, 0.25f, 1.0f);
                graphics.method_25290(class_437.field_44669, x0, 0, 0.0f, 0.0f, this.field_22789, y0, 32, 32);
            }
            if (footerTexture != null) {
                loc = footerTexture.getResourceLocation();
                if (loc != null) {
                    RenderingUtils.resetShaderColor(graphics);
                    if (this.layout.preserveScrollListHeaderFooterAspectRatio) {
                        int footerOriginalHeight = this.field_22790 - y1;
                        int[] footerSize = footerTexture.getAspectRatio().getAspectRatioSizeByMinimumSize(this.field_22789, footerOriginalHeight);
                        int footerWidth = footerSize[0];
                        int footerHeight = footerSize[1];
                        int footerX = x0 + this.field_22789 / 2 - footerWidth / 2;
                        int footerY = y1 + footerOriginalHeight / 2 - footerHeight / 2;
                        graphics.method_44379(x0, y1, x0 + this.field_22789, y1 + footerOriginalHeight);
                        graphics.method_25290(loc, footerX, footerY, 0.0f, 0.0f, footerWidth, footerHeight, footerWidth, footerHeight);
                        graphics.method_44380();
                    } else if (this.layout.repeatScrollListFooterTexture) {
                        int footerHeight = this.field_22790 - y1;
                        RenderingUtils.blitRepeat(graphics, loc, x0, y1, this.field_22789, footerHeight, footerTexture.getWidth(), footerTexture.getHeight());
                    } else {
                        int footerHeight = this.field_22790 - y1;
                        graphics.method_25290(loc, x0, y1, 0.0f, 0.0f, this.field_22789, footerHeight, this.field_22789, footerHeight);
                    }
                }
            } else {
                graphics.method_51422(0.25f, 0.25f, 0.25f, 1.0f);
                graphics.method_25290(class_437.field_44669, x0, y1, 0.0f, (float)y1, this.field_22789, this.field_22790 - y1, 32, 32);
            }
            RenderingUtils.resetShaderColor(graphics);
            if (this.layout.renderScrollListHeaderShadow) {
                graphics.method_25296(x0, y0, x1, y0 + 4, -16777216, 0);
            }
            if (this.layout.renderScrollListFooterShadow) {
                graphics.method_25296(x0, y1 - 4, x1, y1, 0, -16777216);
            }
            RenderingUtils.resetShaderColor(graphics);
        }
    }

    protected void renderGrid(@NotNull class_332 graphics) {
        if (FancyMenu.getOptions().showLayoutEditorGrid.getValue().booleanValue()) {
            int maxX;
            float scale = UIBase.calculateFixedScale(1.0f);
            int scaledWidth = (int)((float)this.field_22789 / scale);
            int scaledHeight = (int)((float)this.field_22790 / scale);
            graphics.method_51448().method_22903();
            graphics.method_51448().method_22905(scale, scale, scale);
            int gridSize = FancyMenu.getOptions().layoutEditorGridSize.getValue();
            int lineThickness = 1;
            graphics.method_25294(scaledWidth / 2 - 1, 0, scaledWidth / 2 + 1, scaledHeight, UIBase.getUIColorTheme().layout_editor_grid_color_center.getColorInt());
            for (int linesVerticalToLeftPosX = scaledWidth / 2 - gridSize - 1; linesVerticalToLeftPosX > 0; linesVerticalToLeftPosX -= gridSize) {
                int minY = 0;
                int maxY = scaledHeight;
                int maxX2 = linesVerticalToLeftPosX + lineThickness;
                graphics.method_25294(linesVerticalToLeftPosX, minY, maxX2, maxY, UIBase.getUIColorTheme().layout_editor_grid_color_normal.getColorInt());
            }
            for (int linesVerticalToRightPosX = scaledWidth / 2 + gridSize; linesVerticalToRightPosX < scaledWidth; linesVerticalToRightPosX += gridSize) {
                int minY = 0;
                int maxY = scaledHeight;
                maxX = linesVerticalToRightPosX + lineThickness;
                graphics.method_25294(linesVerticalToRightPosX, minY, maxX, maxY, UIBase.getUIColorTheme().layout_editor_grid_color_normal.getColorInt());
            }
            graphics.method_25294(0, scaledHeight / 2 - 1, scaledWidth, scaledHeight / 2 + 1, UIBase.getUIColorTheme().layout_editor_grid_color_center.getColorInt());
            for (int linesHorizontalToTopPosY = scaledHeight / 2 - gridSize - 1; linesHorizontalToTopPosY > 0; linesHorizontalToTopPosY -= gridSize) {
                int minX = 0;
                maxX = scaledWidth;
                int maxY = linesHorizontalToTopPosY + lineThickness;
                graphics.method_25294(minX, linesHorizontalToTopPosY, maxX, maxY, UIBase.getUIColorTheme().layout_editor_grid_color_normal.getColorInt());
            }
            for (int linesHorizontalToBottomPosY = scaledHeight / 2 + gridSize; linesHorizontalToBottomPosY < scaledHeight; linesHorizontalToBottomPosY += gridSize) {
                int minX = 0;
                int maxX3 = scaledWidth;
                int maxY = linesHorizontalToBottomPosY + lineThickness;
                graphics.method_25294(minX, linesHorizontalToBottomPosY, maxX3, maxY, UIBase.getUIColorTheme().layout_editor_grid_color_normal.getColorInt());
            }
            graphics.method_51448().method_22909();
        }
    }

    protected void constructElementInstances() {
        Object editorElement;
        for (AbstractEditorElement e : this.getAllElements()) {
            e.resetElementStates();
        }
        this.normalEditorElements.clear();
        this.vanillaWidgetEditorElements.clear();
        this.deepEditorElements.clear();
        Layout.OrderedElementCollection normalElements = new Layout.OrderedElementCollection();
        ArrayList vanillaWidgetElements = this.layoutTargetScreen != null ? new ArrayList() : null;
        ArrayList deepElements = this.layoutTargetScreen != null ? new ArrayList() : null;
        this.cachedVanillaWidgetMetas.clear();
        if (this.layoutTargetScreen != null) {
            this.cachedVanillaWidgetMetas.addAll(ScreenWidgetDiscoverer.getWidgetsOfScreen(this.layoutTargetScreen, true));
        }
        for (WidgetMeta m : this.cachedVanillaWidgetMetas) {
            class_339 class_3392 = m.getWidget();
            if (!(class_3392 instanceof CustomizableWidget)) continue;
            CustomizableWidget w = (CustomizableWidget)class_3392;
            w.resetWidgetCustomizationsFancyMenu();
        }
        this.constructElementInstances(this.layout.screenIdentifier, this.cachedVanillaWidgetMetas, this.layout, normalElements, vanillaWidgetElements, deepElements);
        for (AbstractElement e : ListUtils.mergeLists(normalElements.backgroundElements, normalElements.foregroundElements)) {
            editorElement = e.builder.wrapIntoEditorElementInternal(e, this);
            if (editorElement == null) continue;
            this.normalEditorElements.add((AbstractEditorElement)editorElement);
        }
        if (deepElements != null) {
            for (AbstractElement e : deepElements) {
                editorElement = e.builder.wrapIntoEditorElementInternal(e, this);
                if (!(editorElement instanceof AbstractDeepEditorElement)) continue;
                AbstractDeepEditorElement d = (AbstractDeepEditorElement)editorElement;
                this.deepEditorElements.add(d);
            }
        }
        if (vanillaWidgetElements != null) {
            for (AbstractElement e : vanillaWidgetElements) {
                editorElement = (VanillaWidgetEditorElement)VanillaWidgetElementBuilder.INSTANCE.wrapIntoEditorElementInternal(e, this);
                if (editorElement == null) continue;
                this.vanillaWidgetEditorElements.add((VanillaWidgetEditorElement)editorElement);
            }
        }
    }

    protected void serializeElementInstancesToLayoutInstance() {
        SerializedElement serialized;
        this.layout.serializedElements.clear();
        this.layout.serializedVanillaButtonElements.clear();
        this.layout.serializedDeepElements.clear();
        for (AbstractEditorElement abstractEditorElement : this.normalEditorElements) {
            serialized = abstractEditorElement.element.builder.serializeElementInternal(abstractEditorElement.element);
            if (serialized == null) continue;
            this.layout.serializedElements.add(serialized);
        }
        for (AbstractEditorElement abstractEditorElement : this.deepEditorElements) {
            serialized = abstractEditorElement.element.builder.serializeElementInternal(abstractEditorElement.element);
            if (serialized == null) continue;
            this.layout.serializedDeepElements.add(serialized);
        }
        for (VanillaWidgetEditorElement vanillaWidgetEditorElement : this.vanillaWidgetEditorElements) {
            serialized = VanillaWidgetElementBuilder.INSTANCE.serializeElementInternal(vanillaWidgetEditorElement.element);
            if (serialized == null) continue;
            this.layout.serializedVanillaButtonElements.add(serialized);
        }
    }

    @NotNull
    public List<AbstractEditorElement> getAllElements() {
        ArrayList<AbstractEditorElement> elements = new ArrayList<AbstractEditorElement>();
        ArrayList<AbstractEditorElement> selected = new ArrayList<AbstractEditorElement>();
        ArrayList<AbstractEditorElement> elementsFinal = new ArrayList<AbstractEditorElement>();
        if (this.layout.renderElementsBehindVanilla) {
            elements.addAll(this.normalEditorElements);
        }
        elements.addAll(this.vanillaWidgetEditorElements);
        elements.addAll(this.deepEditorElements);
        if (!this.layout.renderElementsBehindVanilla) {
            elements.addAll(this.normalEditorElements);
        }
        for (AbstractEditorElement e : elements) {
            if (!e.isSelected()) {
                elementsFinal.add(e);
                continue;
            }
            selected.add(e);
        }
        elementsFinal.addAll(selected);
        return elementsFinal;
    }

    @NotNull
    public List<AbstractEditorElement> getHoveredElements() {
        ArrayList<AbstractEditorElement> elements = new ArrayList<AbstractEditorElement>();
        for (AbstractEditorElement e : this.getAllElements()) {
            HideableElement h;
            boolean hidden;
            if (!e.isHovered() || (hidden = e instanceof HideableElement && (h = (HideableElement)((Object)e)).isHidden())) continue;
            elements.add(e);
        }
        return elements;
    }

    @Nullable
    public AbstractEditorElement getTopHoveredElement() {
        List<AbstractEditorElement> hoveredElements = this.getHoveredElements();
        return !hoveredElements.isEmpty() ? hoveredElements.get(hoveredElements.size() - 1) : null;
    }

    @NotNull
    public List<AbstractEditorElement> getSelectedElements() {
        ArrayList<AbstractEditorElement> l = new ArrayList<AbstractEditorElement>();
        this.getAllElements().forEach(element -> {
            if (element.isSelected()) {
                l.add((AbstractEditorElement)element);
            }
        });
        return l;
    }

    @NotNull
    protected <E extends AbstractEditorElement> List<E> getSelectedElementsOfType(@NotNull Class<E> type) {
        ArrayList<AbstractEditorElement> l = new ArrayList<AbstractEditorElement>();
        for (AbstractEditorElement e : this.getSelectedElements()) {
            if (!type.isAssignableFrom(e.getClass())) continue;
            l.add(e);
        }
        return l;
    }

    @Nullable
    public AbstractEditorElement getElementByInstanceIdentifier(@NotNull String instanceIdentifier) {
        instanceIdentifier = instanceIdentifier.replace("vanillabtn:", "").replace("button_compatibility_id:", "");
        for (AbstractEditorElement e : this.getAllElements()) {
            if (!e.element.getInstanceIdentifier().equals(instanceIdentifier)) continue;
            return e;
        }
        return null;
    }

    public void selectAllElements() {
        for (AbstractEditorElement e : this.getAllElements()) {
            e.setSelected(true);
        }
    }

    public void deselectAllElements() {
        for (AbstractEditorElement e : this.getAllElements()) {
            e.setSelected(false);
        }
    }

    public boolean deleteElement(@NotNull AbstractEditorElement element) {
        if (element.settings.isDestroyable()) {
            if (!element.settings.shouldHideInsteadOfDestroy()) {
                this.normalEditorElements.remove(element);
                this.vanillaWidgetEditorElements.remove(element);
                this.deepEditorElements.remove(element);
                for (AbstractLayoutEditorWidget w : this.layoutEditorWidgets) {
                    w.editorElementRemovedOrHidden(element);
                }
                return true;
            }
            if (element instanceof HideableElement) {
                HideableElement hideable = (HideableElement)((Object)element);
                hideable.setHidden(true);
                return true;
            }
        }
        return false;
    }

    protected boolean isElementOverlappingArea(@NotNull AbstractEditorElement element, int xStart, int yStart, int xEnd, int yEnd) {
        int elementStartX = element.getX();
        int elementStartY = element.getY();
        int elementEndX = element.getX() + element.getWidth();
        int elementEndY = element.getY() + element.getHeight();
        return xEnd > elementStartX && yEnd > elementStartY && yStart < elementEndY && xStart < elementEndX;
    }

    public boolean allSelectedElementsMovable() {
        for (AbstractEditorElement e : this.getSelectedElements()) {
            if (e.settings.isMovable()) continue;
            return false;
        }
        return true;
    }

    public boolean canMoveLayerUp(AbstractEditorElement element) {
        int index = this.normalEditorElements.indexOf(element);
        if (index == -1) {
            return false;
        }
        return index < this.normalEditorElements.size() - 1;
    }

    public boolean canMoveLayerDown(AbstractEditorElement element) {
        int index = this.normalEditorElements.indexOf(element);
        return index > 0;
    }

    @Nullable
    public AbstractEditorElement moveLayerUp(@NotNull AbstractEditorElement element) {
        AbstractEditorElement movedAbove = null;
        try {
            if (this.normalEditorElements.contains(element)) {
                ArrayList<AbstractEditorElement> newNormalEditorElements = new ArrayList<AbstractEditorElement>();
                int index = this.normalEditorElements.indexOf(element);
                int i = 0;
                if (index < this.normalEditorElements.size() - 1) {
                    for (AbstractEditorElement e : this.normalEditorElements) {
                        if (e != element) {
                            newNormalEditorElements.add(e);
                            if (i == index + 1) {
                                movedAbove = e;
                                newNormalEditorElements.add(element);
                            }
                        }
                        ++i;
                    }
                    this.normalEditorElements = newNormalEditorElements;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return movedAbove;
    }

    @Nullable
    public AbstractEditorElement moveLayerDown(AbstractEditorElement element) {
        AbstractEditorElement movedBehind = null;
        try {
            if (this.normalEditorElements.contains(element)) {
                ArrayList<AbstractEditorElement> newNormalEditorElements = new ArrayList<AbstractEditorElement>();
                int index = this.normalEditorElements.indexOf(element);
                int i = 0;
                if (index > 0) {
                    for (AbstractEditorElement e : this.normalEditorElements) {
                        if (e != element) {
                            if (i == index - 1) {
                                newNormalEditorElements.add(element);
                                movedBehind = e;
                            }
                            newNormalEditorElements.add(e);
                        }
                        ++i;
                    }
                    this.normalEditorElements = newNormalEditorElements;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return movedBehind;
    }

    public void copyElementsToClipboard(AbstractEditorElement ... elements) {
        if (elements != null && elements.length > 0) {
            COPIED_ELEMENTS_CLIPBOARD.clear();
            for (AbstractEditorElement e : elements) {
                SerializedElement serialized;
                if (!e.settings.isCopyable() || (serialized = e.element.builder.serializeElementInternal(e.element)) == null) continue;
                serialized.putProperty("instance_identifier", ScreenCustomization.generateUniqueIdentifier());
                COPIED_ELEMENTS_CLIPBOARD.put(serialized, e.element.builder);
            }
        }
    }

    public void pasteElementsFromClipboard() {
        if (!COPIED_ELEMENTS_CLIPBOARD.isEmpty()) {
            this.deselectAllElements();
            for (Map.Entry<SerializedElement, ElementBuilder<?, ?>> m : COPIED_ELEMENTS_CLIPBOARD.entrySet()) {
                Object deserializedEditorElement;
                m.getKey().putProperty("instance_identifier", ScreenCustomization.generateUniqueIdentifier());
                Object deserialized = m.getValue().deserializeElementInternal(m.getKey());
                if (deserialized == null || (deserializedEditorElement = m.getValue().wrapIntoEditorElementInternal((AbstractElement)deserialized, this)) == null) continue;
                this.normalEditorElements.add((AbstractEditorElement)deserializedEditorElement);
                this.layoutEditorWidgets.forEach(widget -> widget.editorElementAdded((AbstractEditorElement)deserializedEditorElement));
                ((AbstractEditorElement)deserializedEditorElement).setSelected(true);
            }
        }
    }

    public void saveLayout() {
        if (this.layout.layoutFile != null) {
            this.layout.updateLastEditedTime();
            this.serializeElementInstancesToLayoutInstance();
            if (!this.layout.saveToFileIfPossible()) {
                class_310.method_1551().method_1507((class_437)NotificationScreen.error(call -> class_310.method_1551().method_1507((class_437)this), LocalizationUtils.splitLocalizedStringLines("fancymenu.editor.saving_failed.generic", new String[0])));
            } else {
                LayoutHandler.reloadLayouts();
            }
        } else {
            this.saveLayoutAs();
        }
    }

    public void saveLayoutAs() {
        Object fileNamePreset = "universal_layout";
        if (this.layoutTargetScreen != null) {
            fileNamePreset = ScreenIdentifierHandler.getIdentifierOfScreen(this.layoutTargetScreen) + "_layout";
        }
        fileNamePreset = ((String)fileNamePreset).toLowerCase();
        fileNamePreset = CharacterFilter.buildOnlyLowercaseFileNameFilter().filterForAllowedChars((String)fileNamePreset);
        fileNamePreset = FileUtils.generateAvailableFilename((String)LayoutHandler.LAYOUT_DIR.getAbsolutePath(), (String)fileNamePreset, (String)"txt");
        if (this.layout.layoutFile != null) {
            fileNamePreset = this.layout.layoutFile.getName();
        }
        SaveFileScreen s = (SaveFileScreen)SaveFileScreen.build(LayoutHandler.LAYOUT_DIR, (String)fileNamePreset, "txt", call -> {
            if (call != null) {
                try {
                    Layout old;
                    this.layout.updateLastEditedTime();
                    this.serializeElementInstancesToLayoutInstance();
                    this.layout.layoutFile = call.getAbsoluteFile();
                    if (this.layout.layoutFile.isFile() && (old = LayoutHandler.getLayout(this.layout.getLayoutName())) != null) {
                        old.delete(false);
                    }
                    if (!this.layout.saveToFileIfPossible()) {
                        class_310.method_1551().method_1507((class_437)NotificationScreen.error(call2 -> class_310.method_1551().method_1507((class_437)this), LocalizationUtils.splitLocalizedStringLines("fancymenu.editor.saving_failed.generic", new String[0])));
                    } else {
                        LayoutHandler.reloadLayouts();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    class_310.method_1551().method_1507((class_437)NotificationScreen.error(call2 -> class_310.method_1551().method_1507((class_437)this), LocalizationUtils.splitLocalizedStringLines("fancymenu.editor.saving_failed.generic", new String[0])));
                }
            }
            class_310.method_1551().method_1507((class_437)this);
        }).setVisibleDirectoryLevelsAboveRoot(2).setShowSubDirectories(false);
        FileTypeGroup fileTypeGroup = FileTypeGroup.of((FileType[])new TextFileType[]{FileTypes.TXT_TEXT});
        fileTypeGroup.setDisplayName((class_2561)class_2561.method_43471((String)"fancymenu.file_types.groups.text"));
        s.setFileTypes(fileTypeGroup);
        class_310.method_1551().method_1507((class_437)s);
    }

    public void onUpdateSelectedElements() {
        List<AbstractEditorElement> selected = this.getSelectedElements();
        if (selected.size() > 1) {
            for (AbstractEditorElement e : selected) {
                e.setMultiSelected(true);
            }
        } else if (selected.size() == 1) {
            selected.get(0).setMultiSelected(false);
        }
    }

    public void openRightClickMenuAtMouse(int mouseX, int mouseY) {
        if (this.rightClickMenu != null) {
            this.rightClickMenuOpenPosX = mouseX;
            this.rightClickMenuOpenPosY = mouseY;
            this.rightClickMenu.openMenuAtMouse();
        }
    }

    public void closeRightClickMenu() {
        if (this.rightClickMenu != null) {
            if (this.rightClickMenu.isUserNavigatingInMenu()) {
                return;
            }
            this.rightClickMenuOpenPosX = -1000;
            this.rightClickMenuOpenPosY = -1000;
            this.rightClickMenu.closeMenu();
        }
    }

    public void openElementContextMenuAtMouseIfPossible() {
        this.closeActiveElementMenu();
        List<AbstractEditorElement> selectedElements = this.getSelectedElements();
        if (selectedElements.size() == 1) {
            this.activeElementContextMenu = selectedElements.get((int)0).rightClickMenu;
            ((IMixinScreen)((Object)this)).getChildrenFancyMenu().add(0, this.activeElementContextMenu);
            this.activeElementContextMenu.openMenuAtMouse();
        } else if (selectedElements.size() > 1) {
            List<ContextMenu> menus = ObjectUtils.getOfAll(ContextMenu.class, selectedElements, consumes -> consumes.rightClickMenu);
            this.activeElementContextMenu = ContextMenu.stackContextMenus(menus);
            ((IMixinScreen)((Object)this)).getChildrenFancyMenu().add(0, this.activeElementContextMenu);
            this.activeElementContextMenu.openMenuAtMouse();
        }
    }

    public void closeActiveElementMenu(boolean forceClose) {
        if (this.activeElementContextMenu != null) {
            if (!forceClose && this.activeElementContextMenu.isUserNavigatingInMenu()) {
                return;
            }
            this.activeElementContextMenu.closeMenu();
            this.method_37066(this.activeElementContextMenu);
        }
        this.activeElementContextMenu = null;
    }

    public void closeActiveElementMenu() {
        this.closeActiveElementMenu(false);
    }

    public boolean isUserNavigatingInRightClickMenu() {
        return this.rightClickMenu != null && this.rightClickMenu.isUserNavigatingInMenu();
    }

    public boolean isUserNavigatingInElementMenu() {
        return this.activeElementContextMenu != null && this.activeElementContextMenu.isUserNavigatingInMenu();
    }

    public void saveWidgetSettings() {
        for (AbstractLayoutEditorWidget w : this.layoutEditorWidgets) {
            w.getBuilder().writeSettingsInternal(w);
        }
    }

    @NotNull
    public List<AbstractEditorElement> getCurrentlyDraggedElements() {
        return this.currentlyDraggedElements;
    }

    @Nullable
    protected List<AbstractEditorElement> getElementChildChainOfExcluding(@NotNull AbstractEditorElement element) {
        Objects.requireNonNull(element);
        ArrayList<AbstractEditorElement> chain = new ArrayList<AbstractEditorElement>();
        try {
            AbstractEditorElement e = element;
            while ((e = this.getChildElementOf(e)) != null) {
                if (e == element) {
                    throw new IllegalStateException("Child of origin element is its own child. This shouldn't be possible and comes from an invalid ELEMENT anchor point. You need to manually fix this.");
                }
                if (chain.contains(e)) {
                    throw new IllegalStateException("Chain already contains element! This shouldn't be possible and probably comes from an invalid ELEMENT anchor who's child is its parent or similar scenarios (sweet home Alabama). You need to manually fix this.");
                }
                chain.add(e);
            }
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] There was an error while trying to get the element chain!", (Throwable)ex);
            return null;
        }
        return chain;
    }

    @Nullable
    protected AbstractEditorElement getChildElementOf(@NotNull AbstractEditorElement element) {
        for (AbstractEditorElement e : this.getAllElements()) {
            String parentOfE = e.element.anchorPointElementIdentifier;
            if (parentOfE == null || !parentOfE.equals(element.element.getInstanceIdentifier())) continue;
            return e;
        }
        return null;
    }

    protected void moveSelectedElementsByXYOffset(int offsetX, int offsetY) {
        List<AbstractEditorElement> selected = this.getSelectedElements();
        if (!selected.isEmpty() && this.allSelectedElementsMovable()) {
            this.history.saveSnapshot();
        }
        boolean multiSelect = selected.size() > 1;
        for (AbstractEditorElement e : selected) {
            if (this.allSelectedElementsMovable()) {
                if (multiSelect && e.isElementAnchorAndParentIsSelected()) continue;
                e.element.posOffsetX += offsetX;
                e.element.posOffsetY += offsetY;
                continue;
            }
            if (e.settings.isMovable()) continue;
            e.renderMovingNotAllowedTime = System.currentTimeMillis() + 800L;
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean menuBarContextOpen;
        this.leftMouseDownPosX = (int)mouseX;
        this.leftMouseDownPosY = (int)mouseY;
        boolean bl = menuBarContextOpen = this.menuBar != null && this.menuBar.isEntryContextMenuOpen();
        if (PopupHandler.isPopupActive()) {
            this.closeRightClickMenu();
            this.closeActiveElementMenu();
            return false;
        }
        if (super.method_25402(mouseX, mouseY, button)) {
            this.closeRightClickMenu();
            this.closeActiveElementMenu();
            return true;
        }
        if (menuBarContextOpen) {
            return true;
        }
        AbstractEditorElement topHoverElement = this.getTopHoveredElement();
        boolean topHoverGotSelected = false;
        if (!(topHoverElement == null || this.rightClickMenu.isUserNavigatingInMenu() || this.activeElementContextMenu != null && this.activeElementContextMenu.isUserNavigatingInMenu() || topHoverElement.isSelected())) {
            topHoverElement.setSelected(true);
            topHoverElement.recentlyLeftClickSelected = true;
            topHoverGotSelected = true;
        }
        boolean canStartMouseSelection = true;
        for (AbstractEditorElement e : this.getAllElements()) {
            e.method_25402(mouseX, mouseY, button);
            if (!e.isHovered() && !e.isGettingResized() && e.getHoveredResizeGrabber() == null) continue;
            canStartMouseSelection = false;
        }
        if (button == 0 && canStartMouseSelection) {
            this.isMouseSelection = true;
            this.mouseSelectionStartX = (int)mouseX;
            this.mouseSelectionStartY = (int)mouseY;
        }
        if (!(this.rightClickMenu.isUserNavigatingInMenu() || this.activeElementContextMenu != null && this.activeElementContextMenu.isUserNavigatingInMenu() || LayoutEditorScreen.method_25441() || button != 0 && (button != 1 || topHoverElement != null && !topHoverGotSelected))) {
            for (AbstractEditorElement e : this.getAllElements()) {
                if (e.isGettingResized() || topHoverElement != null && e == topHoverElement) continue;
                e.setSelected(false);
            }
        }
        this.closeActiveElementMenu();
        if (button == 0 && !this.rightClickMenu.isUserNavigatingInMenu()) {
            this.closeRightClickMenu();
        }
        if (topHoverElement == null) {
            if (button == 1) {
                this.openRightClickMenuAtMouse((int)mouseX, (int)mouseY);
            }
        } else {
            this.closeRightClickMenu();
            if (button == 1) {
                this.openElementContextMenuAtMouseIfPossible();
            }
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        AbstractEditorElement topHoverElement;
        this.anchorPointOverlay.method_25406(mouseX, mouseY, button);
        this.elementMovingStarted = false;
        this.elementResizingStarted = false;
        this.currentlyDraggedElements.clear();
        boolean mouseWasInDraggingMode = this.mouseDraggingStarted;
        this.mouseDraggingStarted = false;
        boolean cachedMouseSelection = this.isMouseSelection;
        if (button == 0) {
            this.isMouseSelection = false;
        }
        if (PopupHandler.isPopupActive()) {
            return false;
        }
        this.method_25398(false);
        for (class_364 child : this.method_25396()) {
            if (!child.method_25406(mouseX, mouseY, button)) continue;
            return true;
        }
        List<AbstractEditorElement> hoveredElements = this.getHoveredElements();
        AbstractEditorElement abstractEditorElement = topHoverElement = !hoveredElements.isEmpty() ? hoveredElements.get(hoveredElements.size() - 1) : null;
        if (!mouseWasInDraggingMode && !cachedMouseSelection && button == 0 && topHoverElement != null && topHoverElement.isSelected() && !topHoverElement.recentlyMovedByDragging && !topHoverElement.recentlyLeftClickSelected && LayoutEditorScreen.method_25441()) {
            topHoverElement.setSelected(false);
        }
        boolean elementRecentlyMovedByDragging = false;
        for (AbstractEditorElement e : this.getAllElements()) {
            if (e.recentlyMovedByDragging) {
                elementRecentlyMovedByDragging = true;
            }
            e.method_25406(mouseX, mouseY, button);
            e.recentlyLeftClickSelected = false;
        }
        if (elementRecentlyMovedByDragging && this.preDragElementSnapshot != null) {
            this.history.saveSnapshot(this.preDragElementSnapshot);
        }
        this.preDragElementSnapshot = null;
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double $$3, double $$4) {
        boolean movingCrumpleZonePassed;
        if (PopupHandler.isPopupActive()) {
            return false;
        }
        if (super.method_25403(mouseX, mouseY, button, $$3, $$4)) {
            return true;
        }
        if (this.isMouseSelection) {
            for (AbstractEditorElement e : this.getAllElements()) {
                boolean b = this.isElementOverlappingArea(e, Math.min(this.mouseSelectionStartX, (int)mouseX), Math.min(this.mouseSelectionStartY, (int)mouseY), Math.max(this.mouseSelectionStartX, (int)mouseX), Math.max(this.mouseSelectionStartY, (int)mouseY));
                if (!b && LayoutEditorScreen.method_25441()) continue;
                e.setSelected(b);
            }
        }
        if (this.preDragElementSnapshot == null) {
            this.preDragElementSnapshot = this.history.createSnapshot();
        }
        int draggingDiffX = (int)(mouseX - (double)this.leftMouseDownPosX);
        int draggingDiffY = (int)(mouseY - (double)this.leftMouseDownPosY);
        if (draggingDiffX != 0 || draggingDiffY != 0) {
            this.mouseDraggingStarted = true;
        }
        List<AbstractEditorElement> allElements = this.getAllElements();
        if (!this.elementResizingStarted) {
            allElements.forEach(element -> element.updateResizingStartPos((int)mouseX, (int)mouseY));
        }
        this.elementResizingStarted = true;
        boolean bl = movingCrumpleZonePassed = Math.abs(draggingDiffX) >= 5 || Math.abs(draggingDiffY) >= 5;
        if (movingCrumpleZonePassed) {
            if (!this.elementMovingStarted) {
                allElements.forEach(element -> {
                    element.updateMovingStartPos((int)mouseX, (int)mouseY);
                    element.movingCrumpleZonePassed = true;
                });
                if (this.allSelectedElementsMovable()) {
                    this.currentlyDraggedElements.addAll(this.getSelectedElements());
                }
            }
            this.elementMovingStarted = true;
        }
        for (AbstractEditorElement e : allElements) {
            if (e.method_25403(mouseX, mouseY, button, $$3, $$4)) break;
        }
        return false;
    }

    public boolean method_25404(int keycode, int scancode, int modifiers) {
        if (PopupHandler.isPopupActive()) {
            return false;
        }
        this.anchorPointOverlay.method_25404(keycode, scancode, modifiers);
        if (super.method_25404(keycode, scancode, modifiers)) {
            return true;
        }
        String key = GLFW.glfwGetKeyName((int)keycode, (int)scancode);
        if (key == null) {
            key = "";
        }
        if (keycode == 263) {
            this.moveSelectedElementsByXYOffset(-1, 0);
            return true;
        }
        if (keycode == 265) {
            this.moveSelectedElementsByXYOffset(0, -1);
            return true;
        }
        if (keycode == 262) {
            this.moveSelectedElementsByXYOffset(1, 0);
            return true;
        }
        if (keycode == 264) {
            this.moveSelectedElementsByXYOffset(0, 1);
            return true;
        }
        if (key.equals("a") && LayoutEditorScreen.method_25441()) {
            this.selectAllElements();
        }
        if (key.equals("c") && LayoutEditorScreen.method_25441()) {
            this.copyElementsToClipboard(this.getSelectedElements().toArray(new AbstractEditorElement[0]));
            return true;
        }
        if (key.equals("v") && LayoutEditorScreen.method_25441()) {
            this.pasteElementsFromClipboard();
            return true;
        }
        if (key.equals("s") && LayoutEditorScreen.method_25441()) {
            this.saveLayout();
            return true;
        }
        if (key.equals("z") && LayoutEditorScreen.method_25441()) {
            this.history.stepBack();
            return true;
        }
        if (key.equals("y") && LayoutEditorScreen.method_25441()) {
            this.history.stepForward();
            return true;
        }
        if (key.equals("g") && LayoutEditorScreen.method_25441()) {
            try {
                FancyMenu.getOptions().showLayoutEditorGrid.setValue(FancyMenu.getOptions().showLayoutEditorGrid.getValue() == false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return true;
        }
        if (keycode == 261) {
            this.history.saveSnapshot();
            for (AbstractEditorElement e : this.getSelectedElements()) {
                e.deleteElement();
            }
            return true;
        }
        return super.method_25404(keycode, scancode, modifiers);
    }

    public boolean method_16803(int keycode, int scancode, int modifiers) {
        this.anchorPointOverlay.method_16803(keycode, scancode, modifiers);
        return super.method_16803(keycode, scancode, modifiers);
    }

    public void closeEditor() {
        this.saveWidgetSettings();
        currentInstance = null;
        if (this.layoutTargetScreen != null) {
            if (!((IMixinScreen)this.layoutTargetScreen).get_initialized_FancyMenu()) {
                class_310.method_1551().method_1507(this.layoutTargetScreen);
            } else {
                class_310.method_1551().method_1507((class_437)new class_424((class_2561)class_2561.method_43470((String)"Closing editor..")));
                class_310.method_1551().field_1755 = this.layoutTargetScreen;
                ScreenCustomization.reInitCurrentScreen();
            }
        } else {
            class_310.method_1551().method_1507(null);
        }
    }

    public LayoutEditorScreen setAsCurrentInstance() {
        currentInstance = this;
        return this;
    }

    @Nullable
    public static LayoutEditorScreen getCurrentInstance() {
        return currentInstance;
    }
}

