/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.placeholder;

import de.keksuccino.fancymenu.customization.placeholder.Placeholder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlaceholderRegistry {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<String, Placeholder> PLACEHOLDERS = new LinkedHashMap<String, Placeholder>();

    public static void register(@NotNull Placeholder placeholder) {
        if (PLACEHOLDERS.containsKey(Objects.requireNonNull(placeholder.getIdentifier()))) {
            LOGGER.warn("[FANCYMENU] A placeholder with the identifier '" + placeholder.getIdentifier() + "' is already registered! Overriding placeholder!");
        }
        PLACEHOLDERS.put(placeholder.getIdentifier(), placeholder);
    }

    @NotNull
    public static List<Placeholder> getPlaceholders() {
        return new ArrayList<Placeholder>(PLACEHOLDERS.values());
    }

    @Nullable
    public static Placeholder getPlaceholder(String identifier) {
        Placeholder ph = PLACEHOLDERS.get(identifier);
        if (ph != null) {
            return ph;
        }
        for (Placeholder p : PLACEHOLDERS.values()) {
            List<String> alt = p.getAlternativeIdentifiers();
            if (alt == null || !alt.contains(identifier)) continue;
            return p;
        }
        return null;
    }
}

