/*
 * Decompiled with CFR 0.152.
 */
package com.minenash.seamless_loading_screen;

import com.minenash.seamless_loading_screen.ScreenshotLoader;
import com.minenash.seamless_loading_screen.config.SeamlessLoadingScreenConfig;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import java.util.function.Consumer;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import net.minecraft.class_7923;
import org.joml.Matrix4f;
import org.joml.Vector4f;
import org.slf4j.Logger;

public class FadeScreen
extends class_437 {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final int fadeFrames;
    private int frames;
    private Consumer<Boolean> callback;
    private boolean done;

    public FadeScreen(int totalFrames, int fadeFrames) {
        super((class_2561)class_2561.method_43471((String)"seamless_loading_screen.screen.loading_chunks"));
        this.fadeFrames = Math.min(totalFrames, fadeFrames);
        this.frames = totalFrames;
    }

    public FadeScreen then(Consumer<Boolean> callback) {
        this.callback = callback;
        return this;
    }

    public void method_25432() {
        this.markDone(true);
        super.method_25432();
    }

    protected void method_25426() {
        if (SeamlessLoadingScreenConfig.get().playSoundEffect) {
            class_2960 id = class_2960.method_12829((String)SeamlessLoadingScreenConfig.get().soundEffect);
            if (id != null) {
                class_3414 soundEvent = class_7923.field_41172.method_17966(id).orElse(class_3417.field_14671);
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)soundEvent, (float)SeamlessLoadingScreenConfig.get().soundPitch, (float)SeamlessLoadingScreenConfig.get().soundVolume));
            } else {
                LOGGER.error("[SeamlessLoadingScreen]: Unable to parse the above SoundEffect due to it not being a valid Identifier. [Value: {}]", (Object)SeamlessLoadingScreenConfig.get().soundEffect);
            }
        }
    }

    private void markDone(boolean forceClosed) {
        if (this.done) {
            return;
        }
        this.done = true;
        this.frames = 0;
        if (this.callback != null) {
            this.callback.accept(forceClosed);
        }
        if (this.callback == null && !forceClosed && this.field_22787 != null && this.field_22787.field_1755 == this) {
            this.field_22787.method_1507(null);
        }
    }

    public boolean method_25422() {
        return true;
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        if (this.frames <= 0 || this.field_22787 == null) {
            return;
        }
        boolean doFade = this.frames <= this.fadeFrames;
        float alpha = doFade ? Math.min((float)this.frames / (float)this.fadeFrames, 1.0f) : 1.0f;
        Vector4f color = new Vector4f(1.0f, 1.0f, 1.0f, alpha);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34543);
        if (ScreenshotLoader.loaded) {
            RenderSystem.setShaderTexture((int)0, (class_2960)ScreenshotLoader.SCREENSHOT);
            int w = (int)(ScreenshotLoader.imageRatio * (double)this.field_22790);
            int h = this.field_22790;
            int x = this.field_22789 / 2 - w / 2;
            int y = 0;
            this.loadQuad(context, color, x, y, x + w, y + h);
            if (w < this.field_22789) {
                RenderSystem.setShaderTexture((int)0, (class_2960)field_44669);
                color.set(0.25f, 0.25f, 0.25f, alpha);
                this.loadQuad(context, color, 0, 0, x, this.field_22790, 0.0f, 0.0f, (float)x / 32.0f, (float)this.field_22790 / 32.0f);
                this.loadQuad(context, color, x + w, 0, this.field_22789, this.field_22790, (float)(x + w) / 32.0f, 0.0f, (float)this.field_22789 / 32.0f, (float)this.field_22790 / 32.0f);
            }
        } else {
            RenderSystem.setShaderTexture((int)0, (class_2960)field_44669);
            color.set(0.25f, 0.25f, 0.25f, alpha);
            this.loadQuad(context, color, 0, 0, this.field_22789, this.field_22790, 0.0f, 0.0f, (float)this.field_22789 / 32.0f, (float)this.field_22790 / 32.0f);
        }
        ScreenshotLoader.renderAfterEffects(this, context, alpha);
        if (!doFade) {
            context.method_27534(this.field_22787.field_1772, this.field_22785, this.field_22789 / 2, 70, 0xFFFFFF);
            String progress = String.valueOf(this.field_22787.field_1769.method_3246());
            context.method_25300(this.field_22787.field_1772, progress, this.field_22789 / 2, 90, 0xFFFFFF);
        }
        RenderSystem.disableBlend();
        --this.frames;
        if (this.frames == 0) {
            this.markDone(false);
        }
    }

    private void loadQuad(class_332 context, Vector4f color, int x0, int y0, int x1, int y1) {
        this.loadQuad(context, color, x0, y0, x1, y1, 0.0f, 0.0f, 1.0f, 1.0f);
    }

    private void loadQuad(class_332 context, Vector4f color, int x0, int y0, int x1, int y1, float u0, float v0, float u1, float v1) {
        class_4587 stack = context.method_51448();
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
        Matrix4f modelMat = stack.method_23760().method_23761();
        bufferBuilder.method_22918(modelMat, (float)x0, (float)y1, 0.0f).method_22913(u0, v1).method_22915(color.x(), color.y(), color.z(), color.w()).method_1344();
        bufferBuilder.method_22918(modelMat, (float)x1, (float)y1, 0.0f).method_22913(u1, v1).method_22915(color.x(), color.y(), color.z(), color.w()).method_1344();
        bufferBuilder.method_22918(modelMat, (float)x1, (float)y0, 0.0f).method_22913(u1, v0).method_22915(color.x(), color.y(), color.z(), color.w()).method_1344();
        bufferBuilder.method_22918(modelMat, (float)x0, (float)y0, 0.0f).method_22913(u0, v0).method_22915(color.x(), color.y(), color.z(), color.w()).method_1344();
        tessellator.method_1350();
    }
}

