/*
 * Decompiled with CFR 0.152.
 */
package com.minenash.seamless_loading_screen.config;

import com.minenash.seamless_loading_screen.DisplayMode;
import com.minenash.seamless_loading_screen.PlatformFunctions;
import com.minenash.seamless_loading_screen.config.SafeColorTypeAdapter;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.ListOption;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import dev.isxander.yacl3.api.controller.ColorControllerBuilder;
import dev.isxander.yacl3.api.controller.EnumControllerBuilder;
import dev.isxander.yacl3.api.controller.FloatFieldControllerBuilder;
import dev.isxander.yacl3.api.controller.FloatSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.IntegerFieldControllerBuilder;
import dev.isxander.yacl3.api.controller.StringControllerBuilder;
import dev.isxander.yacl3.config.v2.api.ConfigClassHandler;
import dev.isxander.yacl3.config.v2.api.SerialEntry;
import dev.isxander.yacl3.config.v2.api.serializer.GsonConfigSerializerBuilder;
import java.awt.Color;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3417;

public class SeamlessLoadingScreenConfig {
    private static final SafeColorTypeAdapter colorAdapter = new SafeColorTypeAdapter(() -> SeamlessLoadingScreenConfig.getDefaults().tintColor);
    private static final ConfigClassHandler<SeamlessLoadingScreenConfig> CONFIG_CLASS_HANDLER = ConfigClassHandler.createBuilder(SeamlessLoadingScreenConfig.class).id(new class_2960("seamless_loading_screen", "config")).serializer(config -> GsonConfigSerializerBuilder.create((ConfigClassHandler)config).appendGsonBuilder(builder -> builder.setPrettyPrinting().disableHtmlEscaping().serializeNulls().registerTypeHierarchyAdapter(Color.class, (Object)colorAdapter)).setPath(PlatformFunctions.getConfigDirectory().resolve("seamless_loading_screen.json")).build()).build();
    @SerialEntry
    public int fade = 20;
    @SerialEntry
    public int time = 80;
    @SerialEntry
    public Color tintColor = new Color(0x212121);
    @SerialEntry
    public float tintStrength = 0.3f;
    @SerialEntry
    public boolean enableScreenshotBlur = false;
    @SerialEntry
    public float screenshotBlurStrength = 1.0f;
    @SerialEntry
    public float screenshotBlurQuality = 5.0f;
    @SerialEntry
    public boolean playSoundEffect = false;
    @SerialEntry
    public String soundEffect = class_3417.field_14641.method_14833().toString();
    @SerialEntry
    public float soundPitch = 1.0f;
    @SerialEntry
    public float soundVolume = 1.0f;
    @SerialEntry
    public ScreenshotResolution resolution = ScreenshotResolution.Normal;
    @SerialEntry
    public boolean disableCamera = true;
    @SerialEntry
    public boolean archiveScreenshots = false;
    @SerialEntry
    public boolean updateWorldIcon = false;
    @SerialEntry
    public List<String> blacklistedAddresses = List.of("play.wynncraft.com");
    @SerialEntry
    public boolean saveScreenshotsByUsername = false;
    @SerialEntry
    public DisplayMode defaultServerMode = DisplayMode.DISABLED;

    private static SeamlessLoadingScreenConfig getDefaults() {
        return (SeamlessLoadingScreenConfig)CONFIG_CLASS_HANDLER.defaults();
    }

    public static SeamlessLoadingScreenConfig get() {
        return (SeamlessLoadingScreenConfig)CONFIG_CLASS_HANDLER.instance();
    }

    public static void load() {
        CONFIG_CLASS_HANDLER.load();
        if (colorAdapter.errored()) {
            CONFIG_CLASS_HANDLER.save();
        }
    }

    public static void save() {
        CONFIG_CLASS_HANDLER.save();
    }

    private static class_2561 getName(String id) {
        return class_2561.method_43471((String)("seamless_loading_screen.config." + id));
    }

    private static class_2561 getDesc(String id) {
        return class_2561.method_43471((String)("seamless_loading_screen.config." + id + ".description"));
    }

    private static class_2960 getImg(String id) {
        return new class_2960("seamless_loading_screen", "textures/config/" + id + ".webp");
    }

    public static YetAnotherConfigLib getInstance() {
        return YetAnotherConfigLib.create(CONFIG_CLASS_HANDLER, (defaults, config, builder) -> {
            Option timeOpt = Option.createBuilder().name(SeamlessLoadingScreenConfig.getName("time")).description(OptionDescription.createBuilder().text(new class_2561[]{SeamlessLoadingScreenConfig.getDesc("time")}).build()).binding((Object)defaults.time, () -> config.time, val -> {
                config.time = val;
            }).controller(opt -> IntegerFieldControllerBuilder.create((Option)opt).min((Number)0)).build();
            Option fadeOpt = Option.createBuilder().name(SeamlessLoadingScreenConfig.getName("fade")).description(OptionDescription.createBuilder().text(new class_2561[]{SeamlessLoadingScreenConfig.getDesc("fade")}).build()).binding((Object)defaults.fade, () -> config.fade, val -> {
                config.fade = val;
            }).controller(opt -> IntegerFieldControllerBuilder.create((Option)opt).min((Number)0)).build();
            Option defaultServerModeOpt = Option.createBuilder().name(SeamlessLoadingScreenConfig.getName("serverDisplayMode")).description(OptionDescription.createBuilder().text(new class_2561[]{SeamlessLoadingScreenConfig.getDesc("serverDisplayMode")}).build()).binding((Object)defaults.defaultServerMode, () -> config.defaultServerMode, val -> {
                config.defaultServerMode = val;
            }).controller(opt -> EnumControllerBuilder.create((Option)opt).enumClass(DisplayMode.class).valueFormatter(val -> class_2561.method_43471((String)("seamless_loading_screen.config.displayMode." + val.name().toLowerCase())))).build();
            Option disableCameraOpt = Option.createBuilder().name(SeamlessLoadingScreenConfig.getName("disableCamera")).description(OptionDescription.createBuilder().text(new class_2561[]{SeamlessLoadingScreenConfig.getDesc("disableCamera")}).build()).binding((Object)defaults.disableCamera, () -> config.disableCamera, val -> {
                config.disableCamera = val;
            }).controller(opt -> BooleanControllerBuilder.create((Option)opt).trueFalseFormatter()).build();
            Option soundOpt = Option.createBuilder().name(SeamlessLoadingScreenConfig.getName("soundEffect")).description(OptionDescription.createBuilder().text(new class_2561[]{SeamlessLoadingScreenConfig.getDesc("soundEffect")}).build()).binding((Object)defaults.soundEffect, () -> config.soundEffect, val -> {
                config.soundEffect = val;
            }).controller(StringControllerBuilder::create).build();
            Option soundPitchOpt = Option.createBuilder().name(SeamlessLoadingScreenConfig.getName("soundPitch")).description(OptionDescription.createBuilder().text(new class_2561[]{SeamlessLoadingScreenConfig.getDesc("soundPitch")}).build()).binding((Object)Float.valueOf(defaults.soundPitch), () -> Float.valueOf(config.soundPitch), val -> {
                config.soundPitch = val.floatValue();
            }).controller(opt -> ((FloatFieldControllerBuilder)FloatFieldControllerBuilder.create((Option)opt).min((Number)Float.valueOf(0.0f))).max((Number)Float.valueOf(10.0f))).build();
            Option soundVolumeOpt = Option.createBuilder().name(SeamlessLoadingScreenConfig.getName("soundVolume")).description(OptionDescription.createBuilder().text(new class_2561[]{SeamlessLoadingScreenConfig.getDesc("soundVolume")}).build()).binding((Object)Float.valueOf(defaults.soundVolume), () -> Float.valueOf(config.soundVolume), val -> {
                config.soundVolume = val.floatValue();
            }).controller(opt -> ((FloatFieldControllerBuilder)FloatFieldControllerBuilder.create((Option)opt).min((Number)Float.valueOf(0.0f))).max((Number)Float.valueOf(10.0f))).build();
            Option playSoundEffectOpt = Option.createBuilder().name(SeamlessLoadingScreenConfig.getName("playSoundEffect")).description(OptionDescription.createBuilder().text(new class_2561[]{SeamlessLoadingScreenConfig.getDesc("playSoundEffect")}).build()).binding((Object)defaults.playSoundEffect, () -> config.playSoundEffect, val -> {
                config.playSoundEffect = val;
            }).listener((opt, val) -> {
                soundPitchOpt.setAvailable(val.booleanValue());
                soundVolumeOpt.setAvailable(val.booleanValue());
            }).controller(opt -> BooleanControllerBuilder.create((Option)opt).yesNoFormatter()).build();
            Option screenshotBlurStrengthOpt = Option.createBuilder().name(SeamlessLoadingScreenConfig.getName("screenshotBlurStrength")).description(OptionDescription.createBuilder().text(new class_2561[]{SeamlessLoadingScreenConfig.getDesc("screenshotBlurStrength")}).build()).binding((Object)Float.valueOf(defaults.screenshotBlurStrength), () -> Float.valueOf(config.screenshotBlurStrength), val -> {
                config.screenshotBlurStrength = val.floatValue();
            }).controller(opt -> ((FloatSliderControllerBuilder)FloatSliderControllerBuilder.create((Option)opt).range((Number)Float.valueOf(1.0f), (Number)Float.valueOf(16.0f))).step((Number)Float.valueOf(0.1f))).build();
            Option screenshotBlurQualityOpt = Option.createBuilder().name(SeamlessLoadingScreenConfig.getName("screenshotBlurQuality")).description(OptionDescription.createBuilder().text(new class_2561[]{SeamlessLoadingScreenConfig.getDesc("screenshotBlurQuality")}).build()).binding((Object)Float.valueOf(defaults.screenshotBlurQuality), () -> Float.valueOf(config.screenshotBlurQuality), val -> {
                config.screenshotBlurQuality = val.floatValue();
            }).controller(opt -> ((FloatSliderControllerBuilder)FloatSliderControllerBuilder.create((Option)opt).range((Number)Float.valueOf(1.0f), (Number)Float.valueOf(16.0f))).step((Number)Float.valueOf(0.1f))).build();
            Option enableScreenshotBlurOpt = Option.createBuilder().name(SeamlessLoadingScreenConfig.getName("enableScreenshotBlur")).description(OptionDescription.createBuilder().text(new class_2561[]{SeamlessLoadingScreenConfig.getDesc("enableScreenshotBlur")}).build()).binding((Object)defaults.enableScreenshotBlur, () -> config.enableScreenshotBlur, val -> {
                config.enableScreenshotBlur = val;
            }).listener((opt, val) -> {
                screenshotBlurQualityOpt.setAvailable(val.booleanValue());
                screenshotBlurStrengthOpt.setAvailable(val.booleanValue());
            }).controller(opt -> BooleanControllerBuilder.create((Option)opt).yesNoFormatter()).build();
            Option tintColorOpt = Option.createBuilder().name(SeamlessLoadingScreenConfig.getName("tintColor")).description(OptionDescription.createBuilder().text(new class_2561[]{SeamlessLoadingScreenConfig.getDesc("tintColor")}).build()).binding((Object)defaults.tintColor, () -> config.tintColor, val -> {
                config.tintColor = val;
            }).controller(opt -> ColorControllerBuilder.create((Option)opt).allowAlpha(false)).build();
            Option tintStrengthOpt = Option.createBuilder().name(SeamlessLoadingScreenConfig.getName("tintStrength")).description(OptionDescription.createBuilder().text(new class_2561[]{SeamlessLoadingScreenConfig.getDesc("tintStrength")}).build()).binding((Object)Float.valueOf(defaults.tintStrength), () -> Float.valueOf(config.tintStrength), val -> {
                config.tintStrength = val.floatValue();
            }).controller(opt -> ((FloatSliderControllerBuilder)FloatSliderControllerBuilder.create((Option)opt).range((Number)Float.valueOf(0.0f), (Number)Float.valueOf(1.0f))).step((Number)Float.valueOf(0.05f))).build();
            Option archiveScreenshotsOpt = Option.createBuilder().name(SeamlessLoadingScreenConfig.getName("archiveScreenshots")).description(OptionDescription.createBuilder().text(new class_2561[]{SeamlessLoadingScreenConfig.getDesc("archiveScreenshots")}).build()).binding((Object)defaults.archiveScreenshots, () -> config.archiveScreenshots, val -> {
                config.archiveScreenshots = val;
            }).controller(BooleanControllerBuilder::create).build();
            Option resolutionOpt = Option.createBuilder().name(SeamlessLoadingScreenConfig.getName("resolution")).description(OptionDescription.createBuilder().text(new class_2561[]{SeamlessLoadingScreenConfig.getDesc("resolution")}).build()).binding((Object)defaults.resolution, () -> config.resolution, val -> {
                config.resolution = val;
            }).controller(opt -> EnumControllerBuilder.create((Option)opt).enumClass(ScreenshotResolution.class).valueFormatter(val -> class_2561.method_43471((String)("seamless_loading_screen.config.resolution." + val.name().toLowerCase())))).build();
            Option updateWorldIconOpt = Option.createBuilder().name(SeamlessLoadingScreenConfig.getName("updateWorldIcon")).description(OptionDescription.createBuilder().text(new class_2561[]{SeamlessLoadingScreenConfig.getDesc("updateWorldIcon")}).build()).binding((Object)defaults.updateWorldIcon, () -> config.updateWorldIcon, val -> {
                config.updateWorldIcon = val;
            }).controller(opt -> BooleanControllerBuilder.create((Option)opt).yesNoFormatter()).build();
            ListOption blacklistedAddressOpt = ListOption.createBuilder().name(SeamlessLoadingScreenConfig.getName("blacklistedAddresses")).description(OptionDescription.createBuilder().text(new class_2561[]{SeamlessLoadingScreenConfig.getDesc("blacklistedAddresses")}).build()).binding(defaults.blacklistedAddresses, () -> config.blacklistedAddresses, val -> {
                config.blacklistedAddresses = val;
            }).controller(StringControllerBuilder::create).initial((Object)"").build();
            Option saveScreenshotsByUsernameOpt = Option.createBuilder().name(SeamlessLoadingScreenConfig.getName("saveScreenshotsByUser")).description(OptionDescription.createBuilder().text(new class_2561[]{SeamlessLoadingScreenConfig.getDesc("saveScreenshotsByUser")}).build()).binding((Object)defaults.saveScreenshotsByUsername, () -> config.saveScreenshotsByUsername, val -> {
                config.saveScreenshotsByUsername = val;
            }).controller(opt -> BooleanControllerBuilder.create((Option)opt).yesNoFormatter()).build();
            return builder.title(SeamlessLoadingScreenConfig.getName("title")).category(ConfigCategory.createBuilder().name(SeamlessLoadingScreenConfig.getName("display")).tooltip(new class_2561[]{SeamlessLoadingScreenConfig.getDesc("display")}).options(List.of(timeOpt, fadeOpt, disableCameraOpt)).group(OptionGroup.createBuilder().name(SeamlessLoadingScreenConfig.getName("soundEffects")).options(List.of(playSoundEffectOpt, soundOpt, soundVolumeOpt, soundPitchOpt)).build()).group(OptionGroup.createBuilder().name(SeamlessLoadingScreenConfig.getName("screenshotBlur")).options(List.of(enableScreenshotBlurOpt, screenshotBlurQualityOpt, screenshotBlurStrengthOpt)).build()).group(OptionGroup.createBuilder().name(SeamlessLoadingScreenConfig.getName("tint")).options(List.of(tintColorOpt, tintStrengthOpt)).build()).build()).category(ConfigCategory.createBuilder().name(SeamlessLoadingScreenConfig.getName("capturing")).tooltip(new class_2561[]{SeamlessLoadingScreenConfig.getDesc("capturing")}).options(List.of(saveScreenshotsByUsernameOpt, archiveScreenshotsOpt, resolutionOpt, updateWorldIconOpt)).build()).category(ConfigCategory.createBuilder().name(SeamlessLoadingScreenConfig.getName("server_settings")).tooltip(new class_2561[]{SeamlessLoadingScreenConfig.getDesc("server_settings")}).options(List.of(defaultServerModeOpt)).group((OptionGroup)blacklistedAddressOpt).build());
        });
    }

    public static enum ScreenshotResolution {
        Native(0, 0),
        Normal(4000, 1600),
        r4K(4000, 2160),
        r8K(7900, 4320);

        public int width;
        public int height;

        private ScreenshotResolution(int width_in, int height_in) {
            this.width = width_in;
            this.height = height_in;
        }
    }
}

