/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.exordium.util;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.tr7zw.exordium.ExordiumModBase;
import dev.tr7zw.exordium.util.BlendSateHolder;
import dev.tr7zw.exordium.util.BufferedComponent;
import dev.tr7zw.exordium.util.CustomShaderManager;
import dev.tr7zw.exordium.util.Model;
import dev.tr7zw.exordium.util.NametagScreenBuffer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_8251;
import org.joml.Matrix4f;

public class DelayedRenderCallManager {
    private List<Runnable> renderCalls = new ArrayList<Runnable>();
    private List<Runnable> nametagRenderCalls = new ArrayList<Runnable>();
    private List<BufferedComponent> componentRenderCalls = new ArrayList<BufferedComponent>();
    private Matrix4f usedProjectionMatrix = new Matrix4f();
    private final int maxTexturesPerDraw = 8;
    private BlendSateHolder blendSateHolder = new BlendSateHolder();

    public void setProjectionMatrix(Matrix4f mat) {
        this.usedProjectionMatrix = mat;
    }

    public void addRenderCall(Runnable run) {
        this.renderCalls.add(run);
    }

    public void addNametagRenderCall(Runnable run) {
        this.nametagRenderCalls.add(run);
    }

    public void addBufferedComponent(BufferedComponent component) {
        this.componentRenderCalls.add(component);
    }

    public void execRenderCalls() {
        for (Runnable run : this.renderCalls) {
            run.run();
        }
        this.renderCalls.clear();
        if (!this.nametagRenderCalls.isEmpty()) {
            Matrix4f backupProjectionMatrix = RenderSystem.getProjectionMatrix();
            NametagScreenBuffer buffer = ExordiumModBase.instance.getNameTagScreenBuffer();
            buffer.bind();
            RenderSystem.setProjectionMatrix((Matrix4f)this.usedProjectionMatrix, (class_8251)RenderSystem.getVertexSorting());
            for (Runnable run : this.nametagRenderCalls) {
                run.run();
            }
            buffer.bindEnd();
            this.nametagRenderCalls.clear();
            RenderSystem.setProjectionMatrix((Matrix4f)backupProjectionMatrix, (class_8251)RenderSystem.getVertexSorting());
        }
    }

    public void renderComponents() {
        this.blendSateHolder.fetch();
        CustomShaderManager shaderManager = ExordiumModBase.instance.getCustomShaderManager();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShader(() -> shaderManager.getPositionMultiTexShader());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Model model = BufferedComponent.getModel();
        int textureId = 0;
        for (BufferedComponent component : this.componentRenderCalls) {
            RenderSystem.setShaderTexture((int)textureId, (int)component.getTextureId());
            if (++textureId != 8) continue;
            shaderManager.getPositionMultiTexTextureCountUniform().method_35649(8);
            model.draw(RenderSystem.getModelViewMatrix());
            textureId = 0;
        }
        if (textureId > 0) {
            shaderManager.getPositionMultiTexTextureCountUniform().method_35649(textureId);
            model.draw(RenderSystem.getModelViewMatrix());
        }
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.blendSateHolder.apply();
        this.componentRenderCalls.clear();
    }
}

