/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.client.gui.widget;

import java.util.Optional;
import me.roundaround.armorstands.network.EulerAngleParameter;
import me.roundaround.armorstands.network.PosePart;
import me.roundaround.armorstands.network.packet.c2s.AdjustPosePacket;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_1531;
import net.minecraft.class_2561;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_357;
import net.minecraft.class_6880;

public class AdjustPoseSliderWidget
extends class_357 {
    private final class_1531 armorStand;
    private PosePart part;
    private EulerAngleParameter parameter;
    private Optional<Float> lastAngle = Optional.empty();
    private int min = -180;
    private int max = 180;
    private Optional<Long> lastScroll = Optional.empty();

    public AdjustPoseSliderWidget(int x, int y, int width, int height, PosePart part, EulerAngleParameter parameter, class_1531 armorStand) {
        super(x, y, width, height, (class_2561)class_2561.method_43473(), 0.0);
        this.part = part;
        this.parameter = parameter;
        this.armorStand = armorStand;
        this.refresh();
    }

    public void setPart(PosePart part) {
        this.part = part;
        this.refresh();
    }

    public void setParameter(EulerAngleParameter parameter) {
        this.parameter = parameter;
        this.refresh();
    }

    public void setRange(int min, int max) {
        this.min = min;
        this.max = max;
        this.refresh();
    }

    public void refresh() {
        float armorStandAngle = this.parameter.get(this.part.get(this.armorStand));
        if (this.lastAngle.isPresent() && Math.abs(armorStandAngle - this.lastAngle.get().floatValue()) < 1.0E-5f) {
            return;
        }
        this.lastAngle = Optional.of(Float.valueOf(armorStandAngle));
        this.setAngle(armorStandAngle);
    }

    public void zero() {
        this.setAngle(0.0f);
        this.persistValue();
    }

    public void increment() {
        double up = Math.ceil(this.getAngle());
        if (up - (double)this.getAngle() < (double)1.0E-5f) {
            up += 1.0;
        }
        this.setAngle((float)up);
        this.persistValue();
    }

    public void decrement() {
        double down = Math.floor(this.getAngle());
        if ((double)this.getAngle() - down < (double)1.0E-5f) {
            down -= 1.0;
        }
        this.setAngle((float)down);
        this.persistValue();
    }

    public void tick() {
        this.lastScroll.ifPresent(lastScroll -> {
            if (System.currentTimeMillis() - lastScroll > 500L) {
                this.lastScroll = Optional.empty();
                this.persistValue();
            }
        });
    }

    protected void method_25346() {
        this.method_25355((class_2561)class_2561.method_43469((String)"armorstands.adjustPose.label", (Object[])new Object[]{String.format("%.2f", Float.valueOf(this.getAngle()))}));
    }

    protected void method_25344() {
        this.part.set(this.armorStand, this.parameter, this.getAngle());
    }

    public void method_25357(double mouseX, double mouseY) {
        super.method_25357(mouseX, mouseY);
        this.persistValue();
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.method_25405(mouseX, mouseY)) {
            this.setAngle(this.getAngle() + (float)verticalAmount);
            this.method_25344();
            this.lastScroll = Optional.of(System.currentTimeMillis());
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 263) {
            this.decrement();
            return true;
        }
        if (keyCode == 262) {
            this.increment();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void method_25354(class_1144 soundManager) {
        soundManager.method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
    }

    private float getAngle() {
        return AdjustPoseSliderWidget.valueToAngle(this.field_22753, this.min, this.max);
    }

    private void setAngle(float value) {
        this.setValue(AdjustPoseSliderWidget.angleToValue(value, this.min, this.max));
    }

    private void setValue(double value) {
        this.field_22753 = class_3532.method_15350((double)value, (double)0.0, (double)1.0);
        this.method_25346();
    }

    private static double angleToValue(float value, int min, int max) {
        return (value - (float)min) / (float)(max - min);
    }

    private static float valueToAngle(double value, int min, int max) {
        return (float)(value * (double)(max - min) + (double)min);
    }

    private void persistValue() {
        this.lastScroll = Optional.empty();
        AdjustPosePacket.sendToServer(this.part, this.parameter, this.getAngle());
    }
}

