/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.network;

import java.util.Arrays;
import java.util.List;
import me.roundaround.armorstands.ArmorStandsMod;
import me.roundaround.armorstands.mixin.ArmorStandEntityAccessor;
import me.roundaround.armorstands.util.actions.MoveAction;
import net.minecraft.class_1531;
import net.minecraft.class_243;
import net.minecraft.class_2561;

public enum ArmorStandFlag {
    HIDE_BASE_PLATE("base", true),
    SHOW_ARMS("arms", false),
    SMALL("small", false),
    NO_GRAVITY("gravity", true),
    INVISIBLE("visible", false),
    NAME("name", false),
    INVULNERABLE("invulnerable", false),
    LOCK_INVENTORY("inventory", false),
    UNKNOWN("unknown", false);

    private static final int ALL_SLOTS_DISABLED = 0x3F3F3F;
    private final String id;
    private final boolean invertControl;

    private ArmorStandFlag(String id, boolean invertControl) {
        this.id = id;
        this.invertControl = invertControl;
    }

    public String toString() {
        return this.id;
    }

    public class_2561 getDisplayName() {
        return class_2561.method_43471((String)("armorstands.flags." + this.id));
    }

    public boolean invertControl() {
        return this.invertControl;
    }

    public boolean getValue(class_1531 armorStand) {
        ArmorStandEntityAccessor accessor = (ArmorStandEntityAccessor)armorStand;
        switch (this) {
            case HIDE_BASE_PLATE: {
                return armorStand.method_6901();
            }
            case SHOW_ARMS: {
                return armorStand.method_6929();
            }
            case SMALL: {
                return armorStand.method_6914();
            }
            case NO_GRAVITY: {
                return armorStand.method_5740();
            }
            case INVISIBLE: {
                return armorStand.method_5767();
            }
            case NAME: {
                return armorStand.method_5807();
            }
            case INVULNERABLE: {
                return armorStand.method_5655();
            }
            case LOCK_INVENTORY: {
                return accessor.getDisabledSlots() == 0x3F3F3F;
            }
        }
        return false;
    }

    public void setValue(class_1531 armorStand, boolean value) {
        ArmorStandEntityAccessor accessor = (ArmorStandEntityAccessor)armorStand;
        switch (this) {
            case HIDE_BASE_PLATE: {
                accessor.invokeSetHideBasePlate(value);
                break;
            }
            case SHOW_ARMS: {
                accessor.invokeSetShowArms(value);
                break;
            }
            case SMALL: {
                accessor.invokeSetSmall(value);
                break;
            }
            case NO_GRAVITY: {
                if (!value) {
                    boolean atBlockPos;
                    class_243 pos = armorStand.method_19538();
                    double blockY = armorStand.method_31478();
                    boolean bl = atBlockPos = Math.abs(pos.field_1351 - blockY) < (double)1.0E-5f;
                    if (atBlockPos) {
                        MoveAction.setPosition(armorStand, pos.field_1352, pos.field_1351 + 0.001, pos.field_1350);
                    }
                }
                armorStand.method_5875(value);
                break;
            }
            case INVISIBLE: {
                armorStand.method_5648(value);
                break;
            }
            case NAME: {
                armorStand.method_5880(value);
                break;
            }
            case INVULNERABLE: {
                armorStand.method_5684(value);
                break;
            }
            case LOCK_INVENTORY: {
                accessor.setDisabledSlots(value ? 0x3F3F3F : 0);
                break;
            }
            default: {
                ArmorStandsMod.LOGGER.warn("Tried to set value to flag {}. Ignoring.", (Object)this.name());
            }
        }
    }

    public static ArmorStandFlag fromString(String value) {
        return Arrays.stream(ArmorStandFlag.values()).filter(flag -> flag.id.equals(value)).findFirst().orElseGet(() -> {
            ArmorStandsMod.LOGGER.warn("Unknown flag id '{}'. Returning UNKNOWN.", (Object)value);
            return UNKNOWN;
        });
    }

    public static List<ArmorStandFlag> getFlags() {
        return Arrays.asList(ArmorStandFlag.values()).stream().filter(flag -> flag != UNKNOWN).toList();
    }
}

