/*
 * Decompiled with CFR 0.152.
 */
package com.goby56.wakes.config;

import com.goby56.wakes.WakesClient;
import com.goby56.wakes.config.WakesConfig;
import com.goby56.wakes.config.enums.EffectSpawningRule;
import com.goby56.wakes.config.enums.Resolution;
import com.goby56.wakes.render.enums.RenderType;
import com.goby56.wakes.render.enums.WakeColor;
import com.goby56.wakes.simulation.WakeHandler;
import com.goby56.wakes.simulation.WakeNode;
import com.goby56.wakes.utils.WakesUtils;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import dev.isxander.yacl3.api.controller.EnumControllerBuilder;
import dev.isxander.yacl3.api.controller.FloatSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.IntegerSliderControllerBuilder;
import net.minecraft.class_2561;
import net.minecraft.class_437;

public class YACLIntegration {
    public static class_437 createScreen(class_437 parent) {
        WakesConfig config = WakesClient.CONFIG_INSTANCE;
        return YetAnotherConfigLib.createBuilder().title((class_2561)WakesUtils.translatable("config", "title")).category(YACLIntegration.configCategory("basic").group(YACLIntegration.group("wake_appearance").option(YACLIntegration.booleanOption("first_person_splash_plane", true).binding((Object)false, () -> config.firstPersonSplashPlane, val -> {
            config.firstPersonSplashPlane = val;
        }).build()).option(YACLIntegration.optionOf(Resolution.class, "wake_resolution", true).binding((Object)Resolution.SIXTEEN, () -> config.wakeResolution, WakeHandler::scheduleResolutionChange).controller(opt -> EnumControllerBuilder.create((Option)opt).enumClass(Resolution.class).formatValue(val -> class_2561.method_30163((String)val.toString()))).build()).option(YACLIntegration.optionOf(Integer.class, "wake_opacity", false).binding((Object)100, () -> (int)(config.wakeOpacity * 100.0f), val -> {
            config.wakeOpacity = (float)val.intValue() / 100.0f;
        }).controller(opt -> YACLIntegration.integerSlider((Option<Integer>)opt, 0, 100)).build()).build()).group(YACLIntegration.group("effect_spawning").option(YACLIntegration.effectSpawningRuleOption("boat")).option(YACLIntegration.effectSpawningRuleOption("player")).option(YACLIntegration.effectSpawningRuleOption("other_players")).option(YACLIntegration.effectSpawningRuleOption("mobs")).option(YACLIntegration.effectSpawningRuleOption("items")).option(YACLIntegration.booleanOption("wakes_in_running_water", false).binding((Object)false, () -> config.wakesInRunningWater, val -> {
            config.wakesInRunningWater = val;
        }).build()).option(YACLIntegration.booleanOption("spawn_particles", false).binding((Object)true, () -> config.spawnParticles, val -> {
            config.spawnParticles = val;
        }).build()).build()).build()).category(YACLIntegration.configCategory("advanced").group(YACLIntegration.group("wake_behaviour").option(YACLIntegration.optionOf(Float.class, "wave_propagation_factor", true).binding((Object)Float.valueOf(0.95f), () -> Float.valueOf(config.wavePropagationFactor), val -> {
            config.wavePropagationFactor = val.floatValue();
            WakeNode.calculateWaveDevelopmentFactors();
        }).controller(opt -> YACLIntegration.floatSlider((Option<Float>)opt, 0.0f, 2.0f, 0.01f)).build()).option(YACLIntegration.optionOf(Float.class, "wave_decay_factor", true).binding((Object)Float.valueOf(0.5f), () -> Float.valueOf(config.waveDecayFactor), val -> {
            config.waveDecayFactor = val.floatValue();
        }).controller(opt -> YACLIntegration.floatSlider((Option<Float>)opt, 0.0f, 1.0f, 0.01f)).build()).build()).group(YACLIntegration.group("splash_plane").option(YACLIntegration.optionOf(Float.class, "splash_plane.cap_velocity", true).binding((Object)Float.valueOf(0.5f), () -> Float.valueOf(config.maxSplashPlaneVelocity), val -> {
            config.maxSplashPlaneVelocity = val.floatValue();
        }).controller(opt -> YACLIntegration.floatSlider((Option<Float>)opt, 0.1f, 2.0f, 0.1f)).build()).option(YACLIntegration.optionOf(Float.class, "splash_plane.scale", false).binding((Object)Float.valueOf(1.0f), () -> Float.valueOf(config.splashPlaneScale), val -> {
            config.splashPlaneScale = val.floatValue();
        }).controller(opt -> YACLIntegration.floatSlider((Option<Float>)opt, 0.1f, 2.0f, 0.1f)).build()).option(YACLIntegration.optionOf(Float.class, "splash_plane.offset", false).binding((Object)Float.valueOf(0.0f), () -> Float.valueOf(config.splashPlaneOffset), val -> {
            config.splashPlaneOffset = val.floatValue();
        }).controller(opt -> YACLIntegration.floatSlider((Option<Float>)opt, -1.0f, 1.0f, 0.1f)).build()).option(YACLIntegration.optionOf(Float.class, "splash_plane.width", false).binding((Object)Float.valueOf(3.0f), () -> Float.valueOf(config.splashPlaneWidth), val -> {
            config.splashPlaneWidth = val.floatValue();
        }).controller(opt -> YACLIntegration.floatSlider((Option<Float>)opt, 0.0f, 10.0f, 0.1f)).build()).option(YACLIntegration.optionOf(Float.class, "splash_plane.height", false).binding((Object)Float.valueOf(1.5f), () -> Float.valueOf(config.splashPlaneHeight), val -> {
            config.splashPlaneHeight = val.floatValue();
        }).controller(opt -> YACLIntegration.floatSlider((Option<Float>)opt, 0.0f, 10.0f, 0.1f)).build()).option(YACLIntegration.optionOf(Float.class, "splash_plane.depth", false).binding((Object)Float.valueOf(2.0f), () -> Float.valueOf(config.splashPlaneDepth), val -> {
            config.splashPlaneDepth = val.floatValue();
        }).controller(opt -> YACLIntegration.floatSlider((Option<Float>)opt, 0.0f, 10.0f, 0.1f)).build()).build()).group(YACLIntegration.group("initial_wave_strengths").description(YACLIntegration.description("initial_wave_strengths").build()).option(YACLIntegration.optionOf(Integer.class, "initial_wave_strength.wake", false).binding((Object)20, () -> config.initialStrength, val -> {
            config.initialStrength = val;
        }).controller(opt -> YACLIntegration.integerSlider((Option<Integer>)opt, 0, 150)).build()).option(YACLIntegration.optionOf(Integer.class, "initial_wave_strength.paddle", false).binding((Object)100, () -> config.paddleStrength, val -> {
            config.paddleStrength = val;
        }).controller(opt -> YACLIntegration.integerSlider((Option<Integer>)opt, 0, 150)).build()).option(YACLIntegration.optionOf(Integer.class, "initial_wave_strength.splash", false).binding((Object)100, () -> config.splashStrength, val -> {
            config.splashStrength = val;
        }).controller(opt -> YACLIntegration.integerSlider((Option<Integer>)opt, 0, 150)).build()).build()).build()).category(YACLIntegration.configCategory("debug").option(YACLIntegration.optionOf(RenderType.class, "render_type", false).binding((Object)RenderType.AUTO, () -> config.renderType, val -> {
            config.renderType = val;
        }).controller(opt -> EnumControllerBuilder.create((Option)opt).enumClass(RenderType.class)).build()).option(YACLIntegration.optionOf(Integer.class, "flood_fill_distance", false).binding((Object)3, () -> config.floodFillDistance, val -> {
            config.floodFillDistance = val;
        }).controller(opt -> YACLIntegration.integerSlider((Option<Integer>)opt, 1, 5)).build()).option(YACLIntegration.optionOf(Integer.class, "ticks_before_fill", false).binding((Object)2, () -> config.ticksBeforeFill, val -> {
            config.ticksBeforeFill = val;
        }).controller(opt -> YACLIntegration.integerSlider((Option<Integer>)opt, 1, 5)).build()).option(YACLIntegration.booleanOption("draw_debug_boxes", false).binding((Object)false, () -> config.drawDebugBoxes, val -> {
            config.drawDebugBoxes = val;
        }).build()).option(YACLIntegration.booleanOption("disable_mod", false).binding((Object)false, () -> config.disableMod, val -> {
            config.disableMod = val;
        }).build()).group(YACLIntegration.intervalGroup(0, WakeColor.TRANSPARENT, -50, -45)).group(YACLIntegration.intervalGroup(1, WakeColor.DARK_GRAY, -45, -35)).group(YACLIntegration.intervalGroup(2, WakeColor.GRAY, -35, -30)).group(YACLIntegration.intervalGroup(3, WakeColor.LIGHT_GRAY, -30, -15)).group(YACLIntegration.intervalGroup(4, WakeColor.TRANSPARENT, -15, 2)).group(YACLIntegration.intervalGroup(5, WakeColor.LIGHT_GRAY, 2, 10)).group(YACLIntegration.intervalGroup(6, WakeColor.WHITE, 10, 20)).group(YACLIntegration.intervalGroup(7, WakeColor.LIGHT_GRAY, 20, 40)).group(YACLIntegration.intervalGroup(8, WakeColor.GRAY, 40, 50)).build()).save(config::saveConfig).build().generateScreen(parent);
    }

    private static OptionDescription.Builder description(String name) {
        return OptionDescription.createBuilder().text(new class_2561[]{WakesUtils.translatable("config.description", name)});
    }

    private static OptionDescription.Builder description(String parent, String[] names) {
        OptionDescription.Builder desc = OptionDescription.createBuilder();
        for (String name : names) {
            desc.text(new class_2561[]{WakesUtils.translatable("config.description", String.format("%s.%s", parent, name))});
        }
        return desc;
    }

    private static ConfigCategory.Builder configCategory(String name) {
        return ConfigCategory.createBuilder().name((class_2561)WakesUtils.translatable("config.category", name));
    }

    private static OptionGroup.Builder group(String name) {
        return OptionGroup.createBuilder().name((class_2561)WakesUtils.translatable("config.group", name));
    }

    private static <T> Option.Builder<T> optionOf(Class<T> optionType, String name, boolean desc) {
        Option.Builder opt = Option.createBuilder();
        if (desc) {
            opt.description(YACLIntegration.description(name).build());
        }
        return opt.name((class_2561)WakesUtils.translatable("config.option", name));
    }

    private static IntegerSliderControllerBuilder integerSlider(Option<Integer> option, int min, int max) {
        return (IntegerSliderControllerBuilder)((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create(option).range((Number)min, (Number)max)).step((Number)1);
    }

    private static FloatSliderControllerBuilder floatSlider(Option<Float> option, float min, float max, float step) {
        return (FloatSliderControllerBuilder)((FloatSliderControllerBuilder)FloatSliderControllerBuilder.create(option).range((Number)Float.valueOf(min), (Number)Float.valueOf(max))).step((Number)Float.valueOf(step));
    }

    private static Option.Builder<Boolean> booleanOption(String name, boolean desc) {
        Option.Builder opt = Option.createBuilder().controller(BooleanControllerBuilder::create);
        if (desc) {
            opt.description(YACLIntegration.description(name).build());
        }
        return opt.name((class_2561)WakesUtils.translatable("config.option", name));
    }

    private static Option<EffectSpawningRule> effectSpawningRuleOption(String name) {
        WakesConfig config = WakesClient.CONFIG_INSTANCE;
        return Option.createBuilder().name((class_2561)WakesUtils.translatable("config.option.effect_spawning_rules.source", name)).description(YACLIntegration.description("effect_spawning_rules").build()).binding((Object)EffectSpawningRule.SIMULATION_AND_PLANES, () -> config.effectSpawningRules.get(name), val -> config.effectSpawningRules.put(name, (EffectSpawningRule)((Object)val))).controller(opt -> EnumControllerBuilder.create((Option)opt).enumClass(EffectSpawningRule.class).formatValue(val -> WakesUtils.translatable("config.option.effect_spawning_rules.effect", val.toString().toLowerCase()))).build();
    }

    private static OptionGroup intervalGroup(int n, WakeColor defaultColor, int defaultLower, int defaultUpper) {
        WakesConfig config = WakesClient.CONFIG_INSTANCE;
        return OptionGroup.createBuilder().name(class_2561.method_30163((String)String.valueOf(n + 1))).option(YACLIntegration.optionOf(Integer.class, "interval.lower", false).binding((Object)defaultLower, () -> config.colorIntervals.get((int)n).lower, config.colorIntervals.get(n)::setLower).controller(opt -> YACLIntegration.integerSlider((Option<Integer>)opt, -50, 50)).build()).option(YACLIntegration.optionOf(Integer.class, "interval.upper", false).binding((Object)defaultUpper, () -> config.colorIntervals.get((int)n).upper, config.colorIntervals.get(n)::setUpper).controller(opt -> YACLIntegration.integerSlider((Option<Integer>)opt, -50, 50)).build()).option(YACLIntegration.optionOf(WakeColor.class, "interval.color", false).binding((Object)defaultColor, () -> config.colorIntervals.get((int)n).color, config.colorIntervals.get(n)::setColor).controller(opt -> EnumControllerBuilder.create((Option)opt).enumClass(WakeColor.class)).build()).build();
    }
}

