/*
 * Decompiled with CFR 0.152.
 */
package com.goby56.wakes.render;

import com.goby56.wakes.WakesClient;
import com.goby56.wakes.render.enums.RenderType;
import com.goby56.wakes.render.enums.WakeColor;
import com.goby56.wakes.simulation.WakeNode;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_4608;
import org.joml.Matrix4f;
import org.lwjgl.system.MemoryUtil;

public class DynamicWakeTexture {
    private static DynamicWakeTexture INSTANCE = null;
    private final ArrayList<Texture> lods = new ArrayList();
    private Texture currentTexture = null;

    private DynamicWakeTexture() {
        for (int i = 5; i >= 0; --i) {
            this.lods.add(new Texture((int)Math.pow(2.0, i)));
        }
    }

    public static DynamicWakeTexture getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DynamicWakeTexture();
        }
        return INSTANCE;
    }

    private static int distToLOD(float distance) {
        int pow = WakesClient.CONFIG_INSTANCE.wakeResolution.power;
        return (int)Math.min(5.0, Math.floor((double)pow * (Math.exp(distance / (float)(16 * pow)) - 2.0) + 5.0));
    }

    public void populatePixels(WakeNode node, float distance, int waterColor, float opacity) {
        int lod = DynamicWakeTexture.distToLOD(0.0f);
        Texture texture = this.lods.get(lod);
        int samples = Math.max(1, WakeNode.res / texture.res);
        for (int i = 0; i < texture.res; ++i) {
            for (int j = 0; j < texture.res; ++j) {
                float avg = 0.0f;
                for (int dy = 0; dy < samples; ++dy) {
                    for (int dx = 0; dx < samples; ++dx) {
                        avg = (node.u[0][i + dy + 1][j + dx + 1] + node.u[1][i + dy + 1][j + dx + 1] + node.u[2][i + dy + 1][j + dx + 1]) / 3.0f;
                    }
                }
                int color = WakeColor.getColor(avg / (float)(samples * samples), waterColor, opacity);
                MemoryUtil.memPutInt((long)(texture.imgPtr + ((long)i * (long)texture.res + (long)j) * 4L), (int)color);
            }
        }
        this.currentTexture = texture;
    }

    public void render(Matrix4f matrix, float x, float y, float z, int light) {
        GlStateManager._bindTexture((int)this.currentTexture.glTexId);
        GlStateManager._pixelStore((int)3314, (int)0);
        GlStateManager._pixelStore((int)3316, (int)0);
        GlStateManager._pixelStore((int)3315, (int)0);
        GlStateManager._pixelStore((int)3317, (int)4);
        GlStateManager._texSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)this.currentTexture.res, (int)this.currentTexture.res, (int)6408, (int)5121, (long)this.currentTexture.imgPtr);
        RenderSystem.setShaderTexture((int)0, (int)this.currentTexture.glTexId);
        RenderSystem.setShader(RenderType.getProgram());
        RenderSystem.enableDepthTest();
        class_287 buffer = class_289.method_1348().method_1349();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1580);
        y = class_310.method_29611() ? y - 0.01f : y;
        buffer.method_22918(matrix, x, y, z).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(0.0f, 0.0f).method_22922(class_4608.field_21444).method_22916(light).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        buffer.method_22918(matrix, x, y, z + 1.0f).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(0.0f, 1.0f).method_22922(class_4608.field_21444).method_22916(light).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        buffer.method_22918(matrix, x + 1.0f, y, z + 1.0f).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(1.0f, 1.0f).method_22922(class_4608.field_21444).method_22916(light).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        buffer.method_22918(matrix, x + 1.0f, y, z).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(1.0f, 0.0f).method_22922(class_4608.field_21444).method_22916(light).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        class_289.method_1348().method_1350();
    }

    private static class Texture {
        public int res;
        public int glTexId;
        public long imgPtr;

        public Texture(int resolution) {
            this.res = resolution;
            this.glTexId = TextureUtil.generateTextureId();
            this.imgPtr = MemoryUtil.nmemAlloc((long)((long)resolution * (long)resolution * 4L));
            GlStateManager._bindTexture((int)this.glTexId);
            GlStateManager._texParameter((int)3553, (int)33085, (int)0);
            GlStateManager._texParameter((int)3553, (int)33082, (int)0);
            GlStateManager._texParameter((int)3553, (int)33083, (int)0);
            GlStateManager._texParameter((int)3553, (int)34049, (float)0.0f);
            GlStateManager._texParameter((int)3553, (int)10241, (int)9728);
            GlStateManager._texParameter((int)3553, (int)10240, (int)9728);
            GlStateManager._texImage2D((int)3553, (int)0, (int)6408, (int)resolution, (int)resolution, (int)0, (int)6408, (int)5121, null);
        }
    }
}

