/*
 * Decompiled with CFR 0.152.
 */
package ch.endte.syncmatica.communication.exchange;

import ch.endte.syncmatica.Context;
import ch.endte.syncmatica.ServerPlacement;
import ch.endte.syncmatica.communication.ExchangeTarget;
import ch.endte.syncmatica.communication.MessageType;
import ch.endte.syncmatica.communication.PacketType;
import ch.endte.syncmatica.communication.ServerCommunicationManager;
import ch.endte.syncmatica.communication.exchange.AbstractExchange;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class DownloadExchange
extends AbstractExchange {
    private final ServerPlacement toDownload;
    private final OutputStream outputStream;
    private final MessageDigest md5;
    private final File downloadFile;
    private int bytesSent;

    public DownloadExchange(ServerPlacement syncmatic, File downloadFile, ExchangeTarget partner, Context context) throws IOException, NoSuchAlgorithmException {
        super(partner, context);
        this.downloadFile = downloadFile;
        FileOutputStream os = new FileOutputStream(downloadFile);
        this.toDownload = syncmatic;
        this.md5 = MessageDigest.getInstance("MD5");
        this.outputStream = new DigestOutputStream(os, this.md5);
    }

    @Override
    public boolean checkPacket(class_2960 id, class_2540 packetBuf) {
        if (id.equals((Object)PacketType.SEND_LITEMATIC.identifier) || id.equals((Object)PacketType.FINISHED_LITEMATIC.identifier) || id.equals((Object)PacketType.CANCEL_LITEMATIC.identifier)) {
            return DownloadExchange.checkUUID(packetBuf, this.toDownload.getId());
        }
        return false;
    }

    @Override
    public void handle(class_2960 id, class_2540 packetBuf) {
        packetBuf.method_10790();
        if (id.equals((Object)PacketType.SEND_LITEMATIC.identifier)) {
            int size = packetBuf.readInt();
            this.bytesSent += size;
            if (this.getContext().isServer() && this.getContext().getQuotaService().isOverQuota(this.getPartner(), this.bytesSent).booleanValue()) {
                this.close(true);
                ((ServerCommunicationManager)this.getContext().getCommunicationManager()).sendMessage(this.getPartner(), MessageType.ERROR, "syncmatica.error.cancelled_transmit_exceed_quota");
            }
            try {
                packetBuf.method_52959(this.outputStream, size);
            }
            catch (IOException e) {
                this.close(true);
                e.printStackTrace();
                return;
            }
            class_2540 packetByteBuf = new class_2540(Unpooled.buffer());
            packetByteBuf.method_10797(this.toDownload.getId());
            this.getPartner().sendPacket(PacketType.RECEIVED_LITEMATIC.identifier, packetByteBuf, this.getContext());
            return;
        }
        if (id.equals((Object)PacketType.FINISHED_LITEMATIC.identifier)) {
            try {
                this.outputStream.flush();
            }
            catch (IOException e) {
                this.close(false);
                e.printStackTrace();
                return;
            }
            UUID downloadHash = UUID.nameUUIDFromBytes(this.md5.digest());
            if (downloadHash.equals(this.toDownload.getHash())) {
                this.succeed();
            } else {
                this.close(false);
            }
            return;
        }
        if (id.equals((Object)PacketType.CANCEL_LITEMATIC.identifier)) {
            this.close(false);
        }
    }

    @Override
    public void init() {
        class_2540 packetByteBuf = new class_2540(Unpooled.buffer());
        packetByteBuf.method_10797(this.toDownload.getId());
        this.getPartner().sendPacket(PacketType.REQUEST_LITEMATIC.identifier, packetByteBuf, this.getContext());
    }

    @Override
    protected void onClose() {
        this.getManager().setDownloadState(this.toDownload, false);
        if (this.getContext().isServer() && this.isSuccessful()) {
            this.getContext().getQuotaService().progressQuota(this.getPartner(), this.bytesSent);
        }
        try {
            this.outputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!this.isSuccessful() && this.downloadFile.exists()) {
            this.downloadFile.delete();
        }
    }

    @Override
    protected void sendCancelPacket() {
        class_2540 packetByteBuf = new class_2540(Unpooled.buffer());
        packetByteBuf.method_10797(this.toDownload.getId());
        this.getPartner().sendPacket(PacketType.CANCEL_LITEMATIC.identifier, packetByteBuf, this.getContext());
    }

    public ServerPlacement getPlacement() {
        return this.toDownload;
    }
}

