/*
 * Decompiled with CFR 0.152.
 */
package ch.endte.syncmatica.communication.exchange;

import ch.endte.syncmatica.Context;
import ch.endte.syncmatica.Feature;
import ch.endte.syncmatica.ServerPlacement;
import ch.endte.syncmatica.communication.ExchangeTarget;
import ch.endte.syncmatica.communication.PacketType;
import ch.endte.syncmatica.communication.exchange.AbstractExchange;
import ch.endte.syncmatica.communication.exchange.ShareLitematicExchange;
import ch.endte.syncmatica.litematica.LitematicManager;
import ch.endte.syncmatica.litematica.ScreenHelper;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import fi.dy.masa.malilib.gui.Message;
import io.netty.buffer.Unpooled;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class ModifyExchangeClient
extends AbstractExchange {
    private boolean expectRemove = false;
    private final ServerPlacement placement;
    private final SchematicPlacement litematic;

    public ModifyExchangeClient(ServerPlacement placement, ExchangeTarget partner, Context con) {
        super(partner, con);
        this.placement = placement;
        this.litematic = LitematicManager.getInstance().schematicFromSyncmatic(placement);
    }

    @Override
    public boolean checkPacket(class_2960 id, class_2540 packetBuf) {
        if (id.equals((Object)PacketType.MODIFY_REQUEST_DENY.identifier) || id.equals((Object)PacketType.MODIFY_REQUEST_ACCEPT.identifier) || this.expectRemove && id.equals((Object)PacketType.REMOVE_SYNCMATIC.identifier)) {
            return AbstractExchange.checkUUID(packetBuf, this.placement.getId());
        }
        return false;
    }

    @Override
    public void handle(class_2960 id, class_2540 packetBuf) {
        if (id.equals((Object)PacketType.MODIFY_REQUEST_DENY.identifier)) {
            packetBuf.method_10790();
            this.close(false);
            if (!this.litematic.isLocked()) {
                this.litematic.setOrigin(this.placement.getPosition(), null);
                this.litematic.setRotation(this.placement.getRotation(), null);
                this.litematic.setMirror(this.placement.getMirror(), null);
                this.litematic.toggleLocked();
            }
            ScreenHelper.ifPresent(s -> s.addMessage(Message.MessageType.SUCCESS, "syncmatica.error.modification_deny", new Object[0]));
        } else if (id.equals((Object)PacketType.MODIFY_REQUEST_ACCEPT.identifier)) {
            packetBuf.method_10790();
            this.acceptModification();
        } else if (id.equals((Object)PacketType.REMOVE_SYNCMATIC.identifier)) {
            packetBuf.method_10790();
            ShareLitematicExchange legacyModify = new ShareLitematicExchange(this.litematic, this.getPartner(), this.getContext(), this.placement);
            this.getContext().getCommunicationManager().startExchange(legacyModify);
            this.succeed();
        }
    }

    @Override
    public void init() {
        if (this.getContext().getCommunicationManager().getModifier(this.placement) != null) {
            this.close(false);
            return;
        }
        this.getContext().getCommunicationManager().setModifier(this.placement, this);
        if (this.getPartner().getFeatureSet().hasFeature(Feature.MODIFY)) {
            class_2540 buf = new class_2540(Unpooled.buffer());
            buf.method_10797(this.placement.getId());
            this.getPartner().sendPacket(PacketType.MODIFY_REQUEST.identifier, buf, this.getContext());
        } else {
            this.acceptModification();
        }
    }

    private void acceptModification() {
        if (this.litematic.isLocked()) {
            this.litematic.toggleLocked();
        }
        ScreenHelper.ifPresent(s -> s.addMessage(Message.MessageType.SUCCESS, "syncmatica.success.modification_accepted", new Object[0]));
        this.getContext().getSyncmaticManager().updateServerPlacement(this.placement);
    }

    public void conclude() {
        LitematicManager.getInstance().updateServerPlacement(this.litematic, this.placement);
        this.sendFinish();
        if (!this.litematic.isLocked()) {
            this.litematic.toggleLocked();
        }
        this.getContext().getSyncmaticManager().updateServerPlacement(this.placement);
    }

    private void sendFinish() {
        if (this.getPartner().getFeatureSet().hasFeature(Feature.MODIFY)) {
            class_2540 buf = new class_2540(Unpooled.buffer());
            buf.method_10797(this.placement.getId());
            this.getContext().getCommunicationManager().putPositionData(this.placement, buf, this.getPartner());
            this.getPartner().sendPacket(PacketType.MODIFY_FINISH.identifier, buf, this.getContext());
            this.succeed();
            this.getContext().getCommunicationManager().notifyClose(this);
        } else {
            class_2540 buf = new class_2540(Unpooled.buffer());
            buf.method_10797(this.placement.getId());
            this.getPartner().sendPacket(PacketType.REMOVE_SYNCMATIC.identifier, buf, this.getContext());
            this.expectRemove = true;
        }
    }

    @Override
    protected void sendCancelPacket() {
        if (this.getPartner().getFeatureSet().hasFeature(Feature.MODIFY)) {
            class_2540 buf = new class_2540(Unpooled.buffer());
            buf.method_10797(this.placement.getId());
            this.getContext().getCommunicationManager().putPositionData(this.placement, buf, this.getPartner());
            this.getPartner().sendPacket(PacketType.MODIFY_FINISH.identifier, buf, this.getContext());
        }
    }

    @Override
    protected void onClose() {
        if (this.getContext().getCommunicationManager().getModifier(this.placement) == this) {
            this.getContext().getCommunicationManager().setModifier(this.placement, null);
        }
    }
}

