/*
 * Decompiled with CFR 0.152.
 */
package ch.endte.syncmatica.communication.exchange;

import ch.endte.syncmatica.Context;
import ch.endte.syncmatica.ServerPlacement;
import ch.endte.syncmatica.communication.ExchangeTarget;
import ch.endte.syncmatica.communication.PacketType;
import ch.endte.syncmatica.communication.exchange.AbstractExchange;
import ch.endte.syncmatica.extended_core.PlayerIdentifier;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class ModifyExchangeServer
extends AbstractExchange {
    private final ServerPlacement placement;
    UUID placementId;

    public ModifyExchangeServer(UUID placeId, ExchangeTarget partner, Context con) {
        super(partner, con);
        this.placementId = placeId;
        this.placement = con.getSyncmaticManager().getPlacement(this.placementId);
    }

    @Override
    public boolean checkPacket(class_2960 id, class_2540 packetBuf) {
        return id.equals((Object)PacketType.MODIFY_FINISH.identifier) && ModifyExchangeServer.checkUUID(packetBuf, this.placement.getId());
    }

    @Override
    public void handle(class_2960 id, class_2540 packetBuf) {
        packetBuf.method_10790();
        if (id.equals((Object)PacketType.MODIFY_FINISH.identifier)) {
            this.getContext().getCommunicationManager().receivePositionData(this.placement, packetBuf, this.getPartner());
            PlayerIdentifier identifier = this.getContext().getPlayerIdentifierProvider().createOrGet(this.getPartner());
            this.placement.setLastModifiedBy(identifier);
            this.getContext().getSyncmaticManager().updateServerPlacement(this.placement);
            this.succeed();
        }
    }

    @Override
    public void init() {
        if (this.getPlacement() == null || this.getContext().getCommunicationManager().getModifier(this.placement) != null) {
            this.close(true);
        } else {
            this.accept();
        }
    }

    private void accept() {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10797(this.placement.getId());
        this.getPartner().sendPacket(PacketType.MODIFY_REQUEST_ACCEPT.identifier, buf, this.getContext());
        this.getContext().getCommunicationManager().setModifier(this.placement, this);
    }

    @Override
    protected void sendCancelPacket() {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10797(this.placementId);
        this.getPartner().sendPacket(PacketType.MODIFY_REQUEST_DENY.identifier, buf, this.getContext());
    }

    public ServerPlacement getPlacement() {
        return this.placement;
    }

    @Override
    protected void onClose() {
        if (this.getContext().getCommunicationManager().getModifier(this.placement) == this) {
            this.getContext().getCommunicationManager().setModifier(this.placement, null);
        }
    }
}

