/*
 * Decompiled with CFR 0.152.
 */
package ch.endte.syncmatica.communication.exchange;

import ch.endte.syncmatica.Context;
import ch.endte.syncmatica.RedirectFileStorage;
import ch.endte.syncmatica.ServerPlacement;
import ch.endte.syncmatica.communication.ClientCommunicationManager;
import ch.endte.syncmatica.communication.ExchangeTarget;
import ch.endte.syncmatica.communication.PacketType;
import ch.endte.syncmatica.communication.exchange.AbstractExchange;
import ch.endte.syncmatica.communication.exchange.UploadExchange;
import ch.endte.syncmatica.litematica.LitematicManager;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import java.io.File;
import java.io.FileNotFoundException;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class ShareLitematicExchange
extends AbstractExchange {
    private final SchematicPlacement schematicPlacement;
    private final ServerPlacement toShare;
    private final File toUpload;

    public ShareLitematicExchange(SchematicPlacement schematicPlacement, ExchangeTarget partner, Context con) {
        this(schematicPlacement, partner, con, null);
    }

    public ShareLitematicExchange(SchematicPlacement schematicPlacement, ExchangeTarget partner, Context con, ServerPlacement p) {
        super(partner, con);
        this.schematicPlacement = schematicPlacement;
        this.toShare = p == null ? LitematicManager.getInstance().syncmaticFromSchematic(schematicPlacement) : p;
        this.toUpload = schematicPlacement.getSchematicFile();
    }

    @Override
    public boolean checkPacket(class_2960 id, class_2540 packetBuf) {
        if (id.equals((Object)PacketType.REQUEST_LITEMATIC.identifier) || id.equals((Object)PacketType.REGISTER_METADATA.identifier) || id.equals((Object)PacketType.CANCEL_SHARE.identifier)) {
            return AbstractExchange.checkUUID(packetBuf, this.toShare.getId());
        }
        return false;
    }

    @Override
    public void handle(class_2960 id, class_2540 packetBuf) {
        if (id.equals((Object)PacketType.REQUEST_LITEMATIC.identifier)) {
            UploadExchange upload;
            packetBuf.method_10790();
            try {
                upload = new UploadExchange(this.toShare, this.toUpload, this.getPartner(), this.getContext());
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return;
            }
            this.getManager().startExchange(upload);
            return;
        }
        if (id.equals((Object)PacketType.REGISTER_METADATA.identifier)) {
            RedirectFileStorage redirect = (RedirectFileStorage)this.getContext().getFileStorage();
            redirect.addRedirect(this.toUpload);
            LitematicManager.getInstance().renderSyncmatic(this.toShare, this.schematicPlacement, false);
            this.getContext().getSyncmaticManager().addPlacement(this.toShare);
            return;
        }
        if (id.equals((Object)PacketType.CANCEL_SHARE.identifier)) {
            this.close(false);
        }
    }

    @Override
    public void init() {
        if (this.toShare == null) {
            this.close(false);
            return;
        }
        ((ClientCommunicationManager)this.getManager()).setSharingState(this.toShare, true);
        this.getContext().getSyncmaticManager().updateServerPlacement(this.toShare);
        this.getManager().sendMetaData(this.toShare, this.getPartner());
    }

    @Override
    public void onClose() {
        ((ClientCommunicationManager)this.getManager()).setSharingState(this.toShare, false);
    }
}

