/*
 * Decompiled with CFR 0.152.
 */
package ch.endte.syncmatica.network;

import ch.endte.syncmatica.communication.ExchangeTarget;
import ch.endte.syncmatica.communication.PacketType;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import org.slf4j.LoggerFactory;

public class ChannelManager {
    private static final class_2960 MINECRAFT_REGISTER = new class_2960("minecraft:register");
    private static final class_2960 MINECRAFT_UNREGISTER = new class_2960("minecraft:unregister");
    private static final List<class_2960> serverRegisterChannels = new ArrayList<class_2960>();
    private static final List<class_2960> clientRegisterChannels = new ArrayList<class_2960>();

    private static List<class_2960> onReadRegisterIdentifier(class_2540 data) {
        ArrayList<class_2960> identifiers = new ArrayList<class_2960>();
        int start = 0;
        while (data.isReadable()) {
            byte b = data.readByte();
            if (b != 0) continue;
            String string = data.toString(start, data.readerIndex() - start - 1, StandardCharsets.UTF_8);
            string = string.split("/")[0].split("\\\\")[0];
            identifiers.add(new class_2960(string));
            start = data.readerIndex();
        }
        return identifiers;
    }

    public static void onChannelRegisterHandle(ExchangeTarget target, class_2960 channel, class_2540 data) {
        if (channel.equals((Object)MINECRAFT_REGISTER)) {
            List<class_2960> identifiers = ChannelManager.onReadRegisterIdentifier(new class_2540(data.copy()));
            class_2540 byteBuf2 = new class_2540(Unpooled.buffer());
            List<class_2960> registerChannels = target.isClient() ? clientRegisterChannels : serverRegisterChannels;
            for (class_2960 identifier : identifiers) {
                if (registerChannels.contains(identifier) || !PacketType.containsIdentifier(identifier)) continue;
                LoggerFactory.getLogger((String)"").info(identifier.toString());
                byte[] bytes = identifier.toString().getBytes(StandardCharsets.UTF_8);
                byteBuf2.method_52983(bytes);
                byteBuf2.method_52997(0);
            }
            if (byteBuf2.writerIndex() > 0) {
                target.sendPacket(MINECRAFT_REGISTER, byteBuf2, null);
            }
        }
    }

    public static void onDisconnected() {
        clientRegisterChannels.clear();
        serverRegisterChannels.clear();
    }
}

