/*
 * Decompiled with CFR 0.152.
 */
package ch.endte.syncmatica.service;

import ch.endte.syncmatica.Syncmatica;
import ch.endte.syncmatica.service.AbstractService;
import ch.endte.syncmatica.service.IServiceConfiguration;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;

public class DebugService
extends AbstractService {
    private boolean doPacketLogging = false;

    public void logReceivePacket(class_2960 packageType) {
        if (this.doPacketLogging) {
            LogManager.getLogger(Syncmatica.class).info("Syncmatica - received packet:[type={}]", (Object)packageType);
        }
    }

    public void logSendPacket(class_2960 packetType, String targetIdentifier) {
        if (this.doPacketLogging) {
            LogManager.getLogger(Syncmatica.class).info("Sending packet[type={}] to ExchangeTarget[id={}]", (Object)packetType, (Object)targetIdentifier);
        }
    }

    @Override
    public void getDefaultConfiguration(IServiceConfiguration configuration) {
        configuration.saveBoolean("doPackageLogging", false);
    }

    @Override
    public String getConfigKey() {
        return "debug";
    }

    @Override
    public void configure(IServiceConfiguration configuration) {
        configuration.loadBoolean("doPackageLogging", b -> {
            this.doPacketLogging = b;
        });
    }

    @Override
    public void startup() {
    }

    @Override
    public void shutdown() {
    }
}

