/*
 * Decompiled with CFR 0.152.
 */
package io.github.lgatodu47.screenshot_viewer.screen.manage_screenshots;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.lgatodu47.screenshot_viewer.ScreenshotViewerUtils;
import io.github.lgatodu47.screenshot_viewer.screen.ScreenshotViewerTexts;
import io.github.lgatodu47.screenshot_viewer.screen.manage_screenshots.ManageScreenshotsScreen;
import io.github.lgatodu47.screenshot_viewer.screen.manage_screenshots.ScreenshotImageHolder;
import io.github.lgatodu47.screenshot_viewer.screen.manage_screenshots.ScreenshotImageList;
import io.github.lgatodu47.screenshot_viewer.screen.manage_screenshots.ScreenshotPropertiesMenu;
import java.util.function.Consumer;
import net.minecraft.class_1011;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_757;
import org.jetbrains.annotations.Nullable;

class EnlargedScreenshotScreen
extends class_437 {
    @Nullable
    private ScreenshotImageHolder showing;
    @Nullable
    private ScreenshotImageList imageList;
    private final PropertiesDisplay properties;
    private final class_339 doneBtn;
    private final class_339 nextBtn;
    private final class_339 prevBtn;
    private final class_339 openBtn;
    private final class_339 copyBtn;
    private final class_339 deleteBtn;
    private final class_339 renameBtn;

    EnlargedScreenshotScreen(PropertiesDisplay properties) {
        super((class_2561)class_2561.method_43473());
        this.properties = properties;
        this.doneBtn = new ManageScreenshotsScreen.ExtendedButtonWidget(0, 0, 52, 20, class_5244.field_24334, btn -> this.method_25419());
        this.prevBtn = new ManageScreenshotsScreen.ExtendedButtonWidget(0, 0, 20, 20, (class_2561)class_2561.method_43470((String)"<"), btn -> this.previousScreenshot());
        this.nextBtn = new ManageScreenshotsScreen.ExtendedButtonWidget(0, 0, 20, 20, (class_2561)class_2561.method_43470((String)">"), btn -> this.nextScreenshot());
        this.openBtn = this.makeIconWidget(ScreenshotPropertiesMenu.OPEN_ICON, ScreenshotViewerTexts.OPEN_FILE, ScreenshotImageHolder::openFile);
        this.copyBtn = this.makeIconWidget(ScreenshotPropertiesMenu.COPY_ICON, ScreenshotViewerTexts.COPY, ScreenshotImageHolder::copyScreenshot);
        this.deleteBtn = this.makeIconWidget(ScreenshotPropertiesMenu.DELETE_ICON, ScreenshotViewerTexts.DELETE, ScreenshotImageHolder::requestFileDeletion);
        this.renameBtn = this.makeIconWidget(ScreenshotPropertiesMenu.RENAME_ICON, ScreenshotViewerTexts.RENAME_FILE, ScreenshotImageHolder::renameFile);
    }

    private class_339 makeIconWidget(class_2960 texture, class_2561 description, Consumer<ScreenshotImageHolder> action) {
        return new ManageScreenshotsScreen.ExtendedTexturedButtonWidget(0, 0, 20, 20, texture, btn -> {
            if (this.showing != null) {
                action.accept(this.showing);
            }
        }, description, description);
    }

    void show(ScreenshotImageHolder showing, ScreenshotImageList imageList) {
        this.showing = showing;
        this.imageList = imageList;
        this.updateButtonsState();
    }

    protected void method_25426() {
        super.method_25426();
        this.method_37067();
        int spacing = 4;
        this.addPositioned(this.doneBtn, (this.field_22789 - 52) / 2, this.field_22790 - 20 - spacing * 2);
        this.addPositioned(this.prevBtn, spacing * 2, (this.field_22790 - 20) / 2);
        int rightButtonsX = this.field_22789 - spacing * 2 - 20;
        this.addPositioned(this.nextBtn, this.field_22789 - spacing * 2 - 20, (this.field_22790 - 20) / 2);
        this.addPositioned(this.openBtn, rightButtonsX, this.field_22790 - 100 - spacing * 6);
        this.addPositioned(this.copyBtn, rightButtonsX, this.field_22790 - 80 - spacing * 5);
        this.addPositioned(this.deleteBtn, rightButtonsX, this.field_22790 - 60 - spacing * 4);
        this.addPositioned(this.renameBtn, rightButtonsX, this.field_22790 - 40 - spacing * 3);
    }

    private void addPositioned(class_339 button, int x, int y) {
        button.method_46421(x);
        button.method_46419(y);
        this.method_37063((class_364)button);
    }

    private void nextScreenshot() {
        int i;
        if (this.hasInfo() && (i = this.showing.indexInList() + 1) < this.imageList.size()) {
            this.showing = this.imageList.getScreenshot(i);
            this.updateButtonsState();
        }
    }

    private void previousScreenshot() {
        int i;
        if (this.hasInfo() && (i = this.showing.indexInList() - 1) >= 0) {
            this.showing = this.imageList.getScreenshot(i);
            this.updateButtonsState();
        }
    }

    private void updateButtonsState() {
        if (this.hasInfo()) {
            int i = this.showing.indexInList();
            this.prevBtn.field_22763 = i > 0;
            this.nextBtn.field_22763 = i < this.imageList.size() - 1;
        }
    }

    private boolean hasInfo() {
        return this.showing != null && this.imageList != null;
    }

    boolean renders() {
        return this.hasInfo();
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
        context.method_25296(0, 0, this.field_22789, this.field_22790, -1072689136, -804253680);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
    }

    public void render(class_332 context, int mouseX, int mouseY, float partialTicks, boolean updateHoverState) {
        this.method_25396().forEach(element -> {
            if (element instanceof class_4068) {
                class_4068 drawable = (class_4068)element;
                drawable.method_25394(context, mouseX, mouseY, partialTicks);
            }
            if (element instanceof ManageScreenshotsScreen.CustomHoverState) {
                ManageScreenshotsScreen.CustomHoverState state = (ManageScreenshotsScreen.CustomHoverState)element;
                int mul = updateHoverState ? 1 : -1;
                state.updateHoveredState(mouseX * mul, mouseY * mul);
            }
        });
    }

    public void renderImage(class_332 context) {
        if (this.showing != null) {
            int spacing = 8;
            class_1011 image = this.showing.image();
            if (image != null) {
                RenderSystem.setShader(class_757::method_34542);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.setShaderTexture((int)0, (int)this.showing.imageId());
                RenderSystem.enableBlend();
                float imgRatio = (float)image.method_4307() / (float)image.method_4323();
                int texHeight = this.field_22790 - 24 - 20;
                int texWidth = (int)((float)texHeight * imgRatio);
                ScreenshotViewerUtils.drawTexture(context, (this.field_22789 - texWidth) / 2, 8, texWidth, texHeight, 0, 0, image.method_4307(), image.method_4323(), image.method_4307(), image.method_4323());
                RenderSystem.disableBlend();
            }
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (verticalAmount > 0.0) {
            this.nextScreenshot();
        }
        if (verticalAmount < 0.0) {
            this.previousScreenshot();
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 263) {
            this.previousScreenshot();
            return true;
        }
        if (keyCode == 262) {
            this.nextScreenshot();
            return true;
        }
        if (this.showing != null && keyCode == 67 && (modifiers & 2) != 0) {
            this.showing.copyScreenshot();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.showing != null && button == 1) {
            this.properties.showProperties(mouseX, mouseY, this.showing);
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public void method_25419() {
        this.showing = null;
        this.imageList = null;
    }

    @FunctionalInterface
    static interface PropertiesDisplay {
        public void showProperties(double var1, double var3, ScreenshotImageHolder var5);
    }
}

