/*
 * Decompiled with CFR 0.152.
 */
package io.github.lgatodu47.screenshot_viewer.screen.manage_screenshots;

import com.mojang.logging.LogUtils;
import io.github.lgatodu47.catconfig.CatConfig;
import io.github.lgatodu47.catconfigmc.screen.ConfigListener;
import io.github.lgatodu47.screenshot_viewer.ScreenshotViewer;
import io.github.lgatodu47.screenshot_viewer.ScreenshotViewerUtils;
import io.github.lgatodu47.screenshot_viewer.config.ScreenshotViewerOptions;
import io.github.lgatodu47.screenshot_viewer.screen.IconButtonWidget;
import io.github.lgatodu47.screenshot_viewer.screen.ScreenshotViewerConfigScreen;
import io.github.lgatodu47.screenshot_viewer.screen.ScreenshotViewerTexts;
import io.github.lgatodu47.screenshot_viewer.screen.manage_screenshots.ConfirmDeletionScreen;
import io.github.lgatodu47.screenshot_viewer.screen.manage_screenshots.EnlargedScreenshotScreen;
import io.github.lgatodu47.screenshot_viewer.screen.manage_screenshots.ScreenshotImageHolder;
import io.github.lgatodu47.screenshot_viewer.screen.manage_screenshots.ScreenshotList;
import io.github.lgatodu47.screenshot_viewer.screen.manage_screenshots.ScreenshotPropertiesMenu;
import io.github.lgatodu47.screenshot_viewer.screen.manage_screenshots.ScreenshotWidget;
import java.io.File;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_7919;
import net.minecraft.class_8000;
import net.minecraft.class_8001;
import net.minecraft.class_8666;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ManageScreenshotsScreen
extends class_437
implements ConfigListener {
    static final CatConfig CONFIG = ScreenshotViewer.getInstance().getConfig();
    static final Logger LOGGER = LogUtils.getLogger();
    public static final class_8666 DEFAULT_BUTTON_TEXTURES = new class_8666(new class_2960("widget/button"), new class_2960("widget/button_disabled"), new class_2960("widget/button_highlighted"));
    private static final class_2960 CONFIG_ICON = new class_2960("screenshot_viewer", "widget/icons/config");
    private static final class_2960 REFRESH_ICON = new class_2960("screenshot_viewer", "widget/icons/refresh");
    private static final class_2960 ASCENDING_ORDER_ICON = new class_2960("screenshot_viewer", "widget/icons/ascending_order");
    private static final class_2960 DESCENDING_ORDER_ICON = new class_2960("screenshot_viewer", "widget/icons/descending_order");
    private static final class_2960 OPEN_FOLDER_ICON = new class_2960("screenshot_viewer", "widget/icons/open_folder");
    private static final class_2960 FAST_DELETE_ICON = new class_2960("screenshot_viewer", "widget/icons/delete");
    private static final class_2960 FAST_DELETE_ENABLED_ICON = new class_2960("screenshot_viewer", "widget/icons/fast_delete_enabled");
    private final class_437 parent;
    private final EnlargedScreenshotScreen enlargedScreenshot;
    private final ScreenshotPropertiesMenu screenshotProperties;
    private ScreenshotList list;
    private boolean fastDelete;
    @Nullable
    private class_437 dialogScreen;
    @Nullable
    private File enlargedScreenshotFile;
    private boolean enlargeAnimation;
    private float screenshotScaleAnimation;
    private boolean isCtrlDown;

    public ManageScreenshotsScreen(class_437 parent) {
        super(ScreenshotViewerTexts.MANAGE_SCREENSHOTS);
        this.parent = parent;
        this.enlargedScreenshot = new EnlargedScreenshotScreen(this::showScreenshotProperties);
        this.screenshotProperties = new ScreenshotPropertiesMenu(this::client);
        this.enlargeAnimation = (Boolean)CONFIG.getOrFallback(ScreenshotViewerOptions.ENABLE_SCREENSHOT_ENLARGEMENT_ANIMATION, (Object)true);
    }

    public ManageScreenshotsScreen(class_437 parent, @Nullable File enlargedScreenshotFile) {
        this(parent);
        this.enlargedScreenshotFile = enlargedScreenshotFile;
    }

    class_310 client() {
        return this.field_22787;
    }

    public boolean isFastDeleteToggled() {
        return this.fastDelete;
    }

    public void method_25393() {
        if (this.dialogScreen != null) {
            this.dialogScreen.method_25393();
        }
    }

    protected void method_25426() {
        if (this.field_22787 == null) {
            return;
        }
        int spacing = 8;
        int btnHeight = 20;
        this.enlargedScreenshot.method_25423(this.field_22787, this.field_22789, this.field_22790);
        int contentWidth = this.field_22789 - 24;
        int contentHeight = this.field_22790 - 40 - 20;
        if (this.list == null) {
            this.list = new ScreenshotList(this, 12, 24, this.field_22789 - 24, this.field_22790 - 40 - 20);
            this.list.init();
        } else {
            this.list.updateSize(contentWidth, contentHeight);
            this.list.updateChildren(false);
        }
        this.method_25429((class_364)this.list);
        int btnY = this.field_22790 - 8 - 20;
        int btnSize = 20;
        int bigBtnWidth = 200;
        this.method_37063((class_364)new ExtendedTexturedButtonWidget(2, 2, 20, 20, CONFIG_ICON, button -> this.field_22787.method_1507((class_437)new ScreenshotViewerConfigScreen(this)), ScreenshotViewerTexts.CONFIG, ScreenshotViewerTexts.CONFIG).offsetTooltip());
        this.method_37063((class_364)new ExtendedTexturedButtonWidget(8, btnY, 20, 20, null, button -> {
            if (this.list != null) {
                this.list.invertOrder();
            }
        }, null, ScreenshotViewerTexts.ORDER){

            @Override
            @Nullable
            protected class_2561 getTooltipText() {
                return ManageScreenshotsScreen.this.list == null ? null : (ManageScreenshotsScreen.this.list.isInvertedOrder() ? ScreenshotViewerTexts.DESCENDING_ORDER : ScreenshotViewerTexts.ASCENDING_ORDER);
            }

            @Override
            @Nullable
            public class_2960 getIconTexture() {
                return ManageScreenshotsScreen.this.list == null ? null : (ManageScreenshotsScreen.this.list.isInvertedOrder() ? DESCENDING_ORDER_ICON : ASCENDING_ORDER_ICON);
            }
        });
        this.method_37063((class_364)new ExtendedTexturedButtonWidget(36, btnY, 20, 20, OPEN_FOLDER_ICON, btn -> class_156.method_668().method_672((File)CONFIG.getOrFallback(ScreenshotViewerOptions.SCREENSHOTS_FOLDER, ScreenshotViewerUtils::getVanillaScreenshotsFolder)), ScreenshotViewerTexts.OPEN_FOLDER, ScreenshotViewerTexts.OPEN_FOLDER));
        this.method_37063((class_364)new ExtendedButtonWidget((this.field_22789 - 200) / 2, btnY, 200, 20, class_5244.field_24334, button -> {
            List<ScreenshotWidget> toDelete = this.list.deletionList();
            if (this.fastDelete && !toDelete.isEmpty()) {
                if (((Boolean)CONFIG.getOrFallback(ScreenshotViewerOptions.PROMPT_WHEN_DELETING_SCREENSHOT, (Object)true)).booleanValue()) {
                    this.setDialogScreen((class_437)new ConfirmDeletionScreen(value -> {
                        if (value) {
                            toDelete.forEach(ScreenshotWidget::deleteScreenshot);
                        }
                        this.setDialogScreen(null);
                    }, (class_2561)class_2561.method_43469((String)"screen.screenshot_viewer.screenshot_manager.delete_n_screenshots", (Object[])new Object[]{toDelete.size()}), toDelete.size() == 1 ? ScreenshotViewerTexts.DELETE_WARNING_MESSAGE : ScreenshotViewerTexts.DELETE_MULTIPLE_WARNING_MESSAGE));
                } else {
                    toDelete.forEach(ScreenshotWidget::deleteScreenshot);
                }
                this.fastDelete = false;
                return;
            }
            this.method_25419();
        }){

            public class_2561 method_25369() {
                List<ScreenshotWidget> toDelete = ManageScreenshotsScreen.this.list.deletionList();
                if (ManageScreenshotsScreen.this.fastDelete && !toDelete.isEmpty()) {
                    return class_2561.method_43469((String)"screen.screenshot_viewer.screenshot_manager.delete_n_screenshots", (Object[])new Object[]{toDelete.size()}).method_27692(class_124.field_1061);
                }
                return super.method_25369();
            }
        });
        this.method_37063((class_364)new ExtendedTexturedButtonWidget(this.field_22789 - 16 - 40, btnY, 20, 20, null, button -> {
            boolean bl = this.fastDelete = !this.fastDelete;
            if (!this.fastDelete) {
                this.list.resetDeleteSelection();
            }
        }, ScreenshotViewerTexts.FAST_DELETE, ScreenshotViewerTexts.FAST_DELETE){

            @Override
            public class_2960 getIconTexture() {
                return ManageScreenshotsScreen.this.fastDelete ? FAST_DELETE_ENABLED_ICON : FAST_DELETE_ICON;
            }
        });
        this.method_37063((class_364)new ExtendedTexturedButtonWidget(this.field_22789 - 8 - 20, btnY, 20, 20, REFRESH_ICON, button -> this.list.init(), ScreenshotViewerTexts.REFRESH, ScreenshotViewerTexts.REFRESH));
        if (this.enlargedScreenshotFile != null) {
            this.list.findByFileName(this.enlargedScreenshotFile).ifPresentOrElse(this::enlargeScreenshot, () -> LOGGER.warn("Tried to enlarge screenshot with a path '{}' that could not be located in the screenshots folder!", (Object)this.enlargedScreenshotFile.getAbsolutePath()));
            this.enlargedScreenshotFile = null;
        }
    }

    public void method_25410(class_310 client, int width, int height) {
        super.method_25410(client, width, height);
        this.enlargedScreenshot.method_25410(client, width, height);
        if (this.dialogScreen != null) {
            this.dialogScreen.method_25410(client, width, height);
        }
        this.screenshotProperties.hide();
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context, mouseX, mouseY, delta);
        if (this.list != null) {
            this.list.render(context, mouseX, mouseY, delta, !this.enlargedScreenshot.renders() && !this.screenshotProperties.renders() && this.dialogScreen == null);
        }
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 8, 0xFFFFFF);
        this.renderActionText(context);
        ScreenshotViewerUtils.forEachDrawable(this, drawable -> drawable.method_25394(context, mouseX, mouseY, delta));
        class_4587 matrices = context.method_51448();
        if (this.enlargedScreenshot.renders()) {
            float animationTime = 1.0f;
            if (this.enlargeAnimation && this.screenshotScaleAnimation < 1.0f) {
                animationTime = (float)(1.0 - Math.pow(1.0f - (this.screenshotScaleAnimation += 0.03f), 3.0));
            }
            matrices.method_22903();
            matrices.method_46416(0.0f, 0.0f, 1.0f);
            this.enlargedScreenshot.method_25420(context, mouseX, mouseY, delta);
            matrices.method_22903();
            matrices.method_46416((float)this.enlargedScreenshot.field_22789 / 2.0f * (1.0f - animationTime), (float)this.enlargedScreenshot.field_22790 / 2.0f * (1.0f - animationTime), 0.0f);
            matrices.method_22905(animationTime, animationTime, animationTime);
            this.enlargedScreenshot.renderImage(context);
            matrices.method_22909();
            this.enlargedScreenshot.render(context, mouseX, mouseY, delta, !this.screenshotProperties.renders() && this.dialogScreen == null);
            matrices.method_22909();
        } else {
            if (this.screenshotScaleAnimation > 0.0f) {
                this.screenshotScaleAnimation = 0.0f;
            }
            if (!this.screenshotProperties.renders() && this.dialogScreen == null) {
                for (class_364 element : this.method_25396()) {
                    if (!(element instanceof CustomHoverState)) continue;
                    CustomHoverState hover = (CustomHoverState)element;
                    hover.updateHoveredState(mouseX, mouseY);
                }
            }
        }
        if (this.dialogScreen != null) {
            matrices.method_22903();
            matrices.method_46416(0.0f, 0.0f, 5.0f);
            this.dialogScreen.method_25394(context, mouseX, mouseY, delta);
            matrices.method_22909();
        } else {
            matrices.method_22903();
            matrices.method_46416(0.0f, 0.0f, 2.0f);
            this.screenshotProperties.method_25394(context, mouseX, mouseY, delta);
            matrices.method_22909();
        }
    }

    private void renderActionText(class_332 context) {
        class_2561 text = this.fastDelete ? ScreenshotViewerTexts.FAST_DELETE_MODE : ScreenshotViewerTexts.ZOOM_MODE;
        context.method_27535(this.field_22793, text, this.field_22789 - this.field_22793.method_27525((class_5348)text) - 8, 8, this.fastDelete ? 15417396 : (this.isCtrlDown ? 1629753 : 15780386));
    }

    void enlargeScreenshot(@Nullable ScreenshotImageHolder showing) {
        if (showing == null) {
            this.enlargedScreenshot.method_25419();
        }
        this.enlargedScreenshot.show(showing, this.list);
    }

    void showScreenshotProperties(double mouseX, double mouseY, ScreenshotImageHolder widget) {
        if (this.list == null) {
            return;
        }
        this.screenshotProperties.show((int)mouseX, (int)mouseY, this.field_22789, this.field_22790, widget);
    }

    void setDialogScreen(class_437 screen) {
        if (this.field_22787 == null) {
            return;
        }
        this.dialogScreen = screen;
        if (this.dialogScreen != null) {
            this.dialogScreen.method_25423(this.field_22787, this.field_22789, this.field_22790);
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.dialogScreen != null) {
            return this.dialogScreen.method_25404(keyCode, scanCode, modifiers);
        }
        if (this.screenshotProperties.renders()) {
            return this.screenshotProperties.method_25404(keyCode, scanCode, modifiers);
        }
        if (this.enlargedScreenshot.renders()) {
            return this.enlargedScreenshot.method_25404(keyCode, scanCode, modifiers);
        }
        boolean bl = this.isCtrlDown = keyCode == 341 || keyCode == 345;
        if (keyCode == 294) {
            this.list.init();
            return true;
        }
        if (this.list != null && this.list.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        if (this.dialogScreen != null) {
            return this.dialogScreen.method_16803(keyCode, scanCode, modifiers);
        }
        if (this.screenshotProperties.renders()) {
            return this.screenshotProperties.method_16803(keyCode, scanCode, modifiers);
        }
        if (this.enlargedScreenshot.renders()) {
            return this.enlargedScreenshot.method_16803(keyCode, scanCode, modifiers);
        }
        if (this.isCtrlDown) {
            this.isCtrlDown = false;
        }
        return super.method_16803(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char chr, int modifiers) {
        if (this.dialogScreen != null) {
            return this.dialogScreen.method_25400(chr, modifiers);
        }
        if (this.screenshotProperties.renders()) {
            return this.screenshotProperties.method_25400(chr, modifiers);
        }
        if (this.enlargedScreenshot.renders()) {
            return this.enlargedScreenshot.method_25400(chr, modifiers);
        }
        return super.method_25400(chr, modifiers);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalMovement, double verticalMovement) {
        if (this.dialogScreen != null) {
            return this.dialogScreen.method_25401(mouseX, mouseY, horizontalMovement, verticalMovement);
        }
        if (this.screenshotProperties.renders()) {
            return this.screenshotProperties.method_25401(mouseX, mouseY, horizontalMovement, verticalMovement);
        }
        if (this.enlargedScreenshot.renders()) {
            return this.enlargedScreenshot.method_25401(mouseX, mouseY, horizontalMovement, verticalMovement);
        }
        if (this.list != null) {
            if (this.isCtrlDown) {
                this.list.updateScreenshotsPerRow(verticalMovement);
                return true;
            }
            return this.list.method_25401(mouseX, mouseY, horizontalMovement, verticalMovement);
        }
        return super.method_25401(mouseX, mouseY, horizontalMovement, verticalMovement);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.dialogScreen != null) {
            return this.dialogScreen.method_25402(mouseX, mouseY, button);
        }
        if (this.screenshotProperties.renders()) {
            return this.screenshotProperties.method_25402(mouseX, mouseY, button);
        }
        if (this.enlargedScreenshot.renders()) {
            return this.enlargedScreenshot.method_25402(mouseX, mouseY, button);
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.dialogScreen != null) {
            return this.dialogScreen.method_25406(mouseX, mouseY, button);
        }
        if (this.screenshotProperties.renders()) {
            return this.screenshotProperties.method_25406(mouseX, mouseY, button);
        }
        if (this.enlargedScreenshot.renders()) {
            return this.enlargedScreenshot.method_25406(mouseX, mouseY, button);
        }
        if (this.list != null) {
            return this.list.method_25406(mouseX, mouseY, button);
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.dialogScreen != null) {
            return this.dialogScreen.method_25403(mouseX, mouseY, button, deltaX, deltaY);
        }
        if (this.screenshotProperties.renders()) {
            return this.screenshotProperties.method_25403(mouseX, mouseY, button, deltaX, deltaY);
        }
        if (this.enlargedScreenshot.renders()) {
            return this.enlargedScreenshot.method_25403(mouseX, mouseY, button, deltaX, deltaY);
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public Optional<class_364> method_19355(double mouseX, double mouseY) {
        if (this.dialogScreen != null) {
            return this.dialogScreen.method_19355(mouseX, mouseY);
        }
        if (this.screenshotProperties.renders()) {
            return this.screenshotProperties.method_19355(mouseX, mouseY);
        }
        if (this.enlargedScreenshot.renders()) {
            return this.enlargedScreenshot.method_19355(mouseX, mouseY);
        }
        return super.method_19355(mouseX, mouseY);
    }

    public void method_25419() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        }
    }

    public void method_25432() {
        this.list.close();
    }

    public void configUpdated() {
        this.list.onConfigUpdate();
        this.enlargeAnimation = (Boolean)CONFIG.getOrFallback(ScreenshotViewerOptions.ENABLE_SCREENSHOT_ENLARGEMENT_ANIMATION, (Object)true);
    }

    public static class ExtendedTexturedButtonWidget
    extends IconButtonWidget
    implements CustomHoverState {
        @Nullable
        private final class_2561 tooltip;
        private boolean offsetTooltip;

        public ExtendedTexturedButtonWidget(int x, int y, int width, int height, @Nullable class_2960 texture, class_4185.class_4241 pressAction, @Nullable class_2561 tooltip, class_2561 text) {
            super(x, y, width, height, text, texture, pressAction);
            this.tooltip = tooltip;
            if (tooltip != null) {
                this.method_47400(class_7919.method_47407((class_2561)tooltip));
            }
        }

        public ExtendedTexturedButtonWidget offsetTooltip() {
            this.offsetTooltip = true;
            return this;
        }

        public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
            if (!this.field_22764) {
                return;
            }
            this.method_48579(context, mouseX, mouseY, delta);
            this.applyTooltip();
        }

        private void applyTooltip() {
            class_437 screen;
            class_2561 tooltipText = this.getTooltipText();
            if (tooltipText != null && this.method_49606() && (screen = class_310.method_1551().field_1755) != null) {
                screen.method_47412(class_7919.method_47407((class_2561)tooltipText), this.getTooltipPositioner(), this.method_25370());
            }
        }

        @Nullable
        protected class_2561 getTooltipText() {
            return this.tooltip;
        }

        protected class_8000 getTooltipPositioner() {
            class_8000 positioner = class_8001.field_41687;
            return this.offsetTooltip ? (screen_width, screen_height, x, y, w, h) -> positioner.method_47944(screen_width, screen_height, x, y + this.field_22759, w, h) : positioner;
        }

        public boolean method_25367() {
            return this.method_49606();
        }

        @Override
        public void updateHoveredState(int mouseX, int mouseY) {
            this.field_22762 = mouseX >= this.method_46426() && mouseY >= this.method_46427() && mouseX < this.method_46426() + this.field_22758 && mouseY < this.method_46427() + this.field_22759;
        }
    }

    public static interface CustomHoverState {
        public void updateHoveredState(int var1, int var2);
    }

    public static class ExtendedButtonWidget
    extends class_4185
    implements CustomHoverState {
        public ExtendedButtonWidget(int x, int y, int width, int height, class_2561 message, class_4185.class_4241 onPress) {
            super(x, y, width, height, message, onPress, Supplier::get);
        }

        public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
            if (!this.field_22764) {
                return;
            }
            this.method_48579(context, mouseX, mouseY, delta);
        }

        public boolean method_25367() {
            return this.method_49606();
        }

        @Override
        public void updateHoveredState(int mouseX, int mouseY) {
            this.field_22762 = mouseX >= this.method_46426() && mouseY >= this.method_46427() && mouseX < this.method_46426() + this.field_22758 && mouseY < this.method_46427() + this.field_22759;
        }
    }
}

