/*
 * Decompiled with CFR 0.152.
 */
package io.github.lgatodu47.screenshot_viewer.screen.manage_screenshots;

import io.github.lgatodu47.screenshot_viewer.ScreenshotViewerUtils;
import io.github.lgatodu47.screenshot_viewer.config.ScreenshotListOrder;
import io.github.lgatodu47.screenshot_viewer.config.ScreenshotViewerOptions;
import io.github.lgatodu47.screenshot_viewer.config.VisibilityState;
import io.github.lgatodu47.screenshot_viewer.screen.ScreenshotViewerTexts;
import io.github.lgatodu47.screenshot_viewer.screen.manage_screenshots.ManageScreenshotsScreen;
import io.github.lgatodu47.screenshot_viewer.screen.manage_screenshots.ScreenshotImageHolder;
import io.github.lgatodu47.screenshot_viewer.screen.manage_screenshots.ScreenshotImageList;
import io.github.lgatodu47.screenshot_viewer.screen.manage_screenshots.ScreenshotWidget;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.IntUnaryOperator;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_362;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_5253;
import net.minecraft.class_6379;
import net.minecraft.class_6382;

final class ScreenshotList
extends class_362
implements class_4068,
class_6379,
ScreenshotImageList,
ScreenshotWidget.Context {
    private final ManageScreenshotsScreen mainScreen;
    private final class_310 client;
    private final int x;
    private final int y;
    private final List<ScreenshotWidget> screenshotWidgets = new ArrayList<ScreenshotWidget>();
    private final List<class_364> elements = new ArrayList<class_364>();
    private final Scrollbar scrollbar = new Scrollbar();
    private int width;
    private int height;
    private int scrollY;
    private int scrollSpeedFactor;
    private int screenshotsPerRow;
    private int spacing;
    private int childWidth;
    private int childHeight;
    private boolean invertedOrder;
    private boolean invertedScroll;
    private boolean namesHidden;
    private File screenshotsFolder;
    private boolean scrollbarClicked;

    ScreenshotList(ManageScreenshotsScreen mainScreen, int x, int y, int width, int height) {
        this.mainScreen = mainScreen;
        this.client = mainScreen.client();
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.scrollSpeedFactor = (Integer)ManageScreenshotsScreen.CONFIG.getOrFallback(ScreenshotViewerOptions.SCREEN_SCROLL_SPEED, (Object)10);
        this.screenshotsPerRow = (Integer)ManageScreenshotsScreen.CONFIG.getOrFallback(ScreenshotViewerOptions.INITIAL_SCREENSHOT_AMOUNT_PER_ROW, (Object)4);
        this.screenshotsFolder = (File)ManageScreenshotsScreen.CONFIG.getOrFallback(ScreenshotViewerOptions.SCREENSHOTS_FOLDER, ScreenshotViewerUtils::getVanillaScreenshotsFolder);
        this.invertedScroll = (Boolean)ManageScreenshotsScreen.CONFIG.getOrFallback(ScreenshotViewerOptions.INVERT_ZOOM_DIRECTION, (Object)false);
        this.namesHidden = ManageScreenshotsScreen.CONFIG.get(ScreenshotViewerOptions.SCREENSHOT_ELEMENT_TEXT_VISIBILITY).filter(VisibilityState.HIDDEN::equals).isPresent();
        this.updateVariables();
    }

    void updateSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    void onConfigUpdate() {
        this.scrollSpeedFactor = (Integer)ManageScreenshotsScreen.CONFIG.getOrFallback(ScreenshotViewerOptions.SCREEN_SCROLL_SPEED, (Object)10);
        this.screenshotsPerRow = (Integer)ManageScreenshotsScreen.CONFIG.getOrFallback(ScreenshotViewerOptions.INITIAL_SCREENSHOT_AMOUNT_PER_ROW, (Object)4);
        this.invertedScroll = (Boolean)ManageScreenshotsScreen.CONFIG.getOrFallback(ScreenshotViewerOptions.INVERT_ZOOM_DIRECTION, (Object)false);
        this.namesHidden = ManageScreenshotsScreen.CONFIG.get(ScreenshotViewerOptions.SCREENSHOT_ELEMENT_TEXT_VISIBILITY).filter(VisibilityState.HIDDEN::equals).isPresent();
        File currentScreenshotsFolder = (File)ManageScreenshotsScreen.CONFIG.getOrFallback(ScreenshotViewerOptions.SCREENSHOTS_FOLDER, ScreenshotViewerUtils::getVanillaScreenshotsFolder);
        if (this.screenshotsFolder != currentScreenshotsFolder) {
            this.screenshotsFolder = currentScreenshotsFolder;
            this.init();
            return;
        }
        if (this.invertedOrder != ((ScreenshotListOrder)((Object)ManageScreenshotsScreen.CONFIG.getOrFallback(ScreenshotViewerOptions.DEFAULT_LIST_ORDER, (Object)ScreenshotListOrder.ASCENDING))).isInverted()) {
            this.invertOrder();
            return;
        }
        this.updateChildren(true);
    }

    void init() {
        this.clearChildren();
        Object[] files = this.screenshotsFolder.listFiles();
        if (files != null) {
            Arrays.sort(files);
            this.updateVariables();
            int maxXOff = this.screenshotsPerRow - 1;
            int childX = this.x + this.spacing;
            int childY = this.y + this.spacing;
            int xOff = 0;
            for (Object file : files) {
                if (!((File)file).isFile() || !((File)file).getName().endsWith(".png") && !((File)file).getName().endsWith(".jpg") && !((File)file).getName().endsWith(".jpeg")) continue;
                ScreenshotWidget widget = new ScreenshotWidget(this.mainScreen, childX, childY, this.childWidth, this.childHeight, this, (File)file);
                this.screenshotWidgets.add(widget);
                this.elements.add((class_364)widget);
                if (xOff == maxXOff) {
                    xOff = 0;
                    childX = this.x + this.spacing;
                    childY += this.childHeight + this.spacing;
                    continue;
                }
                ++xOff;
                childX += this.childWidth + this.spacing;
            }
        }
        this.scrollbar.repositionScrollbar(this.x, this.y, this.width, this.height, this.spacing, this.getTotalHeightOfChildren());
        if (((ScreenshotListOrder)((Object)ManageScreenshotsScreen.CONFIG.getOrFallback(ScreenshotViewerOptions.DEFAULT_LIST_ORDER, (Object)ScreenshotListOrder.ASCENDING))).isInverted()) {
            this.invertOrder();
        }
    }

    void updateScreenshotsPerRow(double scrollAmount) {
        double d = scrollAmount = this.invertedScroll ? -scrollAmount : scrollAmount;
        if (scrollAmount > 0.0) {
            if (this.screenshotsPerRow < 8) {
                this.screenshotsPerRow = Math.min(8, this.screenshotsPerRow + 1);
            }
        } else if (scrollAmount < 0.0 && this.screenshotsPerRow > 2) {
            this.screenshotsPerRow = Math.max(2, this.screenshotsPerRow - 1);
        }
        this.updateChildren(false);
    }

    void updateChildren(boolean configUpdated) {
        this.scrollY = 0;
        this.updateVariables();
        int maxXOff = this.screenshotsPerRow - 1;
        int childX = this.x + this.spacing;
        int childY = this.y + this.spacing;
        int xOff = 0;
        for (ScreenshotWidget widget : this.screenshotWidgets) {
            widget.method_46421(childX);
            widget.updateBaseY(childY);
            widget.method_25358(this.childWidth);
            widget.method_53533(this.childHeight);
            if (configUpdated) {
                widget.onConfigUpdate();
            }
            if (xOff == maxXOff) {
                xOff = 0;
                childX = this.x + this.spacing;
                childY += this.childHeight + this.spacing;
                continue;
            }
            ++xOff;
            childX += this.childWidth + this.spacing;
        }
        this.scrollbar.repositionScrollbar(this.x, this.y, this.width, this.height, this.spacing, this.getTotalHeightOfChildren());
    }

    List<ScreenshotWidget> deletionList() {
        return this.mainScreen.isFastDeleteToggled() ? this.screenshotWidgets.stream().filter(ScreenshotWidget::isSelectedForDeletion).toList() : List.of();
    }

    void resetDeleteSelection() {
        this.screenshotWidgets.forEach(ScreenshotWidget::deselectForDeletion);
    }

    private void updateVariables() {
        float windowAspect = (float)this.client.method_22683().method_4480() / (float)this.client.method_22683().method_4507();
        int scrollbarWidth = 6;
        int scrollbarSpacing = 2;
        this.spacing = 4;
        this.childWidth = (this.width - (this.screenshotsPerRow + 1) * this.spacing - 6 - 2) / this.screenshotsPerRow;
        this.childHeight = (int)((this.namesHidden ? 1.0 : 1.08) * (double)this.childWidth / (double)windowAspect);
    }

    private void clearChildren() {
        this.close();
        this.screenshotWidgets.clear();
        this.elements.clear();
    }

    public void close() {
        this.screenshotWidgets.forEach(ScreenshotWidget::close);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
    }

    void render(class_332 context, int mouseX, int mouseY, float delta, boolean updateHoverState) {
        context.method_25294(this.x, this.y, this.x + this.width, this.y + this.height, class_5253.class_5254.method_27764((int)178, (int)0, (int)0, (int)0));
        if (this.screenshotWidgets.isEmpty()) {
            context.method_27534(this.client.field_1772, ScreenshotViewerTexts.NO_SCREENSHOTS, (this.x + this.width) / 2, (this.y + this.height + 8) / 2, 0xFFFFFF);
        }
        for (ScreenshotWidget screenshotWidget : this.screenshotWidgets) {
            screenshotWidget.updateY(this.scrollY);
            int viewportY = this.y + this.spacing;
            int viewportBottom = this.y + this.height - this.spacing;
            screenshotWidget.updateHoverState(mouseX, mouseY, viewportY, viewportBottom, updateHoverState);
            if (screenshotWidget.method_46427() + screenshotWidget.method_25364() < this.y || screenshotWidget.method_46427() > this.y + this.height) continue;
            screenshotWidget.render(context, mouseX, mouseY, delta, viewportY, viewportBottom);
        }
        if (this.canScroll()) {
            this.scrollbar.render(context, mouseX, mouseY, this.scrollY, updateHoverState, this.scrollbarClicked);
        }
    }

    public List<? extends class_364> method_25396() {
        return this.elements;
    }

    @Override
    public ScreenshotImageHolder getScreenshot(int index) {
        return this.screenshotWidgets.get(index);
    }

    @Override
    public Optional<ScreenshotImageHolder> findByFileName(File file) {
        return this.screenshotWidgets.stream().filter(screenshotWidget -> screenshotWidget.getScreenshotFile().equals(file)).map(ScreenshotImageHolder.class::cast).findFirst();
    }

    @Override
    public int size() {
        return this.screenshotWidgets.size();
    }

    @Override
    public int screenshotsPerRow() {
        return this.screenshotsPerRow;
    }

    @Override
    public int currentIndex(ScreenshotWidget widget) {
        return this.screenshotWidgets.indexOf(widget);
    }

    @Override
    public void removeEntry(ScreenshotWidget widget) {
        this.screenshotWidgets.remove(widget);
        this.elements.remove(widget);
        this.updateChildren(false);
    }

    void invertOrder() {
        Collections.reverse(this.screenshotWidgets);
        this.invertedOrder = !this.invertedOrder;
        int previousScrollY = this.scrollY;
        this.updateChildren(false);
        this.scrollY = previousScrollY;
    }

    boolean isInvertedOrder() {
        return this.invertedOrder;
    }

    private boolean canScroll() {
        int viewHeight;
        int totalHeightOfTheChildrens = this.getTotalHeightOfChildren();
        return totalHeightOfTheChildrens > (viewHeight = this.height - 2 * this.spacing);
    }

    private boolean canScrollDown() {
        int viewHeight;
        int totalHeightOfTheChildrens = this.getTotalHeightOfChildren();
        int leftOver = totalHeightOfTheChildrens - (viewHeight = this.height - 2 * this.spacing);
        return this.scrollY < leftOver;
    }

    private int getTotalHeightOfChildren() {
        int rows = class_3532.method_15386((float)((float)this.screenshotWidgets.size() / (float)this.screenshotsPerRow));
        return rows * this.childHeight + this.spacing * (rows - 1);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.canScroll()) {
            int scrollSpeed = Math.abs((int)((double)((float)this.scrollSpeedFactor * (6.0f / (float)this.screenshotsPerRow)) * verticalAmount));
            if (this.scrollY > 0 && verticalAmount > 0.0) {
                this.scrollY = Math.max(0, this.scrollY - scrollSpeed);
            }
            if (this.canScrollDown() && verticalAmount < 0.0) {
                int totalHeightOfTheChildrens = this.getTotalHeightOfChildren();
                int viewHeight = this.height - 2 * this.spacing;
                int leftOver = totalHeightOfTheChildrens - viewHeight;
                this.scrollY = Math.min(leftOver, this.scrollY + scrollSpeed);
            }
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.scrollbarClicked = false;
        if (this.canScroll() && this.scrollbar.mouseClicked(mouseX, mouseY, button, this.scrollY)) {
            this.scrollbarClicked = true;
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.scrollbarClicked = false;
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.scrollbarClicked && this.canScroll()) {
            int totalHeightOfTheChildrens = this.getTotalHeightOfChildren();
            int scrollDelta = this.scrollbar.getScrollOffsetDelta(deltaY, totalHeightOfTheChildrens);
            if (this.scrollY > 0 && scrollDelta > 0) {
                this.scrollY = Math.max(0, this.scrollY - scrollDelta);
            }
            if (this.canScrollDown() && scrollDelta < 0) {
                int viewHeight = this.height - 2 * this.spacing;
                int leftOver = totalHeightOfTheChildrens - viewHeight;
                this.scrollY = Math.min(leftOver, this.scrollY - scrollDelta);
            }
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        return this.screenshotWidgets.stream().anyMatch(widget -> widget.method_25404(keyCode, scanCode, modifiers));
    }

    public void method_37020(class_6382 builder) {
    }

    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33784;
    }

    private static class Scrollbar {
        private final int spacing = 2;
        private final int width = 6;
        private final int trackWidth = 2;
        private int x;
        private int height;
        private int trackX;
        private int trackY;
        private int trackHeight;
        private IntUnaryOperator scrollbarYGetter;

        private Scrollbar() {
        }

        void repositionScrollbar(int listX, int listY, int listWith, int listHeight, int listSpacing, int totalHeightOfTheChildrens) {
            this.x = listX + listWith - 2 - 6;
            this.trackX = this.x + 2;
            this.trackY = listY + listSpacing;
            this.trackHeight = listHeight - 2 * listSpacing;
            int scrollbarSpacedTrackHeight = this.trackHeight + 4;
            this.scrollbarYGetter = scrollOffset -> class_3532.method_15386((float)((float)(scrollOffset * scrollbarSpacedTrackHeight) / (float)totalHeightOfTheChildrens)) + listY + 2;
            this.height = this.trackHeight * scrollbarSpacedTrackHeight / totalHeightOfTheChildrens;
        }

        void render(class_332 context, double mouseX, double mouseY, int scrollOffset, boolean updateHoverState, boolean clicked) {
            int y = this.scrollbarYGetter.applyAsInt(scrollOffset);
            context.method_25294(this.trackX, this.trackY, this.trackX + 2, this.trackY + this.trackHeight, -1);
            context.method_25294(this.x, y, this.x + 6, y + this.height, clicked ? -1 : (this.isHovered(mouseX, mouseY, y) && updateHoverState ? -9605779 : -14803426));
        }

        boolean mouseClicked(double mouseX, double mouseY, double button, int scrollOffset) {
            return button == 0.0 && this.isHovered(mouseX, mouseY, this.scrollbarYGetter.applyAsInt(scrollOffset));
        }

        int getScrollOffsetDelta(double scrollbarDelta, double totalHeightOfTheChildrens) {
            int scrollbarSpacedTrackHeight = this.trackHeight + 4;
            return class_3532.method_15384((double)(-scrollbarDelta * totalHeightOfTheChildrens / (double)scrollbarSpacedTrackHeight));
        }

        private boolean isHovered(double mouseX, double mouseY, int y) {
            return mouseX >= (double)this.x && mouseY >= (double)y && mouseX < (double)(this.x + 6) && mouseY < (double)(y + this.height);
        }
    }
}

