/*
 * Decompiled with CFR 0.152.
 */
package org.samo_lego.fabrictailor.client.screen.tabs;

import com.google.common.net.InternetDomainName;
import com.google.gson.JsonObject;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.properties.Property;
import com.mojang.datafixers.util.Pair;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.Optional;
import javax.imageio.ImageIO;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import org.samo_lego.fabrictailor.FabricTailor;
import org.samo_lego.fabrictailor.client.screen.tabs.SkinTabType;
import org.samo_lego.fabrictailor.network.SkinPackets;
import org.samo_lego.fabrictailor.util.SkinFetcher;
import org.samo_lego.fabrictailor.util.TextTranslations;

public class UrlSkinTab
implements SkinTabType {
    private final class_5250 TITLE = TextTranslations.create("tab.fabrictailor.title_url", new Object[0]);
    private final class_5250 DESCRIPTION = TextTranslations.create("description.fabrictailor.title_url", new Object[0]);
    private final class_1799 ICON = new class_1799((class_1935)class_1802.field_18674);

    public class_5250 getTitle() {
        return this.TITLE;
    }

    public class_5250 getDescription() {
        return this.DESCRIPTION;
    }

    @Override
    public class_1799 getIcon() {
        return this.ICON;
    }

    @Override
    public Optional<Pair<class_2960, class_2540>> getSkinChangePacket(class_746 player, String url, boolean useSlim) {
        class_2960 channel;
        Property skinData;
        try {
            URL skinUrl = new URL((String)url);
            BufferedImage image = ImageIO.read(skinUrl);
            int height = image.getHeight();
            int width = image.getWidth();
            if (width == 64 && (height == 32 || height == 64)) {
                skinData = SkinFetcher.fetchSkinByUrl((String)url, useSlim);
                if (skinData == null) {
                    return Optional.empty();
                }
                channel = SkinPackets.FABRICTAILOR_VANILLA_CHANGE;
            } else {
                String tld;
                JsonObject metadata = null;
                if (useSlim) {
                    metadata = new JsonObject();
                    metadata.addProperty("model", "slim");
                }
                if (!FabricTailor.config.allowedTextureDomains.contains(tld = InternetDomainName.from((String)skinUrl.getHost()).topPrivateDomain().toString())) {
                    url = "https://external-content.duckduckgo.com/iu/?u=" + skinUrl;
                }
                skinData = this.getExtendedProperty(player, MinecraftProfileTexture.Type.SKIN, (String)url, metadata);
                channel = SkinPackets.FABRICTAILOR_HD_CHANGE;
            }
        }
        catch (IOException ignored) {
            return Optional.empty();
        }
        return Optional.of(new Pair((Object)channel, (Object)SkinPackets.skin2ByteBuf(skinData)));
    }
}

