/*
 * Decompiled with CFR 0.152.
 */
package io.github.moremcmeta.emissiveplugin.mixin;

import io.github.moremcmeta.emissiveplugin.metadata.OverlayMetadata;
import io.github.moremcmeta.emissiveplugin.render.CustomRenderTypes;
import io.github.moremcmeta.emissiveplugin.render.EntityRenderingState;
import io.github.moremcmeta.moremcmeta.api.client.metadata.MetadataRegistry;
import io.github.moremcmeta.moremcmeta.api.client.texture.SpriteName;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1044;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4723;
import net.minecraft.class_630;
import org.apache.logging.log4j.LogManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_630.class})
public final class ModelPartMixin {
    private final class_310 MINECRAFT = class_310.method_1551();

    @Inject(method={"render(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;IIFFFF)V"}, at={@At(value="HEAD")})
    private void moremcmeta_emissive_onEntry(CallbackInfo callbackInfo) {
        EntityRenderingState.partRenderDepth.set(EntityRenderingState.partRenderDepth.get() + 1);
    }

    @Inject(method={"render(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;IIFFFF)V"}, at={@At(value="RETURN")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void moremcmeta_emissive_onReturn(class_4587 poseStack, class_4588 vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha, CallbackInfo callbackInfo) {
        class_630 thisPart = (class_630)this;
        if (EntityRenderingState.partRenderDepth.get() == 0) {
            Optional metadataOptional = Optional.empty();
            if (vertexConsumer instanceof class_4723) {
                class_4723 spriteVertexConsumer = (class_4723)vertexConsumer;
                location = spriteVertexConsumer.field_21731.method_45851().method_45816();
                metadataOptional = MetadataRegistry.INSTANCE.metadataFromSpriteName("moremcmeta_emissive_plugin", (class_2960)location);
            } else {
                location = EntityRenderingState.currentRenderType.get();
                if (location instanceof class_1921.class_4687) {
                    class_1921.class_4687 compositeType = (class_1921.class_4687)location;
                    if (compositeType.method_35784().field_21406.method_23564().isPresent()) {
                        location = (class_2960)compositeType.method_35784().field_21406.method_23564().get();
                        metadataOptional = MetadataRegistry.INSTANCE.metadataFromPath("moremcmeta_emissive_plugin", (class_2960)location);
                    }
                }
            }
            class_4597 bufferSource = EntityRenderingState.currentBufferSource.get();
            class_1921 lastType = EntityRenderingState.currentRenderType.get();
            if (metadataOptional.isPresent() && bufferSource != null && lastType != null) {
                OverlayMetadata overlayMetadata = (OverlayMetadata)metadataOptional.get();
                class_2960 overlay = overlayMetadata.overlaySpriteName();
                int overlayLight = overlayMetadata.isEmissive() ? 0xF000F0 : packedLight;
                Function<class_2960, class_1921> overlayType = EntityRenderingState.isBlockEntity.get() != false ? class_1921::method_23689 : CustomRenderTypes::entityTranslucentZLayering;
                class_4588 newConsumer = this.makeBuffer(bufferSource, overlay, overlayType);
                thisPart.method_22699(poseStack, newConsumer, overlayLight, packedOverlay, red, green, blue, alpha);
                bufferSource.getBuffer(lastType);
            }
        }
        EntityRenderingState.partRenderDepth.set(EntityRenderingState.partRenderDepth.get() - 1);
    }

    @Unique
    private class_4588 makeBuffer(class_4597 bufferSource, class_2960 spriteName, Function<class_2960, class_1921> renderTypeFunction) {
        class_2960 overlayLocation = SpriteName.toTexturePath((class_2960)spriteName);
        Optional<class_4588> spriteBuffer = this.makeBufferIfSprite(class_1059.field_5275, overlayLocation, spriteName, bufferSource, renderTypeFunction);
        return spriteBuffer.orElseGet(() -> bufferSource.getBuffer((class_1921)renderTypeFunction.apply(overlayLocation)));
    }

    @Unique
    private Optional<class_4588> makeBufferIfSprite(class_2960 atlasLocation, class_2960 overlayLocation, class_2960 spriteName, class_4597 bufferSource, Function<class_2960, class_1921> renderTypeFunction) {
        class_1044 abstractTexture = this.MINECRAFT.method_1531().method_4619(atlasLocation);
        if (!(abstractTexture instanceof class_1059)) {
            LogManager.getLogger().warn("Atlas {} is not a subclass of TextureAtlas; sprites from this atlas will not be used as overlays", (Object)atlasLocation);
            return Optional.empty();
        }
        class_1059 atlas = (class_1059)abstractTexture;
        class_1058 sprite = atlas.method_4608(spriteName);
        if (sprite.method_45851().method_45816().equals((Object)class_1047.method_4539())) {
            sprite = atlas.method_4608(overlayLocation);
        }
        if (!sprite.method_45851().method_45816().equals((Object)class_1047.method_4539())) {
            class_1921 renderType = renderTypeFunction.apply(atlasLocation);
            return Optional.of(sprite.method_24108(bufferSource.getBuffer(renderType)));
        }
        return Optional.empty();
    }
}

