/*
 * Decompiled with CFR 0.152.
 */
package io.github.moremcmeta.emissiveplugin.model;

import io.github.moremcmeta.emissiveplugin.ModConstants;
import io.github.moremcmeta.emissiveplugin.metadata.OverlayMetadata;
import io.github.moremcmeta.emissiveplugin.model.OverlayBakedQuad;
import io.github.moremcmeta.moremcmeta.api.client.metadata.MetadataRegistry;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1092;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_777;

public final class OverlayQuadFunction
implements Function<List<class_777>, List<OverlayBakedQuad>> {
    private final class_1092 MODEL_MANAGER = class_310.method_1551().method_1554();
    private final OverlayBakedQuad.Builder QUAD_BUILDER;

    public static float recomputeSpriteCoordinate(float coord, class_1058 oldSprite, class_1058 newSprite, Function<class_1058, Float> getCoord0, Function<class_1058, Float> getCoord1) {
        float oldCoord0 = getCoord0.apply(oldSprite).floatValue();
        float oldCoord1 = getCoord1.apply(oldSprite).floatValue();
        float proportionInSprite = (coord - oldCoord0) / (oldCoord1 - oldCoord0);
        return class_3532.method_16439((float)proportionInSprite, (float)getCoord0.apply(newSprite).floatValue(), (float)getCoord1.apply(newSprite).floatValue());
    }

    public OverlayQuadFunction(OverlayBakedQuad.Builder quadBuilder) {
        this.QUAD_BUILDER = Objects.requireNonNull(quadBuilder, "Quad builder cannot be null");
    }

    @Override
    public List<OverlayBakedQuad> apply(List<class_777> quads) {
        return quads.stream().flatMap(quad -> {
            Optional metadataOptional = MetadataRegistry.INSTANCE.metadataFromSpriteName("moremcmeta_emissive_plugin", quad.method_35788().method_45851().method_45816());
            if (metadataOptional.isEmpty()) {
                return Stream.of(new OverlayBakedQuad[0]);
            }
            OverlayMetadata metadata = (OverlayMetadata)metadataOptional.get();
            class_1058 sprite = this.MODEL_MANAGER.method_24153(class_1059.field_5275).method_4608(metadata.overlaySpriteName());
            return Stream.of(this.QUAD_BUILDER.build(OverlayQuadFunction.makeOverlayVertexData(quad.method_3357(), quad.method_3358().ordinal(), sprite, quad.method_35788(), metadata.isEmissive()), quad.method_3359(), quad.method_3358(), sprite, metadata.isEmissive(), metadata.transparencyMode()));
        }).toList();
    }

    private static int[] makeOverlayVertexData(int[] vertexData, int facing, class_1058 newSprite, class_1058 oldSprite, boolean emissive) {
        int VERTEX_SIZE = 8;
        boolean POS_X_OFFSET = false;
        boolean POS_Y_OFFSET = true;
        int POS_Z_OFFSET = 2;
        int TEX_U_OFFSET = 4;
        int TEX_V_OFFSET = 5;
        int LIGHT_OFFSET = 6;
        int[] newVertexData = new int[vertexData.length];
        System.arraycopy(vertexData, 0, newVertexData, 0, vertexData.length);
        for (int vertex = 0; vertex < 4; ++vertex) {
            int vertexOffset = vertex * 8;
            int posXOffset = vertexOffset + 0;
            int posYOffset = vertexOffset + 1;
            int posZOffset = vertexOffset + 2;
            int texUOffset = vertexOffset + 4;
            int texVOffset = vertexOffset + 5;
            newVertexData[posXOffset] = OverlayQuadFunction.recomputePos(newVertexData[posXOffset], ModConstants.X_OFFSETS[facing]);
            newVertexData[posYOffset] = OverlayQuadFunction.recomputePos(newVertexData[posYOffset], ModConstants.Y_OFFSETS[facing]);
            newVertexData[posZOffset] = OverlayQuadFunction.recomputePos(newVertexData[posZOffset], ModConstants.Z_OFFSETS[facing]);
            newVertexData[texUOffset] = OverlayQuadFunction.recomputeSpriteU(newVertexData[texUOffset], oldSprite, newSprite);
            newVertexData[texVOffset] = OverlayQuadFunction.recomputeSpriteV(newVertexData[texVOffset], oldSprite, newSprite);
            if (!emissive) continue;
            newVertexData[vertexOffset + 6] = 0xF000F0;
        }
        return newVertexData;
    }

    private static int recomputePos(int pos, float offset) {
        return Float.floatToRawIntBits(Float.intBitsToFloat(pos) + offset);
    }

    private static int recomputeSpriteU(int u, class_1058 oldSprite, class_1058 newSprite) {
        return Float.floatToRawIntBits(OverlayQuadFunction.recomputeSpriteCoordinate(Float.intBitsToFloat(u), oldSprite, newSprite, class_1058::method_4594, class_1058::method_4577));
    }

    private static int recomputeSpriteV(int v, class_1058 oldSprite, class_1058 newSprite) {
        return Float.floatToRawIntBits(OverlayQuadFunction.recomputeSpriteCoordinate(Float.intBitsToFloat(v), oldSprite, newSprite, class_1058::method_4593, class_1058::method_4575));
    }
}

