/*
 * Decompiled with CFR 0.152.
 */
package foundationgames.enhancedblockentities.client.model;

import foundationgames.enhancedblockentities.EnhancedBlockEntities;
import foundationgames.enhancedblockentities.config.EBEConfig;
import foundationgames.enhancedblockentities.util.EBEUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.minecraft.class_1767;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7923;

public final class ModelIdentifiers
implements ModelLoadingPlugin {
    private static final Map<Predicate<EBEConfig>, Set<class_2960>> modelLoaders = new HashMap<Predicate<EBEConfig>, Set<class_2960>>();
    public static final Predicate<EBEConfig> CHEST_PREDICATE = c -> c.renderEnhancedChests;
    public static final Predicate<EBEConfig> BELL_PREDICATE = c -> c.renderEnhancedBells;
    public static final Predicate<EBEConfig> SHULKER_BOX_PREDICATE = c -> c.renderEnhancedShulkerBoxes;
    public static final Predicate<EBEConfig> DECORATED_POT_PREDICATE = c -> c.renderEnhancedDecoratedPots;
    public static final class_2960 CHEST_CENTER = ModelIdentifiers.of("block/chest_center", CHEST_PREDICATE);
    public static final class_2960 CHEST_CENTER_TRUNK = ModelIdentifiers.of("block/chest_center_trunk", CHEST_PREDICATE);
    public static final class_2960 CHEST_CENTER_LID = ModelIdentifiers.of("block/chest_center_lid", CHEST_PREDICATE);
    public static final class_2960 CHEST_LEFT = ModelIdentifiers.of("block/chest_left", CHEST_PREDICATE);
    public static final class_2960 CHEST_LEFT_TRUNK = ModelIdentifiers.of("block/chest_left_trunk", CHEST_PREDICATE);
    public static final class_2960 CHEST_LEFT_LID = ModelIdentifiers.of("block/chest_left_lid", CHEST_PREDICATE);
    public static final class_2960 CHEST_RIGHT = ModelIdentifiers.of("block/chest_right", CHEST_PREDICATE);
    public static final class_2960 CHEST_RIGHT_TRUNK = ModelIdentifiers.of("block/chest_right_trunk", CHEST_PREDICATE);
    public static final class_2960 CHEST_RIGHT_LID = ModelIdentifiers.of("block/chest_right_lid", CHEST_PREDICATE);
    public static final class_2960 TRAPPED_CHEST_CENTER = ModelIdentifiers.of("block/trapped_chest_center", CHEST_PREDICATE);
    public static final class_2960 TRAPPED_CHEST_CENTER_TRUNK = ModelIdentifiers.of("block/trapped_chest_center_trunk", CHEST_PREDICATE);
    public static final class_2960 TRAPPED_CHEST_CENTER_LID = ModelIdentifiers.of("block/trapped_chest_center_lid", CHEST_PREDICATE);
    public static final class_2960 TRAPPED_CHEST_LEFT = ModelIdentifiers.of("block/trapped_chest_left", CHEST_PREDICATE);
    public static final class_2960 TRAPPED_CHEST_LEFT_TRUNK = ModelIdentifiers.of("block/trapped_chest_left_trunk", CHEST_PREDICATE);
    public static final class_2960 TRAPPED_CHEST_LEFT_LID = ModelIdentifiers.of("block/trapped_chest_left_lid", CHEST_PREDICATE);
    public static final class_2960 TRAPPED_CHEST_RIGHT = ModelIdentifiers.of("block/trapped_chest_right", CHEST_PREDICATE);
    public static final class_2960 TRAPPED_CHEST_RIGHT_TRUNK = ModelIdentifiers.of("block/trapped_chest_right_trunk", CHEST_PREDICATE);
    public static final class_2960 TRAPPED_CHEST_RIGHT_LID = ModelIdentifiers.of("block/trapped_chest_right_lid", CHEST_PREDICATE);
    public static final class_2960 CHRISTMAS_CHEST_CENTER = ModelIdentifiers.of("block/christmas_chest_center", CHEST_PREDICATE);
    public static final class_2960 CHRISTMAS_CHEST_CENTER_TRUNK = ModelIdentifiers.of("block/christmas_chest_center_trunk", CHEST_PREDICATE);
    public static final class_2960 CHRISTMAS_CHEST_CENTER_LID = ModelIdentifiers.of("block/christmas_chest_center_lid", CHEST_PREDICATE);
    public static final class_2960 CHRISTMAS_CHEST_LEFT = ModelIdentifiers.of("block/christmas_chest_left", CHEST_PREDICATE);
    public static final class_2960 CHRISTMAS_CHEST_LEFT_TRUNK = ModelIdentifiers.of("block/christmas_chest_left_trunk", CHEST_PREDICATE);
    public static final class_2960 CHRISTMAS_CHEST_LEFT_LID = ModelIdentifiers.of("block/christmas_chest_left_lid", CHEST_PREDICATE);
    public static final class_2960 CHRISTMAS_CHEST_RIGHT = ModelIdentifiers.of("block/christmas_chest_right", CHEST_PREDICATE);
    public static final class_2960 CHRISTMAS_CHEST_RIGHT_TRUNK = ModelIdentifiers.of("block/christmas_chest_right_trunk", CHEST_PREDICATE);
    public static final class_2960 CHRISTMAS_CHEST_RIGHT_LID = ModelIdentifiers.of("block/christmas_chest_right_lid", CHEST_PREDICATE);
    public static final class_2960 ENDER_CHEST_CENTER = ModelIdentifiers.of("block/ender_chest_center", CHEST_PREDICATE);
    public static final class_2960 ENDER_CHEST_CENTER_TRUNK = ModelIdentifiers.of("block/ender_chest_center_trunk", CHEST_PREDICATE);
    public static final class_2960 ENDER_CHEST_CENTER_LID = ModelIdentifiers.of("block/ender_chest_center_lid", CHEST_PREDICATE);
    public static final class_2960 BELL_BETWEEN_WALLS = ModelIdentifiers.of("block/bell_between_walls", BELL_PREDICATE);
    public static final class_2960 BELL_CEILING = ModelIdentifiers.of("block/bell_ceiling", BELL_PREDICATE);
    public static final class_2960 BELL_FLOOR = ModelIdentifiers.of("block/bell_floor", BELL_PREDICATE);
    public static final class_2960 BELL_WALL = ModelIdentifiers.of("block/bell_wall", BELL_PREDICATE);
    public static final class_2960 BELL_BETWEEN_WALLS_WITH_BELL = ModelIdentifiers.of("block/bell_between_walls_with_bell", BELL_PREDICATE);
    public static final class_2960 BELL_CEILING_WITH_BELL = ModelIdentifiers.of("block/bell_ceiling_with_bell", BELL_PREDICATE);
    public static final class_2960 BELL_FLOOR_WITH_BELL = ModelIdentifiers.of("block/bell_floor_with_bell", BELL_PREDICATE);
    public static final class_2960 BELL_WALL_WITH_BELL = ModelIdentifiers.of("block/bell_wall_with_bell", BELL_PREDICATE);
    public static final class_2960 BELL_BODY = ModelIdentifiers.of("block/bell_body", BELL_PREDICATE);
    public static final class_2960 DECORATED_POT_BASE = ModelIdentifiers.of("block/decorated_pot_base", DECORATED_POT_PREDICATE);
    public static final class_2960 DECORATED_POT_SHAKING = ModelIdentifiers.of("block/decorated_pot_shaking", DECORATED_POT_PREDICATE);
    public static final Map<class_1767, class_2960> SHULKER_BOXES = new HashMap<class_1767, class_2960>();
    public static final Map<class_1767, class_2960> SHULKER_BOX_BOTTOMS = new HashMap<class_1767, class_2960>();
    public static final Map<class_1767, class_2960> SHULKER_BOX_LIDS = new HashMap<class_1767, class_2960>();
    public static final Map<class_5321<String>, class_2960[]> POTTERY_PATTERNS = new HashMap<class_5321<String>, class_2960[]>();

    public static void init() {
        ModelLoadingPlugin.register((ModelLoadingPlugin)new ModelIdentifiers());
    }

    public static void refreshPotteryPatterns() {
        POTTERY_PATTERNS.clear();
        class_2350[] orderedHorizontalDirs = new class_2350[]{class_2350.field_11043, class_2350.field_11039, class_2350.field_11034, class_2350.field_11035};
        for (class_5321 patternKey : class_7923.field_42940.method_42021()) {
            String pattern = patternKey.method_29177().method_12832();
            class_2960[] ids = new class_2960[orderedHorizontalDirs.length];
            for (int i = 0; i < 4; ++i) {
                ids[i] = ModelIdentifiers.of("block/" + pattern + "_" + orderedHorizontalDirs[i].method_10151(), DECORATED_POT_PREDICATE);
            }
            POTTERY_PATTERNS.put((class_5321<String>)patternKey, ids);
        }
    }

    private static class_2960 of(String id, Predicate<EBEConfig> condition) {
        class_2960 idf = new class_2960(id);
        modelLoaders.computeIfAbsent(condition, k -> new HashSet()).add(idf);
        return idf;
    }

    public void onInitializeModelLoader(ModelLoadingPlugin.Context ctx) {
        EBEConfig config = EnhancedBlockEntities.CONFIG;
        for (Map.Entry<Predicate<EBEConfig>, Set<class_2960>> entry : modelLoaders.entrySet()) {
            if (!entry.getKey().test(config)) continue;
            ctx.addModels((Collection)entry.getValue());
        }
    }

    static {
        for (class_1767 color : EBEUtil.DEFAULTED_DYE_COLORS) {
            String id = color != null ? "block/" + color.method_7792() + "_shulker_box" : "block/shulker_box";
            SHULKER_BOXES.put(color, ModelIdentifiers.of(id, SHULKER_BOX_PREDICATE));
            SHULKER_BOX_BOTTOMS.put(color, ModelIdentifiers.of(id + "_bottom", SHULKER_BOX_PREDICATE));
            SHULKER_BOX_LIDS.put(color, ModelIdentifiers.of(id + "_lid", SHULKER_BOX_PREDICATE));
        }
        ModelIdentifiers.refreshPotteryPatterns();
    }
}

