/*
 * Decompiled with CFR 0.152.
 */
package io.github.moremcmeta.moremcmeta.api.client.metadata;

import com.mojang.datafixers.util.Pair;
import io.github.moremcmeta.moremcmeta.api.client.metadata.MetadataView;
import io.github.moremcmeta.moremcmeta.api.client.metadata.NegativeKeyIndexException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;

public final class CombinedMetadataView
implements MetadataView {
    private final Map<String, MetadataView> KEY_TO_VIEW;
    private final List<Pair<String, MetadataView>> INDEX_TO_VIEW;

    public CombinedMetadataView(Collection<? extends MetadataView> metadataViews) {
        Objects.requireNonNull(metadataViews, "Collection of metadata views cannot be null");
        this.KEY_TO_VIEW = new LinkedHashMap<String, MetadataView>();
        this.INDEX_TO_VIEW = new ArrayList<Pair<String, MetadataView>>();
        for (MetadataView metadataView : metadataViews) {
            Objects.requireNonNull(metadataView, "Metadata view cannot be null");
            for (String key : metadataView.keys()) {
                if (this.KEY_TO_VIEW.putIfAbsent(key, metadataView) != null) continue;
                this.INDEX_TO_VIEW.add((Pair<String, MetadataView>)Pair.of((Object)key, (Object)metadataView));
            }
        }
    }

    @Override
    public int size() {
        return this.KEY_TO_VIEW.size();
    }

    @Override
    public Iterable<String> keys() {
        return this.KEY_TO_VIEW.keySet();
    }

    @Override
    public boolean hasKey(String key) {
        return this.KEY_TO_VIEW.containsKey(key);
    }

    @Override
    public boolean hasKey(int index) {
        return this.value(index, MetadataView::hasKey, Boolean.valueOf(false));
    }

    @Override
    public Optional<String> stringValue(String key) {
        return this.value(key, (MetadataView view) -> view.stringValue(key), Optional.empty());
    }

    @Override
    public Optional<String> stringValue(int index) {
        return this.value(index, MetadataView::stringValue, Optional.empty());
    }

    @Override
    public Optional<Integer> integerValue(String key) {
        return this.value(key, (MetadataView view) -> view.integerValue(key), Optional.empty());
    }

    @Override
    public Optional<Integer> integerValue(int index) {
        return this.value(index, MetadataView::integerValue, Optional.empty());
    }

    @Override
    public Optional<Long> longValue(String key) {
        return this.value(key, (MetadataView view) -> view.longValue(key), Optional.empty());
    }

    @Override
    public Optional<Long> longValue(int index) {
        return this.value(index, MetadataView::longValue, Optional.empty());
    }

    @Override
    public Optional<Float> floatValue(String key) {
        return this.value(key, (MetadataView view) -> view.floatValue(key), Optional.empty());
    }

    @Override
    public Optional<Float> floatValue(int index) {
        return this.value(index, MetadataView::floatValue, Optional.empty());
    }

    @Override
    public Optional<Double> doubleValue(String key) {
        return this.value(key, (MetadataView view) -> view.doubleValue(key), Optional.empty());
    }

    @Override
    public Optional<Double> doubleValue(int index) {
        return this.value(index, MetadataView::doubleValue, Optional.empty());
    }

    @Override
    public Optional<Boolean> booleanValue(String key) {
        return this.value(key, (MetadataView view) -> view.booleanValue(key), Optional.empty());
    }

    @Override
    public Optional<Boolean> booleanValue(int index) {
        return this.value(index, MetadataView::booleanValue, Optional.empty());
    }

    @Override
    public Optional<InputStream> byteStreamValue(String key) {
        return this.value(key, (MetadataView view) -> view.byteStreamValue(key), Optional.empty());
    }

    @Override
    public Optional<InputStream> byteStreamValue(int index) {
        return this.value(index, MetadataView::byteStreamValue, Optional.empty());
    }

    @Override
    public Optional<MetadataView> subView(String key) {
        return this.value(key, (MetadataView view) -> view.subView(key), Optional.empty());
    }

    @Override
    public Optional<MetadataView> subView(int index) {
        return this.value(index, MetadataView::subView, Optional.empty());
    }

    private <T> T value(String key, Function<MetadataView, T> valueGetter, T defaultValue) {
        MetadataView view = this.KEY_TO_VIEW.get(key);
        if (view == null) {
            return defaultValue;
        }
        return valueGetter.apply(view);
    }

    private <T> T value(int index, BiFunction<MetadataView, String, T> valueGetter, T defaultValue) {
        if (index < 0) {
            throw new NegativeKeyIndexException(index);
        }
        if (index >= this.size()) {
            return defaultValue;
        }
        Pair<String, MetadataView> keyAndView = this.INDEX_TO_VIEW.get(index);
        return valueGetter.apply((MetadataView)keyAndView.getSecond(), (String)keyAndView.getFirst());
    }
}

