/*
 * Decompiled with CFR 0.152.
 */
package io.github.moremcmeta.moremcmeta.api.math;

import com.google.common.collect.ImmutableList;
import io.github.moremcmeta.moremcmeta.api.math.NegativeDimensionException;
import io.github.moremcmeta.moremcmeta.api.math.Point;
import io.github.moremcmeta.moremcmeta.api.math.RectangleOverflowException;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectRBTreeMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectSortedMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongImmutableList;
import it.unimi.dsi.fastutil.longs.LongIterable;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongIterators;
import it.unimi.dsi.fastutil.longs.LongList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public final class Area
implements LongIterable {
    private final Int2ObjectSortedMap<LongList> ROWS;
    private final int SIZE;

    public static Area of(long ... points) {
        Builder builder = new Builder();
        for (long point : points) {
            builder.addPixel(Point.x(point), Point.y(point));
        }
        return builder.build();
    }

    public static Area of(Iterable<Long> points) {
        Builder builder = new Builder();
        for (long point : points) {
            builder.addPixel(Point.x(point), Point.y(point));
        }
        return builder.build();
    }

    public Area(int topLeftX, int topLeftY, int width, int height) {
        if (width < 0) {
            throw new NegativeDimensionException(width);
        }
        if (height < 0) {
            throw new NegativeDimensionException(height);
        }
        if (Integer.MAX_VALUE - width < topLeftX || Integer.MAX_VALUE - height < topLeftY) {
            throw new RectangleOverflowException(topLeftX, topLeftY, width, height);
        }
        this.ROWS = new Int2ObjectRBTreeMap();
        this.SIZE = width * height;
        if (width > 0) {
            for (int y = topLeftY; y < topLeftY + height; ++y) {
                this.ROWS.put(y, (Object)new LongImmutableList((Collection)ImmutableList.of((Object)Point.pack(topLeftX, width))));
            }
        }
    }

    @NotNull
    public LongIterator iterator() {
        return new PointIterator();
    }

    public int size() {
        return this.SIZE;
    }

    public Collection<Area> split(int sizeHint) {
        if (sizeHint < 0) {
            throw new NegativeDimensionException(sizeHint);
        }
        ArrayDeque<Int2ObjectRBTreeMap> buckets = new ArrayDeque<Int2ObjectRBTreeMap>(this.SIZE / Math.max(sizeHint, 1) + 1);
        buckets.add(new Int2ObjectRBTreeMap());
        int currentSize = 0;
        ArrayList<Area> resultAreas = new ArrayList<Area>();
        Iterator rowIterator = this.ROWS.int2ObjectEntrySet().stream().iterator();
        while (rowIterator.hasNext()) {
            Int2ObjectMap.Entry row = (Int2ObjectMap.Entry)rowIterator.next();
            LongIterator segmentIterator = ((LongList)row.getValue()).longIterator();
            while (segmentIterator.hasNext()) {
                long segment = segmentIterator.nextLong();
                Int2ObjectSortedMap bucket = (Int2ObjectSortedMap)buckets.peekLast();
                ((LongList)bucket.computeIfAbsent(row.getIntKey(), key -> new LongArrayList())).add(segment);
                if ((currentSize += Point.y(segment)) < sizeHint && (rowIterator.hasNext() || segmentIterator.hasNext())) continue;
                resultAreas.add(new Area((Int2ObjectSortedMap<LongList>)bucket, currentSize));
                buckets.add(new Int2ObjectRBTreeMap());
                currentSize = 0;
            }
        }
        return resultAreas;
    }

    private Area(Int2ObjectSortedMap<LongList> rows, int size) {
        this.ROWS = rows;
        this.SIZE = size;
    }

    public static final class Builder {
        private final Int2ObjectSortedMap<IntList> ROWS = new Int2ObjectRBTreeMap();

        public void addPixel(int x, int y) {
            if (!this.ROWS.containsKey(y)) {
                this.ROWS.put(y, (Object)new IntArrayList());
            }
            ((IntList)this.ROWS.get(y)).add(x);
        }

        public void addPixel(long point) {
            this.addPixel(Point.x(point), Point.y(point));
        }

        public Area build() {
            Int2ObjectRBTreeMap rows = new Int2ObjectRBTreeMap();
            int size = 0;
            for (Int2ObjectMap.Entry entry : this.ROWS.int2ObjectEntrySet()) {
                IntList xPoints = (IntList)entry.getValue();
                xPoints.sort(Integer::compare);
                int numPoints = xPoints.size();
                int startIndex = 0;
                for (int pointIndex = 0; pointIndex < numPoints; ++pointIndex) {
                    boolean isRowEnd;
                    int nextIndex = pointIndex + 1;
                    boolean isLastPoint = pointIndex == numPoints - 1;
                    boolean bl = isRowEnd = isLastPoint || xPoints.getInt(nextIndex) - xPoints.getInt(pointIndex) > 1;
                    if (!isRowEnd) continue;
                    int width = pointIndex - startIndex + 1;
                    size += width;
                    int y = entry.getIntKey();
                    ((LongList)rows.computeIfAbsent(y, key -> new LongArrayList())).add(Point.pack(xPoints.getInt(startIndex), width));
                    startIndex = nextIndex;
                }
            }
            return new Area((Int2ObjectSortedMap<LongList>)rows, size);
        }
    }

    private class PointIterator
    implements LongIterator {
        private final Iterator<Int2ObjectMap.Entry<LongList>> ROW_ITERATOR;
        private int currentRowY;
        private LongIterator segmentIterator;
        private int currentSegmentX;
        private int currentSegmentWidth;
        private int pixelCount;

        public PointIterator() {
            this.ROW_ITERATOR = Area.this.ROWS.int2ObjectEntrySet().iterator();
            this.segmentIterator = LongIterators.EMPTY_ITERATOR;
        }

        public boolean hasNext() {
            return this.ROW_ITERATOR.hasNext() || this.segmentIterator.hasNext() || this.pixelCount < this.currentSegmentWidth;
        }

        public long nextLong() {
            boolean atSegmentEnd;
            boolean bl = atSegmentEnd = this.pixelCount == this.currentSegmentWidth;
            if (atSegmentEnd && !this.segmentIterator.hasNext()) {
                Int2ObjectMap.Entry<LongList> currentRow = this.ROW_ITERATOR.next();
                this.segmentIterator = ((LongList)currentRow.getValue()).iterator();
                this.currentRowY = currentRow.getIntKey();
            }
            if (atSegmentEnd) {
                long currentSegment = this.segmentIterator.nextLong();
                this.currentSegmentX = Point.x(currentSegment);
                this.currentSegmentWidth = Point.y(currentSegment);
                this.pixelCount = 0;
            }
            ++this.pixelCount;
            return Point.pack(this.currentSegmentX + this.pixelCount - 1, this.currentRowY);
        }
    }
}

