/*
 * Decompiled with CFR 0.152.
 */
package io.github.moremcmeta.moremcmeta.impl.client;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import io.github.moremcmeta.moremcmeta.api.client.ClientPlugin;
import io.github.moremcmeta.moremcmeta.api.client.ConflictingPluginsException;
import io.github.moremcmeta.moremcmeta.api.client.InvalidPluginException;
import io.github.moremcmeta.moremcmeta.api.client.MoreMcmetaMetadataParserPlugin;
import io.github.moremcmeta.moremcmeta.api.client.MoreMcmetaTexturePlugin;
import io.github.moremcmeta.moremcmeta.api.client.metadata.MetadataParser;
import io.github.moremcmeta.moremcmeta.impl.client.adapter.AtlasAdapter;
import io.github.moremcmeta.moremcmeta.impl.client.adapter.NativeImageAdapter;
import io.github.moremcmeta.moremcmeta.impl.client.adapter.PackResourcesAdapter;
import io.github.moremcmeta.moremcmeta.impl.client.adapter.RootResourcesAdapter;
import io.github.moremcmeta.moremcmeta.impl.client.adapter.TextureManagerAdapter;
import io.github.moremcmeta.moremcmeta.impl.client.io.TextureData;
import io.github.moremcmeta.moremcmeta.impl.client.io.TextureDataAssembler;
import io.github.moremcmeta.moremcmeta.impl.client.io.TextureDataReader;
import io.github.moremcmeta.moremcmeta.impl.client.mixin.TextureManagerAccessor;
import io.github.moremcmeta.moremcmeta.impl.client.resource.MetadataRegistryImpl;
import io.github.moremcmeta.moremcmeta.impl.client.resource.ModRepositorySource;
import io.github.moremcmeta.moremcmeta.impl.client.resource.OrderedResourceRepository;
import io.github.moremcmeta.moremcmeta.impl.client.resource.SpriteFrameSizeFixPack;
import io.github.moremcmeta.moremcmeta.impl.client.resource.StagedResourceReloadListener;
import io.github.moremcmeta.moremcmeta.impl.client.resource.StreamSource;
import io.github.moremcmeta.moremcmeta.impl.client.resource.TextureCache;
import io.github.moremcmeta.moremcmeta.impl.client.resource.TextureLoader;
import io.github.moremcmeta.moremcmeta.impl.client.texture.BaseCollection;
import io.github.moremcmeta.moremcmeta.impl.client.texture.EventDrivenTexture;
import io.github.moremcmeta.moremcmeta.impl.client.texture.SpriteFinder;
import io.github.moremcmeta.moremcmeta.impl.client.texture.TextureManagerWrapper;
import io.github.moremcmeta.moremcmeta.impl.client.texture.TexturePreparer;
import io.github.moremcmeta.moremcmeta.impl.client.texture.UploadComponent;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1011;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1060;
import net.minecraft.class_155;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3283;
import net.minecraft.class_3285;
import net.minecraft.class_3288;
import net.minecraft.class_3300;
import net.minecraft.class_3304;
import net.minecraft.class_3695;
import net.minecraft.class_4011;
import net.minecraft.class_4071;
import net.minecraft.class_425;
import net.minecraft.class_4725;
import net.minecraft.class_6328;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public abstract class MoreMcmeta {
    public static final String MODID = "moremcmeta";
    public static final MetadataRegistryImpl METADATA_REGISTRY = new MetadataRegistryImpl();
    private static ImmutableMap<class_2960, ImmutableSet<class_2960>> dependencies = ImmutableMap.of();
    private final Set<String> DEFAULT_PLUGINS = Set.of("moremcmeta_texture_plugin", "moremcmeta_animation_plugin", "moremcmeta_gui_plugin", "moremcmeta_properties_parser_plugin", "moremcmeta_moremcmeta_parser_plugin");

    public static Set<class_2960> dependencies(class_2960 baseName) {
        Objects.requireNonNull(baseName, "Base name cannot be null");
        return (Set)dependencies.getOrDefault((Object)baseName, (Object)ImmutableSet.of());
    }

    public void start() throws InvalidPluginException, ConflictingPluginsException {
        class_310 minecraft = class_310.method_1551();
        Logger logger = LogManager.getLogger();
        Pair<Collection<MoreMcmetaTexturePlugin>, Collection<MoreMcmetaMetadataParserPlugin>> plugins = this.dividePlugins(this.fetchTexturePlugins(logger));
        Collection<MoreMcmetaTexturePlugin> texturePlugins = (Collection<MoreMcmetaTexturePlugin>)plugins.getFirst();
        this.validateIndividualTexturePlugins(texturePlugins);
        texturePlugins = this.removeOverriddenPlugins(texturePlugins, MoreMcmetaTexturePlugin::sectionName, this.DEFAULT_PLUGINS, logger);
        this.checkItemConflict(texturePlugins, MoreMcmetaTexturePlugin::sectionName, "section name");
        Collection<MoreMcmetaMetadataParserPlugin> parserPlugins = (Collection<MoreMcmetaMetadataParserPlugin>)plugins.getSecond();
        this.validateIndividualParserPlugins(parserPlugins);
        parserPlugins = this.removeOverriddenPlugins(parserPlugins, MoreMcmetaMetadataParserPlugin::extension, this.DEFAULT_PLUGINS, logger);
        this.checkItemConflict(parserPlugins, MoreMcmetaMetadataParserPlugin::extension, "extension");
        List<ClientPlugin> allPlugins = Stream.concat(texturePlugins.stream(), parserPlugins.stream()).toList();
        this.checkItemConflict(allPlugins, ClientPlugin::id, "id");
        this.logPluginList(allPlugins, logger);
        TextureManagerWrapper<EventDrivenTexture> manager = new TextureManagerWrapper<EventDrivenTexture>(new TextureManagerAdapter(() -> ((class_310)minecraft).method_1531(), this.unregisterAction()));
        TextureDataReader<NativeImageAdapter> reader = new TextureDataReader<NativeImageAdapter>(texturePlugins, stream -> new NativeImageAdapter(class_1011.method_4309((InputStream)stream), 0, false, false), (image, blur, clamp) -> new NativeImageAdapter(image.image(), image.mipmapLevel(), blur, clamp));
        TextureLoader<NativeImageAdapter> loader = new TextureLoader<NativeImageAdapter>(reader, this.parsersByExtension(parserPlugins), logger);
        final TextureCache cache = new TextureCache(loader);
        this.onResourceManagerInitialized(client -> {
            class_3300 patt9611$temp = client.method_1478();
            if (!(patt9611$temp instanceof class_3304)) {
                logger.error("Reload listener was not added because resource manager is not reloadable");
                return;
            }
            class_3304 rscManager = (class_3304)patt9611$temp;
            final class_3283 packRepository = client.method_1520();
            final Supplier<List<String>> packIdGetter = () -> packRepository.method_14444().stream().map(class_3288::method_14463).toList();
            final int packVersion = class_155.method_16673().method_48017(class_3264.field_14188);
            ModRepositorySource source = new ModRepositorySource(new class_3288.class_7680(){

                @NotNull
                public class_3262 method_52424(String packId) {
                    OrderedResourceRepository repository = MoreMcmeta.this.makeResourceRepository(packRepository);
                    List currentPackIds = (List)packIdGetter.get();
                    cache.load(repository, currentPackIds, "textures", "optifine");
                    METADATA_REGISTRY.set((Map<? extends class_2960, ? extends TextureData<?>>)cache.get(currentPackIds));
                    class_2960 packIcon = new class_2960(MoreMcmeta.MODID, "pack.png");
                    return new SpriteFrameSizeFixPack((Map<? extends class_2960, ? extends TextureData<?>>)cache.get(currentPackIds), (Map<? extends String, ? extends StreamSource>)ImmutableMap.of((Object)"pack.png", () -> repository.firstCollectionWith(packIcon).collection().find(class_3264.field_14188, packIcon), (Object)"pack.mcmeta", () -> MoreMcmeta.this.makePackMetadataStream(packVersion, "Used by the MoreMcmeta mod. Cannot be moved.")));
                }

                @NotNull
                public class_3262 method_52425(String packId, class_3288.class_7679 info) {
                    return this.method_52424(packId);
                }
            });
            this.addRepositorySource(packRepository, source);
            rscManager.method_14477(this.wrapListener(new TextureResourceReloadListener(manager, this.preparer(), cache, packIdGetter, logger)));
            logger.debug("Added texture reload listener");
        });
        this.startTicking(manager);
    }

    protected abstract Collection<ClientPlugin> fetchTexturePlugins(Logger var1);

    protected abstract ToIntFunction<class_1058> mipmapLevelGetter(Logger var1);

    protected abstract TexturePreparer preparer();

    protected abstract BiConsumer<class_1060, class_2960> unregisterAction();

    protected abstract void onResourceManagerInitialized(Consumer<class_310> var1);

    protected abstract void addRepositorySource(class_3283 var1, class_3285 var2);

    protected abstract StagedResourceReloadListener<Map<class_2960, EventDrivenTexture.Builder>> wrapListener(StagedResourceReloadListener<Map<class_2960, EventDrivenTexture.Builder>> var1);

    protected abstract Optional<class_4011> reloadInstance(class_425 var1, Logger var2);

    protected abstract void startTicking(TextureManagerWrapper<EventDrivenTexture> var1);

    private Pair<Collection<MoreMcmetaTexturePlugin>, Collection<MoreMcmetaMetadataParserPlugin>> dividePlugins(Collection<ClientPlugin> plugins) {
        ArrayList<MoreMcmetaTexturePlugin> texturePlugins = new ArrayList<MoreMcmetaTexturePlugin>();
        ArrayList<MoreMcmetaMetadataParserPlugin> parserPlugins = new ArrayList<MoreMcmetaMetadataParserPlugin>();
        for (ClientPlugin plugin : plugins) {
            if (plugin instanceof MoreMcmetaTexturePlugin) {
                texturePlugins.add((MoreMcmetaTexturePlugin)plugin);
            }
            if (!(plugin instanceof MoreMcmetaMetadataParserPlugin)) continue;
            parserPlugins.add((MoreMcmetaMetadataParserPlugin)plugin);
        }
        return Pair.of(texturePlugins, parserPlugins);
    }

    private <P extends ClientPlugin, T> Collection<P> removeOverriddenPlugins(Collection<P> plugins, Function<P, T> itemRetriever, Set<String> defaultPluginIds, Logger logger) {
        Map countBySection = plugins.stream().collect(Collectors.groupingBy(itemRetriever, Collectors.counting()));
        HashSet results = new HashSet();
        plugins.forEach(plugin -> {
            Object item = itemRetriever.apply(plugin);
            String id = plugin.id();
            if ((Long)countBySection.get(item) > 1L && defaultPluginIds.contains(id)) {
                logger.info("Disabled default plugin {} as a replacement plugin was provided", (Object)plugin.id());
            } else {
                results.add(plugin);
            }
        });
        return results;
    }

    private void validateIndividualTexturePlugins(Collection<MoreMcmetaTexturePlugin> plugins) throws InvalidPluginException {
        for (MoreMcmetaTexturePlugin plugin : plugins) {
            this.requirePluginItem(plugin.id(), "id", plugin.id());
            this.validateId(plugin.id());
            this.requirePluginItem(plugin.sectionName(), "section name", plugin.id());
            this.requirePluginItem(plugin.analyzer(), "analyzer", plugin.id());
            this.requirePluginItem(plugin.componentBuilder(), "component builder", plugin.id());
        }
    }

    private void validateIndividualParserPlugins(Collection<MoreMcmetaMetadataParserPlugin> plugins) throws InvalidPluginException {
        for (MoreMcmetaMetadataParserPlugin plugin : plugins) {
            this.requirePluginItem(plugin.id(), "id", plugin.id());
            this.validateId(plugin.id());
            String extension = plugin.extension();
            this.requirePluginItem(extension, "extension", plugin.id());
            String regex = "[a-z0-9_-]+";
            if (!extension.matches(regex)) {
                throw new InvalidPluginException("Extension must match " + regex);
            }
            if (extension.equals("mcmeta")) {
                throw new InvalidPluginException("Implementing .mcmeta parser extensions is not allowed due to the way Minecraft implements resource packs");
            }
            if (extension.isEmpty()) {
                throw new InvalidPluginException("Extension cannot be empty");
            }
            this.requirePluginItem(plugin.metadataParser(), "metadata analyzer", plugin.id());
        }
    }

    private void requirePluginItem(Object item, String itemName, String pluginId) throws InvalidPluginException {
        if (item == null) {
            throw new InvalidPluginException("Plugin " + pluginId + " is missing " + itemName);
        }
    }

    private void validateId(String id) throws InvalidPluginException {
        String regex = "[a-z0-9_.-]+";
        if (!id.matches(regex)) {
            throw new InvalidPluginException("Plugin ID must match " + regex + ", but was: " + id);
        }
    }

    private <P extends ClientPlugin, T> void checkItemConflict(Collection<P> plugins, Function<P, T> propertyAccessor, String propertyName) throws ConflictingPluginsException {
        Map<T, List<P>> pluginsByProperty = plugins.stream().collect(Collectors.groupingBy(propertyAccessor));
        Optional<Map.Entry> conflictingPlugins = pluginsByProperty.entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).findFirst();
        if (conflictingPlugins.isEmpty()) {
            return;
        }
        Object conflictingProperty = conflictingPlugins.get().getKey();
        List<String> conflictingIds = ((List)conflictingPlugins.get().getValue()).stream().map(ClientPlugin::id).toList();
        throw new ConflictingPluginsException("Plugins " + conflictingIds + " have conflicting " + propertyName + ": " + conflictingProperty);
    }

    private ImmutableMap<String, MetadataParser> parsersByExtension(Iterable<MoreMcmetaMetadataParserPlugin> parserPlugins) {
        ImmutableMap.Builder analyzers = new ImmutableMap.Builder();
        for (MoreMcmetaMetadataParserPlugin plugin : parserPlugins) {
            analyzers.put((Object)("." + plugin.extension()), (Object)plugin.metadataParser());
        }
        return analyzers.build();
    }

    private void logPluginList(Collection<ClientPlugin> plugins, Logger logger) {
        String pluginList = plugins.stream().map(plugin -> "\n\t- " + plugin.id()).collect(Collectors.joining());
        logger.info(String.format("Loading %s MoreMcmeta plugins:", plugins.size()) + pluginList);
    }

    private OrderedResourceRepository makeResourceRepository(class_3283 packRepository) {
        ArrayList<PackResourcesAdapter> packs = new ArrayList<PackResourcesAdapter>(packRepository.method_14444().stream().filter(pack -> !pack.method_14463().equals("__moremcmeta-internal__")).map(class_3288::method_14458).map(PackResourcesAdapter::new).toList());
        Collections.reverse(packs);
        Collection selectedIds = packRepository.method_29210();
        packRepository.method_14441().stream().filter(pack -> !selectedIds.contains(pack.method_14463())).map(class_3288::method_14458).map(RootResourcesAdapter::new).forEach(packs::add);
        return new OrderedResourceRepository(class_3264.field_14188, packs);
    }

    private InputStream makePackMetadataStream(int version, String description) {
        return new ByteArrayInputStream(String.format("{ \"pack\": { \"pack_format\": %s, \"description\": \"%s\"} }", version, description).getBytes(StandardCharsets.UTF_8));
    }

    private Optional<class_425> loadingOverlay(Logger logger) {
        class_4071 currentOverlay = class_310.method_1551().method_18506();
        if (!(currentOverlay instanceof class_425)) {
            logger.error("Loading overlay expected. Textures will not be finished!");
            return Optional.empty();
        }
        return Optional.of((class_425)currentOverlay);
    }

    private void addCompletedReloadCallback(TextureManagerWrapper<EventDrivenTexture> manager, TexturePreparer preparer, Map<class_2960, EventDrivenTexture.Builder> textures, Logger logger) {
        Optional<class_425> overlay = this.loadingOverlay(logger);
        if (overlay.isEmpty()) {
            return;
        }
        HashMap dependencies = new HashMap();
        Optional<class_4011> reloadInstance = this.reloadInstance(overlay.get(), logger);
        reloadInstance.ifPresent(instance -> instance.method_18364().thenRun(() -> {
            TextureManagerAccessor textureManager = (TextureManagerAccessor)class_310.method_1551().method_1531();
            SpriteFinder spriteFinder = new SpriteFinder(loc -> new AtlasAdapter((class_2960)loc, this.mipmapLevelGetter(logger)), textureManager.moremcmeta_byPath().entrySet().stream().filter(entry -> entry.getValue() instanceof class_1059).map(Map.Entry::getKey).collect(Collectors.toSet()));
            textures.forEach((location, builder) -> {
                BaseCollection allBases = BaseCollection.find(spriteFinder, location);
                allBases.baseNames().forEach(base -> dependencies.computeIfAbsent(base, loc -> new ImmutableSet.Builder()).add(location));
                UploadComponent uploadComponent = new UploadComponent(preparer, allBases);
                builder.add(uploadComponent);
                manager.register((class_2960)location, builder.build());
            });
            MoreMcmeta.dependencies = ImmutableMap.copyOf((Map)Maps.transformValues((Map)dependencies, ImmutableSet.Builder::build));
            AtlasAdapter.clearNameMappings();
        }));
    }

    @class_6328
    private class TextureResourceReloadListener
    implements StagedResourceReloadListener<Map<class_2960, EventDrivenTexture.Builder>> {
        private final Map<class_2960, EventDrivenTexture.Builder> LAST_TEXTURES_ADDED = new HashMap<class_2960, EventDrivenTexture.Builder>();
        private final TextureManagerWrapper<EventDrivenTexture> TEX_MANAGER;
        private final TexturePreparer PREPARER;
        private final TextureCache<TextureData<NativeImageAdapter>, List<String>> CACHE;
        private final Supplier<List<String>> PACK_ID_GETTER;
        private final Logger LOGGER;

        public TextureResourceReloadListener(TextureManagerWrapper<EventDrivenTexture> texManager, TexturePreparer preparer, TextureCache<TextureData<NativeImageAdapter>, List<String>> cache, Supplier<List<String>> packIdGetter, Logger logger) {
            this.TEX_MANAGER = Objects.requireNonNull(texManager, "Texture manager cannot be null");
            this.PREPARER = Objects.requireNonNull(preparer, "Preparer cannot be null");
            this.CACHE = Objects.requireNonNull(cache, "Cache cannot be null");
            this.PACK_ID_GETTER = Objects.requireNonNull(packIdGetter, "Pack ID getter cannot be null");
            this.LOGGER = Objects.requireNonNull(logger, "Logger cannot be null");
        }

        @Override
        public CompletableFuture<Map<class_2960, EventDrivenTexture.Builder>> load(class_3300 manager, class_3695 loadProfiler, Executor loadExecutor) {
            Objects.requireNonNull(manager, "Resource manager cannot be null");
            Objects.requireNonNull(loadProfiler, "Profiler cannot be null");
            Objects.requireNonNull(loadExecutor, "Executor cannot be null");
            TextureDataAssembler<NativeImageAdapter> assembler = new TextureDataAssembler<NativeImageAdapter>((width, height, mipmapLevel, blur, clamp) -> {
                class_1011 image = new class_1011(width, height, true);
                return new NativeImageAdapter(image, mipmapLevel, blur, clamp);
            }, (image, mipmap) -> {
                int maxMipmapSettings = (Integer)class_310.method_1551().field_1690.method_42563().method_41753();
                int maxMipmap = Math.min(maxMipmapSettings, mipmap);
                class_1011[] mipmaps = class_4725.method_24102((class_1011[])new class_1011[]{image.image()}, (int)maxMipmap);
                ArrayList<NativeImageAdapter> wrappedMipmaps = new ArrayList<NativeImageAdapter>();
                for (int level = 0; level < mipmaps.length; ++level) {
                    wrappedMipmaps.add(new NativeImageAdapter(mipmaps[level], level, image.blur(), image.clamp()));
                }
                return wrappedMipmaps;
            });
            return CompletableFuture.supplyAsync(() -> ((Stream)this.CACHE.get(this.PACK_ID_GETTER.get()).entrySet().stream().parallel()).collect(Collectors.toMap(Map.Entry::getKey, entry -> assembler.assemble((TextureData)entry.getValue()))), loadExecutor);
        }

        @Override
        public CompletableFuture<Void> apply(Map<class_2960, EventDrivenTexture.Builder> data, class_3300 manager, class_3695 applyProfiler, Executor applyExecutor) {
            Objects.requireNonNull(data, "Data cannot be null");
            Objects.requireNonNull(manager, "Resource manager cannot be null");
            Objects.requireNonNull(applyProfiler, "Profiler cannot be null");
            Objects.requireNonNull(applyExecutor, "Executor cannot be null");
            MoreMcmeta.this.addCompletedReloadCallback(this.TEX_MANAGER, this.PREPARER, this.LAST_TEXTURES_ADDED, this.LOGGER);
            return CompletableFuture.runAsync(() -> {
                OrderedResourceRepository repository = MoreMcmeta.this.makeResourceRepository(class_310.method_1551().method_1520());
                this.CACHE.load(repository, (List<String>)ImmutableList.of(), new String[0]);
                this.LAST_TEXTURES_ADDED.keySet().forEach(this.TEX_MANAGER::unregister);
                this.LAST_TEXTURES_ADDED.clear();
                this.LAST_TEXTURES_ADDED.putAll(data.entrySet().stream().collect(Collectors.toMap(entry -> RootResourcesAdapter.locateForPackScreen((class_2960)entry.getKey()), Map.Entry::getValue)));
                this.LAST_TEXTURES_ADDED.keySet().forEach(this.TEX_MANAGER::unregister);
            }, applyExecutor);
        }
    }
}

