/*
 * Decompiled with CFR 0.152.
 */
package io.github.moremcmeta.emissiveplugin.metadata;

import io.github.moremcmeta.emissiveplugin.metadata.OverlayMetadata;
import io.github.moremcmeta.emissiveplugin.metadata.TransparencyMode;
import io.github.moremcmeta.moremcmeta.api.client.metadata.AnalyzedMetadata;
import io.github.moremcmeta.moremcmeta.api.client.metadata.InvalidMetadataException;
import io.github.moremcmeta.moremcmeta.api.client.metadata.MetadataAnalyzer;
import io.github.moremcmeta.moremcmeta.api.client.metadata.MetadataView;
import io.github.moremcmeta.moremcmeta.api.client.texture.SpriteName;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_2960;

public final class OverlayMetadataAnalyzer
implements MetadataAnalyzer {
    public AnalyzedMetadata analyze(MetadataView metadata, int imageWidth, int imageHeight) throws InvalidMetadataException {
        TransparencyMode transparencyMode;
        Objects.requireNonNull(metadata, "Metadata cannot be null");
        Optional rawOverlayLocation = metadata.stringValue("texture");
        if (rawOverlayLocation.isEmpty()) {
            throw new InvalidMetadataException("Overlays must have a texture defined");
        }
        class_2960 overlayLocation = class_2960.method_12829((String)((String)rawOverlayLocation.get()));
        if (overlayLocation == null) {
            throw new InvalidMetadataException("Non [a-z0-9_.-] character in overlay texture location");
        }
        boolean isEmissive = metadata.booleanValue("emissive").orElse(false);
        String rawTransparencyMode = metadata.stringValue("transparency").orElse("auto");
        if (rawTransparencyMode.equals("auto")) {
            transparencyMode = TransparencyMode.AUTO;
        } else if (rawTransparencyMode.equals("translucent")) {
            transparencyMode = TransparencyMode.TRANSLUCENT;
        } else {
            throw new InvalidMetadataException("Unknown transparency: " + rawTransparencyMode);
        }
        return new OverlayMetadata(SpriteName.fromTexturePath((class_2960)overlayLocation), isEmissive, transparencyMode);
    }
}

