/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.animation;

import it.unimi.dsi.fastutil.floats.FloatConsumer;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.UUID;
import net.minecraft.class_630;
import org.jetbrains.annotations.NotNull;
import traben.entity_model_features.models.EMFModelPart;
import traben.entity_model_features.models.animation.EMFAnimationEntityContext;
import traben.entity_model_features.models.animation.math.MathComponent;
import traben.entity_model_features.models.animation.math.MathExpressionParser;
import traben.entity_model_features.models.animation.math.MathValue;
import traben.entity_model_features.models.animation.math.variables.EMFModelOrRenderVariable;
import traben.entity_model_features.models.animation.math.variables.factories.GlobalVariableFactory;

public class EMFAnimation {
    public final String animKey;
    public final String expressionString;
    public final String modelName;
    private final EMFModelPart partToApplyTo;
    private final EMFModelOrRenderVariable modelOrRenderVariableToChange;
    private final Object2FloatOpenHashMap<UUID> prevResult = new Object2FloatOpenHashMap();
    private final FloatConsumer variableResultConsumer;
    private final float defaultValue;
    public Object2ObjectLinkedOpenHashMap<String, EMFAnimation> temp_emfAnimationVariables = null;
    public Object2ObjectOpenHashMap<String, EMFModelPart> temp_allPartsBySingleAndFullHeirachicalId = null;
    @NotNull
    private MathComponent emfCalculator = MathExpressionParser.NULL_EXPRESSION;

    public EMFAnimation(EMFModelPart partToApplyTo, EMFModelOrRenderVariable modelOrRenderVariableToChange, String animKey, String initialExpression, String modelName) {
        boolean animKeyIsBoolean;
        this.modelName = modelName;
        this.animKey = animKey;
        boolean bl = animKeyIsBoolean = animKey.startsWith("global_varb") || animKey.startsWith("varb");
        this.variableResultConsumer = animKey.startsWith("global_var") ? (animKeyIsBoolean ? value -> GlobalVariableFactory.setGlobalVariable(animKey, MathValue.isBoolean(value) ? value : Float.NEGATIVE_INFINITY) : value -> GlobalVariableFactory.setGlobalVariable(animKey, MathValue.isBoolean(value) ? 0.0f : value)) : (animKey.startsWith("var") ? (animKeyIsBoolean ? value -> EMFAnimationEntityContext.setEntityVariable(animKey, MathValue.isBoolean(value) ? value : Float.NEGATIVE_INFINITY) : value -> EMFAnimationEntityContext.setEntityVariable(animKey, MathValue.isBoolean(value) ? 0.0f : value)) : null);
        this.modelOrRenderVariableToChange = this.isVar() ? null : modelOrRenderVariableToChange;
        this.partToApplyTo = partToApplyTo;
        this.defaultValue = animKeyIsBoolean || modelOrRenderVariableToChange != null && modelOrRenderVariableToChange.isBoolean() ? Float.NEGATIVE_INFINITY : 0.0f;
        this.prevResult.defaultReturnValue(this.defaultValue);
        this.expressionString = initialExpression;
    }

    public boolean isVar() {
        return this.variableResultConsumer != null;
    }

    public String toString() {
        return this.animKey;
    }

    public void initExpression(Object2ObjectLinkedOpenHashMap<String, EMFAnimation> emfAnimationVariables, Object2ObjectOpenHashMap<String, EMFModelPart> allPartByName) {
        this.temp_emfAnimationVariables = emfAnimationVariables;
        this.temp_allPartsBySingleAndFullHeirachicalId = allPartByName;
        this.emfCalculator = MathExpressionParser.getOptimizedExpression(this.expressionString, false, this);
        this.temp_emfAnimationVariables = null;
        this.temp_allPartsBySingleAndFullHeirachicalId = null;
    }

    public float getLastResultOnly() {
        if (EMFAnimationEntityContext.getEMFEntity() == null) {
            return this.defaultValue;
        }
        return this.prevResult.getFloat((Object)EMFAnimationEntityContext.getEMFEntity().etf$getUuid());
    }

    public float getResultViaCalculate() {
        UUID id;
        UUID uUID = id = EMFAnimationEntityContext.getEMFEntity() == null ? null : EMFAnimationEntityContext.getEMFEntity().etf$getUuid();
        if (id == null) {
            return this.defaultValue;
        }
        float result = this.calculatorRun();
        this.prevResult.put((Object)id, result);
        return result;
    }

    private float calculatorRun() {
        float result = this.emfCalculator.getResult();
        if (Float.isNaN(result) || Math.abs(result) == Float.MIN_VALUE) {
            return this.defaultValue;
        }
        return result;
    }

    public void calculateAndSetIfNotPaused(@NotNull class_630[] paused) {
        for (class_630 part : paused) {
            if (this.partToApplyTo != part) continue;
            return;
        }
        this.calculateAndSet();
    }

    public void calculateAndSet() {
        if (EMFAnimationEntityContext.isLODSkippingThisFrame()) {
            if (!this.isVar()) {
                this.handleResultNonVariable(this.getLastResultOnly());
            }
        } else {
            this.calculateAndSetNotLod();
        }
    }

    private void calculateAndSetNotLod() {
        if (this.isVar()) {
            this.variableResultConsumer.accept(this.getResultViaCalculate());
        } else {
            this.handleResultNonVariable(this.getResultViaCalculate());
        }
    }

    private void handleResultNonVariable(float result) {
        if (this.modelOrRenderVariableToChange != null) {
            this.modelOrRenderVariableToChange.setValue(this.partToApplyTo, result);
        }
    }

    public boolean isValid() {
        return this.emfCalculator != MathExpressionParser.NULL_EXPRESSION;
    }
}

