/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.animation.math.methods.emf;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_3532;
import traben.entity_model_features.models.animation.EMFAnimation;
import traben.entity_model_features.models.animation.math.EMFMathException;
import traben.entity_model_features.models.animation.math.MathComponent;
import traben.entity_model_features.models.animation.math.MathMethod;
import traben.entity_model_features.models.animation.math.MathValue;

public class KeyframeloopMethod
extends MathMethod {
    public KeyframeloopMethod(List<String> args, boolean isNegative, EMFAnimation calculationInstance) throws EMFMathException {
        super(isNegative, calculationInstance, args.size());
        List<MathComponent> parsedArgs = KeyframeloopMethod.parseAllArgs(args, calculationInstance);
        MathComponent delta = parsedArgs.get(0);
        ArrayList<MathComponent> frames = new ArrayList<MathComponent>(parsedArgs);
        frames.remove(0);
        frames.add((MathComponent)frames.get(1));
        int max = frames.size() - 1;
        MathValue.ResultSupplier supplier = () -> {
            float deltaVal1 = delta.getResult() % (float)max;
            float deltaVal = deltaVal1 < 0.0f ? deltaVal1 + (float)max : deltaVal1;
            int frameIndex = (int)deltaVal;
            float frameDelta = deltaVal - (float)frameIndex;
            MathComponent lastFrame = (MathComponent)frames.get(frameIndex);
            MathComponent nextFrame = (MathComponent)frames.get(frameIndex + 1);
            return class_3532.method_16439((float)frameDelta, (float)lastFrame.getResult(), (float)nextFrame.getResult());
        };
        if (delta.isConstant()) {
            float deltaVal1 = delta.getResult() % (float)max;
            float deltaVal = deltaVal1 < 0.0f ? deltaVal1 + (float)max : deltaVal1;
            int frameIndex = (int)deltaVal;
            float frameDelta = deltaVal - (float)frameIndex;
            MathComponent lastFrame = (MathComponent)frames.get(frameIndex);
            MathComponent nextFrame = (MathComponent)frames.get(frameIndex + 1);
            this.setOptimizedAlternativeToThis(() -> class_3532.method_16439((float)frameDelta, (float)lastFrame.getResult(), (float)nextFrame.getResult()));
        }
        this.setSupplierAndOptimize(supplier, parsedArgs);
    }

    @Override
    protected boolean hasCorrectArgCount(int argCount) {
        return argCount >= 3;
    }
}

