/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.common.mixin.feature.stalled_chunk_load_detection;

import com.mojang.datafixers.util.Either;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1972;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2812;
import net.minecraft.class_3193;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.embeddedt.modernfix.ModernFix;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3215.class}, priority=1100)
public abstract class ServerChunkCacheMixin {
    @Shadow
    @Final
    private Thread field_17253;
    @Shadow
    @Final
    public class_3218 field_13945;
    @Shadow
    @Final
    private class_3215.class_4212 field_18809;
    private final boolean debugDeadServerAccess = Boolean.getBoolean("modernfix.debugBadChunkloading");

    @Shadow
    protected abstract CompletableFuture<Either<class_2791, class_3193.class_3724>> method_14134(int var1, int var2, class_2806 var3, boolean var4);

    @Inject(method={"getChunk"}, at={@At(value="HEAD")}, cancellable=true)
    private void bailIfServerDead(int chunkX, int chunkZ, class_2806 requiredStatus, boolean load, CallbackInfoReturnable<class_2791> cir) {
        CompletableFuture future;
        if (!this.field_13945.method_8503().method_3806() && !this.field_17253.isAlive()) {
            ModernFix.LOGGER.fatal("A mod is accessing chunks from a stopped server (this will also cause memory leaks)");
            if (this.debugDeadServerAccess) {
                new Exception().printStackTrace();
            }
            class_6880.class_6883 plains = this.field_13945.method_30349().method_30530(class_7924.field_41236).method_40290(class_1972.field_9451);
            cir.setReturnValue((Object)new class_2812((class_1937)this.field_13945, new class_1923(chunkX, chunkZ), (class_6880)plains));
        } else if (Thread.currentThread() != this.field_17253 && !(future = CompletableFuture.supplyAsync(() -> this.method_14134(chunkX, chunkZ, requiredStatus, false), (Executor)this.field_18809).join()).isDone()) {
            Either resultingChunk = null;
            try {
                resultingChunk = (Either)future.get(500L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException exception) {
                // empty catch block
            }
            if (resultingChunk != null && resultingChunk.left().isPresent()) {
                cir.setReturnValue((Object)((class_2791)resultingChunk.left().get()));
                return;
            }
            if (this.debugDeadServerAccess) {
                ModernFix.LOGGER.warn("Async loading of a chunk was requested, this might not be desirable", (Throwable)new Exception());
            }
            try {
                resultingChunk = (Either)future.get(10L, TimeUnit.SECONDS);
                if (resultingChunk.left().isPresent()) {
                    cir.setReturnValue((Object)((class_2791)resultingChunk.left().get()));
                    return;
                }
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                ModernFix.LOGGER.error("Async chunk load took way too long, this needs to be reported to the appropriate mod.", (Throwable)e);
            }
        }
    }
}

