/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.block;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.block.BlockPropertyModifier;
import net.mehvahdjukaar.polytone.colormap.Colormap;
import net.mehvahdjukaar.polytone.colormap.ColormapsManager;
import net.mehvahdjukaar.polytone.colormap.CompoundBlockColors;
import net.mehvahdjukaar.polytone.particle.ParticleEmitter;
import net.mehvahdjukaar.polytone.utils.ArrayImage;
import net.mehvahdjukaar.polytone.utils.LegacyHelper;
import net.mehvahdjukaar.polytone.utils.PartialReloader;
import net.mehvahdjukaar.polytone.utils.PropertiesUtils;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_322;
import net.minecraft.class_3300;
import net.minecraft.class_4309;
import net.minecraft.class_7923;

public class BlockPropertiesManager
extends PartialReloader<Resources> {
    private final Map<class_2248, BlockPropertyModifier> vanillaProperties = new HashMap<class_2248, BlockPropertyModifier>();
    private final Map<class_2248, BlockPropertyModifier> modifiers = new HashMap<class_2248, BlockPropertyModifier>();
    private final Map<class_2248, List<ParticleEmitter>> particleEmitters = new Object2ObjectOpenHashMap();
    private final Map<class_2960, String> optifineColormapsToBlocks = new HashMap<class_2960, String>();

    public BlockPropertiesManager() {
        super("block_properties");
    }

    @Override
    protected Resources prepare(class_3300 resourceManager) {
        HashMap<class_2960, JsonElement> jsons = new HashMap<class_2960, JsonElement>();
        class_4309.method_51148((class_3300)resourceManager, (String)this.path(), (Gson)GSON, jsons);
        BlockPropertiesManager.checkConditions(jsons);
        HashMap<class_2960, ArrayImage> textures = new HashMap<class_2960, ArrayImage>();
        Map<class_2960, ArrayImage> ofTextures = ArrayImage.gatherImages(resourceManager, "optifine/colormap");
        Map<class_2960, ArrayImage> cmTextures = ArrayImage.gatherImages(resourceManager, "colormatic/colormap");
        Map<class_2960, Properties> ofProperties = PropertiesUtils.gatherProperties(resourceManager, "optifine/colormap");
        HashMap<class_2960, JsonElement> ofJsons = new HashMap<class_2960, JsonElement>();
        class_4309.method_51148((class_3300)resourceManager, (String)"optifine/colormap", (Gson)GSON, ofJsons);
        BlockPropertiesManager.checkConditions(ofJsons);
        ofJsons.forEach((k, v) -> ofProperties.put((class_2960)k, PropertiesUtils.jsonToProperties(v)));
        textures.putAll(LegacyHelper.convertPaths(ofTextures));
        textures.putAll(LegacyHelper.convertPaths(cmTextures));
        textures.putAll(ArrayImage.gatherImages(resourceManager, this.path()));
        return new Resources(jsons, textures, LegacyHelper.convertPaths(ofProperties));
    }

    @Override
    public void process(Resources resources) {
        class_2960 id;
        Map<class_2960, JsonElement> jsons = resources.jsons();
        Map<class_2960, ArrayImage.Group> textures = ArrayImage.groupTextures(resources.textures());
        HashSet<class_2960> usedTextures = new HashSet<class_2960>();
        HashMap<class_2960, BlockPropertyModifier> parsedModifiers = new HashMap<class_2960, BlockPropertyModifier>();
        parsedModifiers.putAll(LegacyHelper.convertBlockProperties(resources.ofProperties, resources.textures));
        parsedModifiers.putAll(LegacyHelper.convertInlinedPalettes(this.optifineColormapsToBlocks));
        LegacyHelper.convertOfBlockToFluidProp(parsedModifiers, resources.textures);
        for (Map.Entry<class_2960, JsonElement> entry : jsons.entrySet()) {
            JsonElement json = entry.getValue();
            class_2960 id2 = entry.getKey();
            BlockPropertyModifier prop = (BlockPropertyModifier)((Pair)BlockPropertyModifier.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(false, errorMsg -> Polytone.LOGGER.warn("Could not decode Client Block Property with json id {} - error: {}", (Object)id2, errorMsg))).getFirst();
            if (parsedModifiers.containsKey(id2)) {
                Polytone.LOGGER.warn("Found duplicate block modifier with id {}. This is likely a non .json converted legacy oneOverriding previous one", (Object)id2);
            }
            parsedModifiers.put(id2, prop);
        }
        for (Map.Entry<Object, Object> entry : parsedModifiers.entrySet()) {
            ArrayImage.Group text;
            id = (class_2960)entry.getKey();
            BlockPropertyModifier modifier = (BlockPropertyModifier)entry.getValue();
            Optional<? extends class_322> colormap = modifier.tintGetter();
            if (colormap.isEmpty() && (text = textures.get(id)) != null) {
                CompoundBlockColors defaultSampler = CompoundBlockColors.createDefault((Set<Integer>)text.keySet(), true);
                modifier = modifier.merge(BlockPropertyModifier.ofColor(defaultSampler));
                colormap = modifier.tintGetter();
            }
            if (colormap.isPresent()) {
                class_322 tint = colormap.get();
                if (tint instanceof CompoundBlockColors) {
                    CompoundBlockColors c = (CompoundBlockColors)tint;
                    ColormapsManager.fillCompoundColormapPalette(textures, id, c, usedTextures);
                } else if (tint instanceof Colormap) {
                    Colormap c = (Colormap)tint;
                    ArrayImage.Group text2 = textures.get(c.getTargetTexture() == null ? id : c.getTargetTexture());
                    if (text2 != null) {
                        ColormapsManager.tryAcceptingTexture(text2.getDefault(), id, c, usedTextures);
                    } else if (c.getTargetTexture() != null) {
                        Polytone.LOGGER.error("Could not resolve explicit texture at location {}.png for colormap from block modifier {}. Skipping", (Object)c.getTargetTexture(), (Object)id);
                        continue;
                    }
                }
            }
            this.addModifier(id, modifier);
        }
        textures.keySet().removeAll(usedTextures);
        for (Map.Entry<Object, Object> entry : textures.entrySet()) {
            id = (class_2960)entry.getKey();
            ArrayImage.Group image = (ArrayImage.Group)((Object)entry.getValue());
            CompoundBlockColors tintMap = CompoundBlockColors.createDefault((Set<Integer>)image.keySet(), true);
            ColormapsManager.fillCompoundColormapPalette(textures, id, tintMap, usedTextures);
            BlockPropertyModifier modifier = BlockPropertyModifier.ofColor(tintMap);
            this.addModifier(id, modifier);
        }
    }

    private void addModifier(class_2960 modifierId, BlockPropertyModifier mod) {
        Colormap c;
        Object object;
        Optional<Set<class_2960>> explTargets = mod.explicitTargets();
        if (mod.tintGetter().isPresent() && (object = mod.tintGetter().get()) instanceof Colormap && !(c = (Colormap)object).hasTexture()) {
            Polytone.LOGGER.error("Did not find any texture png for implicit colormap from block modifier {}. Skipping", (Object)modifierId);
        }
        Optional implicitTarget = class_7923.field_41175.method_17966(modifierId);
        if (explTargets.isPresent()) {
            if (implicitTarget.isPresent() && !explTargets.get().contains(modifierId)) {
                Polytone.LOGGER.error("Found Block Properties Modifier with Explicit Targets ({}) also having a valid IMPLICIT Path Target ({}).Consider moving it under your OWN namespace to avoid overriding other packs modifiers with the same path", explTargets.get(), (Object)modifierId);
            }
            for (class_2960 explicitId : explTargets.get()) {
                Optional target = class_7923.field_41175.method_17966(explicitId);
                target.ifPresent(block -> this.modifiers.merge((class_2248)block, mod, BlockPropertyModifier::merge));
            }
        } else {
            implicitTarget.ifPresent(block -> this.modifiers.merge((class_2248)block, mod, BlockPropertyModifier::merge));
            if (implicitTarget.isEmpty() && PlatStuff.isModLoaded(modifierId.method_12836())) {
                Polytone.LOGGER.error("Found Block Properties Modifier with no implicit target (expected block with ID {}) and no explicit targets. Skipping", (Object)modifierId);
            }
        }
    }

    @Override
    public void apply() {
        for (Map.Entry<class_2248, BlockPropertyModifier> e : this.modifiers.entrySet()) {
            class_2248 block = e.getKey();
            BlockPropertyModifier value = e.getValue();
            this.vanillaProperties.put(block, value.apply(block));
            Optional<List<ParticleEmitter>> particle = value.particleEmitters();
            particle.ifPresent(emitters -> this.particleEmitters.put(block, (List<ParticleEmitter>)emitters));
        }
        if (!this.vanillaProperties.isEmpty()) {
            Polytone.LOGGER.info("Applied {} Custom Block Properties", (Object)this.vanillaProperties.size());
        }
        this.modifiers.clear();
    }

    @Override
    public void reset() {
        for (Map.Entry<class_2248, BlockPropertyModifier> e : this.vanillaProperties.entrySet()) {
            e.getValue().apply(e.getKey());
        }
        this.vanillaProperties.clear();
        this.modifiers.clear();
        this.optifineColormapsToBlocks.clear();
        this.particleEmitters.clear();
    }

    public void addSimpleColormap(class_2960 path, String str) {
        this.optifineColormapsToBlocks.put(path, str);
    }

    public void maybeEmitParticle(class_2248 block, class_2680 state, class_1937 level, class_2338 pos) {
        List<ParticleEmitter> m = this.particleEmitters.get(block);
        if (m != null) {
            for (ParticleEmitter p : m) {
                p.tick(level, pos, state);
            }
        }
    }

    public record Resources(Map<class_2960, JsonElement> jsons, Map<class_2960, ArrayImage> textures, Map<class_2960, Properties> ofProperties) {
    }
}

