/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.block;

import com.google.common.collect.UnmodifiableIterator;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.color.MapColorHelper;
import net.mehvahdjukaar.polytone.colormap.CompoundBlockColors;
import net.mehvahdjukaar.polytone.particle.ParticleEmitter;
import net.mehvahdjukaar.polytone.sound.SoundTypesManager;
import net.mehvahdjukaar.polytone.utils.StrOpt;
import net.mehvahdjukaar.polytone.utils.TargetsHelper;
import net.minecraft.class_2248;
import net.minecraft.class_243;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_322;
import net.minecraft.class_324;
import net.minecraft.class_3542;
import net.minecraft.class_3620;
import net.minecraft.class_4970;
import net.minecraft.class_7922;
import net.minecraft.class_7923;

public record BlockPropertyModifier(Optional<? extends class_322> tintGetter, Optional<class_2498> soundType, Optional<Function<class_2680, class_3620>> mapColor, Optional<ToIntFunction<class_2680>> clientLight, Optional<List<ParticleEmitter>> particleEmitters, Optional<class_4970.class_8176> offsetType, Optional<Set<class_2960>> explicitTargets) {
    public static final Decoder<BlockPropertyModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)StrOpt.of(CompoundBlockColors.CODEC, "colormap").forGetter(b -> b.tintGetter.flatMap(t -> {
        CompoundBlockColors c;
        return Optional.ofNullable(t instanceof CompoundBlockColors ? (c = (CompoundBlockColors)t) : null);
    })), (App)SoundTypesManager.CODEC.optionalFieldOf("sound_type").forGetter(BlockPropertyModifier::soundType), (App)StrOpt.of(MapColorHelper.CODEC.xmap(c -> a -> c, f -> class_3620.field_16008), "map_color").forGetter(BlockPropertyModifier::mapColor), (App)StrOpt.of(Codec.intRange((int)0, (int)15).xmap(integer -> s -> integer, toIntFunction -> 0), "client_light").forGetter(BlockPropertyModifier::clientLight), (App)StrOpt.of(ParticleEmitter.CODEC.listOf(), "particle_emitters").forGetter(BlockPropertyModifier::particleEmitters), (App)StrOpt.of(class_3542.method_28140(OffsetTypeR::values).xmap(OffsetTypeR::getFunction, offsetFunction -> OffsetTypeR.NONE), "offset_type").forGetter(BlockPropertyModifier::offsetType), (App)StrOpt.of(TargetsHelper.CODEC, "targets").forGetter(BlockPropertyModifier::explicitTargets)).apply((Applicative)instance, BlockPropertyModifier::new));

    public BlockPropertyModifier merge(BlockPropertyModifier other) {
        return new BlockPropertyModifier(other.tintGetter.isPresent() ? other.tintGetter() : this.tintGetter(), other.soundType().isPresent() ? other.soundType() : this.soundType(), other.mapColor.isPresent() ? other.mapColor() : this.mapColor(), other.clientLight.isPresent() ? other.clientLight : this.clientLight, other.particleEmitters.isPresent() ? other.particleEmitters : this.particleEmitters, other.offsetType().isPresent() ? other.offsetType() : this.offsetType(), TargetsHelper.merge(other.explicitTargets, this.explicitTargets));
    }

    public static BlockPropertyModifier ofColor(class_322 colormap) {
        return new BlockPropertyModifier(Optional.of(colormap), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public static BlockPropertyModifier coloringBlocks(class_322 colormap, class_2248 ... blocks) {
        return BlockPropertyModifier.coloringBlocks(colormap, Set.of((class_2960[])Arrays.stream(blocks).map(arg_0 -> ((class_7922)class_7923.field_41175).method_10221(arg_0)).toArray(class_2960[]::new)));
    }

    public static BlockPropertyModifier coloringBlocks(class_322 colormap, List<class_2248> blocks) {
        return BlockPropertyModifier.coloringBlocks(colormap, blocks.stream().map(arg_0 -> ((class_7922)class_7923.field_41175).method_10221(arg_0)).collect(Collectors.toSet()));
    }

    public static BlockPropertyModifier coloringBlocks(class_322 colormap, Set<class_2960> blocks) {
        return new BlockPropertyModifier(Optional.of(colormap), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(blocks));
    }

    public BlockPropertyModifier apply(class_2248 block) {
        class_2498 oldSound = null;
        if (this.soundType.isPresent()) {
            oldSound = block.field_23162;
            block.field_23162 = this.soundType.get();
        }
        Optional oldOffsetType = Optional.empty();
        boolean hasOffset = false;
        if (this.offsetType.isPresent()) {
            oldOffsetType = block.method_9564().field_42817;
            for (class_2680 s : block.method_9595().method_11662()) {
                s.field_42817 = this.offsetType;
                hasOffset = true;
            }
        }
        if (hasOffset) {
            block.field_23154 = true;
        }
        Function oldMapColor = null;
        if (this.mapColor.isPresent()) {
            oldMapColor = block.field_23155.field_10662;
            block.field_23155.field_10662 = this.mapColor.get();
            for (UnmodifiableIterator s : block.method_9595().method_11662()) {
                s.field_23171 = (class_3620)block.field_23155.field_10662.apply(s);
            }
        }
        ToIntFunction oldClientLight = null;
        if (this.clientLight.isPresent()) {
            oldClientLight = block.field_23155.field_10663;
            block.field_23155.field_10663 = this.clientLight.get();
            for (class_2680 s : block.method_9595().method_11662()) {
                s.field_23167 = block.field_23155.field_10663.applyAsInt(s);
            }
        }
        class_322 color = null;
        if (this.tintGetter.isPresent()) {
            class_324 blockColors = class_310.method_1551().method_1505();
            color = PlatStuff.getBlockColor(blockColors, block);
            blockColors.method_1690(this.tintGetter.get(), new class_2248[]{block});
        }
        return new BlockPropertyModifier(Optional.ofNullable(color), Optional.ofNullable(oldSound), Optional.ofNullable(oldMapColor), Optional.ofNullable(oldClientLight), Optional.empty(), oldOffsetType, Optional.empty());
    }

    public static enum OffsetTypeR implements class_3542
    {
        NONE(class_4970.class_2250.field_10656),
        XZ(class_4970.class_2250.field_10657),
        XYZ(class_4970.class_2250.field_10655);

        private final class_4970.class_2250 original;

        private OffsetTypeR(class_4970.class_2250 offsetType) {
            this.original = offsetType;
        }

        public String method_15434() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public class_4970.class_8176 getFunction() {
            class_4970.class_2251 p = class_4970.class_2251.method_9637().method_49229(this.original);
            return p.field_42818.orElse((blockState, blockGetter, blockPos) -> class_243.field_1353);
        }
    }
}

