/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.colormap;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.biome.BiomeIdMapper;
import net.mehvahdjukaar.polytone.colormap.IColormapNumberProvider;
import net.mehvahdjukaar.polytone.utils.ColorUtils;
import net.mehvahdjukaar.polytone.utils.ExpressionUtils;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;
import net.objecthunter.exp4j.function.Function;
import net.objecthunter.exp4j.operator.Operator;
import org.jetbrains.annotations.Nullable;

public final class ColormapExpressionProvider
implements IColormapNumberProvider {
    private static final String TEMPERATURE = "TEMPERATURE";
    private static final String DOWNFALL = "DOWNFALL";
    private static final String POS_X = "POS_X";
    private static final String POS_Y = "POS_Y";
    private static final String POS_Z = "POS_Z";
    private static final String BIOME_VALUE = "BIOME_VALUE";
    private static final String STATE_FUNC = "state_prop";
    private static final Function STATE_PROP = new Function("state_prop", 1){

        public double apply(double ... args) {
            class_2680 blockState = STATE_HACK.get();
            ArrayList properties = new ArrayList(blockState.method_28501());
            int index = (int)args[0];
            class_2769 p = (class_2769)properties.get(class_3532.method_15340((int)index, (int)0, (int)(properties.size() - 1)));
            ArrayList values = new ArrayList(p.method_11898());
            return (float)values.indexOf(blockState.method_11654(p)) / ((float)properties.size() - 1.0f);
        }
    };
    private static final Function STATE_PROP_INT = new Function("state_prop_i", 1){

        public double apply(double ... args) {
            class_2680 blockState = STATE_HACK.get();
            ArrayList properties = new ArrayList(blockState.method_28501());
            int index = (int)args[0];
            class_2769 p = (class_2769)properties.get(class_3532.method_15340((int)index, (int)0, (int)(properties.size() - 1)));
            ArrayList values = new ArrayList(p.method_11898());
            return values.indexOf(blockState.method_11654(p));
        }
    };
    private static final ThreadLocal<class_2680> STATE_HACK = new ThreadLocal();
    public static final Codec<ColormapExpressionProvider> CODEC = Codec.STRING.flatXmap(s -> {
        try {
            Expression compiled = ColormapExpressionProvider.createExpression(s);
            return DataResult.success((Object)new ColormapExpressionProvider(compiled, (String)s));
        }
        catch (Exception e) {
            return DataResult.error(() -> "Failed to parse expression:" + e.getMessage());
        }
    }, javaxExpression -> DataResult.success((Object)javaxExpression.unparsed));
    private final String unparsed;
    private final Expression expression;
    private final AtomicBoolean nonBlockingLock = new AtomicBoolean();

    private static Expression createExpression(String s) {
        return new ExpressionBuilder(ExpressionUtils.removeHex(s)).functions(ExpressionUtils.defFunc(STATE_PROP, STATE_PROP_INT)).variables(new String[]{TEMPERATURE, DOWNFALL, POS_X, POS_Y, POS_Z, BIOME_VALUE}).operator(ExpressionUtils.defOp(new Operator[0])).build();
    }

    private ColormapExpressionProvider(Expression expression, String unparsed) {
        this.expression = expression;
        this.unparsed = unparsed;
    }

    public static ColormapExpressionProvider make(String s) {
        return new ColormapExpressionProvider(ColormapExpressionProvider.createExpression(s), s);
    }

    @Override
    public boolean usesBiome() {
        return this.unparsed.contains(TEMPERATURE) || this.unparsed.contains(DOWNFALL) || this.unparsed.contains(BIOME_VALUE);
    }

    @Override
    public boolean usesPos() {
        return this.unparsed.contains(POS_X) || this.unparsed.contains(POS_Y) || this.unparsed.contains(POS_Z);
    }

    @Override
    public boolean usesState() {
        return this.unparsed.contains(STATE_FUNC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getValue(@Nullable class_2680 state, @Nullable class_2338 pos, @Nullable class_1959 biome, BiomeIdMapper mapper) {
        float result = 0.0f;
        boolean needsToUnlock = false;
        try {
            Expression exp = new Expression(this.expression);
            exp.setVariable(TEMPERATURE, biome != null ? (double)ColorUtils.getClimateSettings((class_1959)biome).comp_844 : 0.0);
            exp.setVariable(DOWNFALL, biome != null ? (double)ColorUtils.getClimateSettings((class_1959)biome).comp_846 : 0.0);
            exp.setVariable(POS_X, pos != null ? (double)pos.method_10263() : 0.0);
            exp.setVariable(POS_Y, pos != null ? (double)pos.method_10264() : 0.0);
            exp.setVariable(POS_Z, pos != null ? (double)pos.method_10260() : 0.0);
            STATE_HACK.set(state);
            result = (float)exp.evaluate();
            STATE_HACK.remove();
        }
        catch (Exception e) {
            Polytone.LOGGER.error("Failed to evaluate expression with value: {}", (Object)this.unparsed, (Object)e);
        }
        finally {
            if (needsToUnlock) {
                this.nonBlockingLock.set(false);
            }
        }
        return result;
    }
}

